/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.recommendation.entity.CCRecItemV2;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.model.AbstractModelProposer;

public class ShrinkComputedColumnProposer
extends AbstractModelProposer {
    public ShrinkComputedColumnProposer(AbstractContext.ModelContext modelCtx) {
        super(modelCtx);
    }

    @Override
    protected void execute(NDataModel modelDesc) {
        this.discardRedundantRecommendations(modelDesc);
        this.discardCCFieldIfNotApply(modelDesc);
    }

    private void discardRedundantRecommendations(NDataModel dataModel) {
        if (this.modelContext.getProposeContext().skipCollectRecommendations()) {
            return;
        }
        Map<String, CCRecItemV2> recItemMap = this.modelContext.getCcRecItemMap();
        dataModel.getComputedColumnDescs().forEach(cc -> {
            if (!this.isCCUsedByModel((ComputedColumnDesc)cc, dataModel)) {
                recItemMap.remove(cc.getUuid());
            }
        });
    }

    private void discardCCFieldIfNotApply(NDataModel model) {
        ArrayList originCC = Lists.newArrayList((Iterable)model.getComputedColumnDescs());
        originCC.removeIf(computedColumnDesc -> !this.isCCUsedByModel((ComputedColumnDesc)computedColumnDesc, model));
        model.setComputedColumnDescs((List)originCC);
    }

    private boolean isCCUsedByModel(ComputedColumnDesc cc, NDataModel model) {
        for (NDataModel.NamedColumn column : model.getAllNamedColumns()) {
            if (!column.isExist() || !column.getAliasDotColumn().equals(cc.getFullName())) continue;
            return true;
        }
        for (NDataModel.Measure allMeasure : model.getAllMeasures()) {
            for (ParameterDesc parameter : allMeasure.getFunction().getParameters()) {
                if (parameter.isConstantParameterDesc() || !parameter.getColRef().getColumnDesc().isComputedColumn() || !parameter.getColRef().getColumnDesc().getName().equals(cc.getColumnName())) continue;
                return true;
            }
        }
        return false;
    }
}

