/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.service;

import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.http.MediaType;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.service.Encoding;

public class Representation {
    private final MediaType mediaType;
    private final ModelSpecification model;
    private final Set<Encoding> encodings = new TreeSet<Encoding>(Comparator.comparing(Encoding::getPropertyRef));

    public Representation(MediaType mediaType, ModelSpecification model, Set<Encoding> encodings) {
        this.mediaType = mediaType;
        this.model = model;
        this.encodings.addAll(encodings);
    }

    public ModelSpecification getModel() {
        return this.model;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public Collection<Encoding> getEncodings() {
        return this.encodings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Representation other = (Representation)o;
        return Objects.equals(this.mediaType, other.mediaType) && Objects.equals(this.model, other.model) && this.encodings.equals(other.encodings);
    }

    public int hashCode() {
        return Objects.hash(this.mediaType, this.model, this.encodings);
    }

    public String toString() {
        return "Representation{mediaType=" + this.mediaType + ", model=" + this.model + ", encodings=" + this.encodings + '}';
    }
}

