/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.plugin.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.plugin.core.OrderAwarePluginRegistry;
import org.springframework.plugin.core.Plugin;
import org.springframework.util.Assert;

public interface PluginRegistry<T extends Plugin<S>, S>
extends Iterable<T> {
    public static <S, T extends Plugin<S>> PluginRegistry<T, S> empty() {
        return PluginRegistry.of(Collections.emptyList());
    }

    public static <S, T extends Plugin<S>> PluginRegistry<T, S> of(Comparator<? super T> comparator) {
        Assert.notNull(comparator, (String)"Comparator must not be null!");
        return PluginRegistry.of(Collections.emptyList(), comparator);
    }

    @SafeVarargs
    public static <S, T extends Plugin<S>> PluginRegistry<T, S> of(T ... plugins) {
        return PluginRegistry.of(Arrays.asList(plugins), OrderAwarePluginRegistry.DEFAULT_COMPARATOR);
    }

    public static <S, T extends Plugin<S>> PluginRegistry<T, S> of(List<? extends T> plugins) {
        return PluginRegistry.of(plugins, OrderAwarePluginRegistry.DEFAULT_COMPARATOR);
    }

    public static <S, T extends Plugin<S>> PluginRegistry<T, S> of(List<? extends T> plugins, Comparator<? super T> comparator) {
        Assert.notNull(plugins, (String)"Plugins must not be null!");
        Assert.notNull(comparator, (String)"Comparator must not be null!");
        return OrderAwarePluginRegistry.of(plugins, comparator);
    }

    public Optional<T> getPluginFor(S var1);

    public T getRequiredPluginFor(S var1) throws IllegalArgumentException;

    public T getRequiredPluginFor(S var1, Supplier<String> var2) throws IllegalArgumentException;

    public List<T> getPluginsFor(S var1);

    public <E extends Exception> T getPluginFor(S var1, Supplier<E> var2) throws E;

    public <E extends Exception> List<T> getPluginsFor(S var1, Supplier<E> var2) throws E;

    public T getPluginOrDefaultFor(S var1, T var2);

    public T getPluginOrDefaultFor(S var1, Supplier<T> var2);

    public List<T> getPluginsFor(S var1, List<? extends T> var2);

    public int countPlugins();

    public boolean contains(T var1);

    public boolean hasPluginFor(S var1);

    public List<T> getPlugins();
}

