/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.service.VendorExtension;

public class ListVendorExtension<T>
implements VendorExtension<List<T>> {
    private final List<T> values = new ArrayList<T>();
    private final String name;

    public ListVendorExtension(String name, List<T> values) {
        this.name = name;
        this.values.addAll(BuilderDefaults.nullToEmptyList(values));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<T> getValue() {
        return Collections.unmodifiableList(this.values);
    }

    public int hashCode() {
        return Objects.hash(this.values, this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListVendorExtension that = (ListVendorExtension)o;
        return Objects.equals(this.values, that.values) && Objects.equals(this.name, that.name);
    }
}

