/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.profiler;

import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.util.NLocalFileMetadataTestCase;
import org.apache.kylin.profiler.AsyncProfilerTool;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AsyncProfilerToolTest
extends NLocalFileMetadataTestCase {
    public static final String START_PARAMS = "start,event=cpu";
    public static final String DUMP_PARAMS = "flamegraph";

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void testLoadLocalAsyncProfilerLib() {
        AsyncProfilerTool.loadAsyncProfilerLib((boolean)true);
        String errorMsg = "";
        try {
            AsyncProfilerTool.status();
        }
        catch (Exception e) {
            errorMsg = e.getMessage();
        }
        Assert.assertTrue((boolean)errorMsg.isEmpty());
    }

    @Test
    public void testLoadRemoteAsyncProfilerLib() {
        AsyncProfilerTool.loadAsyncProfilerLib((boolean)false);
        String errorMsg = "";
        try {
            AsyncProfilerTool.status();
        }
        catch (Exception e) {
            errorMsg = e.getMessage();
        }
        Assert.assertTrue((boolean)errorMsg.isEmpty());
    }

    @Test
    public void testStartAndStop() {
        try {
            Assert.assertTrue((boolean)StringUtils.contains((CharSequence)AsyncProfilerTool.status(), (CharSequence)"Profiler is not active"));
            AsyncProfilerTool.start((String)START_PARAMS);
            AsyncProfilerTool.stop();
        }
        catch (IllegalStateException illegalState) {
            System.out.println(((Object)((Object)this)).getClass().getCanonicalName() + ": " + illegalState.getMessage());
        }
    }

    @Test
    public void testExecuteAndDump() {
        String errorMsg = "";
        try {
            AsyncProfilerTool.execute((String)START_PARAMS);
            AsyncProfilerTool.dump((String)DUMP_PARAMS);
            AsyncProfilerTool.stop();
        }
        catch (IllegalStateException illegalState) {
            System.out.println(((Object)((Object)this)).getClass().getCanonicalName() + ": " + illegalState.getMessage());
        }
        Assert.assertEquals((Object)"", (Object)errorMsg);
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)AsyncProfilerTool.status(), (CharSequence)"Profiler is not active"));
    }
}

