/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.test.TestingServer;
import org.apache.gluten.extension.columnar.heuristic.HeuristicTransform$;
import org.apache.kylin.common.util.NLocalFileMetadataTestCase;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.SparkSessionExtensions;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.common.LocalMetadata;
import org.apache.spark.sql.delta.KylinDeltaLogFileIndex;
import org.apache.spark.sql.execution.DataSourceScanExec;
import org.apache.spark.sql.execution.KylinFileSourceScanExec;
import org.apache.spark.sql.execution.KylinStorageScanExec;
import org.apache.spark.sql.execution.LayoutFileSourceScanExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanHelper;
import org.apache.spark.sql.execution.datasource.FilePruner;
import org.apache.spark.sql.execution.datasource.KylinDeltaSourceStrategy;
import org.apache.spark.sql.execution.datasource.KylinSourceStrategy$;
import org.apache.spark.sql.execution.datasource.LayoutFileSourceStrategy$;
import org.apache.spark.sql.execution.datasources.CacheFileScanRDD;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.FileScanRDD;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.gluten.KylinStorageScanExecTransformer;
import org.apache.spark.sql.sources.BaseRelation;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001\u0002\u0007\u000e\u0001aAQ!\r\u0001\u0005\u0002IBQ!\u000e\u0001\u0005BYBQ!\u0010\u0001\u0005BYBQA\u0010\u0001\u0005\n}BQ!\u0017\u0001\u0005\niCQ!\u0018\u0001\u0005\nyCQ!\u0019\u0001\u0005\u0002\tDQa\u001d\u0001\u0005\nQDa!a\u0007\u0001\t#1\u0004bBA\u000f\u0001\u0011E\u0011q\u0004\u0005\b\u0003\u0007\u0002A\u0011AA#\u0005qY\u0015\u0010\\5o\r&dWmU8ve\u000e,7kY1o\u000bb,7mU;ji\u0016T!AD\b\u0002\u0013\u0015DXmY;uS>t'B\u0001\t\u0012\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003%M\tQa\u001d9be.T!\u0001F\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0012aA8sO\u000e\u00011#\u0002\u0001\u001a;\u0015Z\u0003C\u0001\u000e\u001c\u001b\u0005\t\u0012B\u0001\u000f\u0012\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011adI\u0007\u0002?)\u0011\u0001%I\u0001\u0006a2\fgn\u001d\u0006\u0003E=\t\u0001bY1uC2L8\u000f^\u0005\u0003I}\u0011\u0011bU)M\u0011\u0016d\u0007/\u001a:\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!j\u0011\u0001C1eCB$\u0018N^3\n\u0005):#aF!eCB$\u0018N^3Ta\u0006\u00148\u000e\u00157b]\"+G\u000e]3s!\tas&D\u0001.\u0015\tqs\"\u0001\u0004d_6lwN\\\u0005\u0003a5\u0012Q\u0002T8dC2lU\r^1eCR\f\u0017A\u0002\u001fj]&$h\bF\u00014!\t!\u0004!D\u0001\u000e\u0003)\u0011WMZ8sK\u0016\u000b7\r\u001b\u000b\u0002oA\u0011\u0001hO\u0007\u0002s)\t!(A\u0003tG\u0006d\u0017-\u0003\u0002=s\t!QK\\5u\u0003%\tg\r^3s\u000b\u0006\u001c\u0007.A\rde\u0016\fG/Z*j[BdWMR5mKB\u0013XO\u001c8fe\u00123Ec\u0001!I\u0019B\u0011\u0011)\u0012\b\u0003\u0005\u000ek\u0011aD\u0005\u0003\t>\tq\u0001]1dW\u0006<W-\u0003\u0002G\u000f\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003\t>AQA\u0005\u0003A\u0002%\u0003\"A\u0011&\n\u0005-{!\u0001D*qCJ\\7+Z:tS>t\u0007\"B'\u0005\u0001\u0004q\u0015a\u0002;f[B$\u0015N\u001d\t\u0003\u001fZs!\u0001\u0015+\u0011\u0005EKT\"\u0001*\u000b\u0005M;\u0012A\u0002\u001fs_>$h(\u0003\u0002Vs\u00051\u0001K]3eK\u001aL!a\u0016-\u0003\rM#(/\u001b8h\u0015\t)\u0016(A\fde\u0016\fG/Z*j[BdWMR5mK\u0012+G\u000e^1E\rR\u0019\u0001i\u0017/\t\u000bI)\u0001\u0019A%\t\u000b5+\u0001\u0019\u0001(\u0002\u001d\r\u0014X-\u0019;f'&l\u0007\u000f\\3E\rR\u0019\u0001i\u00181\t\u000bI1\u0001\u0019A%\t\u000b53\u0001\u0019\u0001(\u0002!I,\u0007\u000f\\1dK\u001aKG.Z%oI\u0016DHcA2jWB\u0011AmZ\u0007\u0002K*\u0011amH\u0001\bY><\u0017nY1m\u0013\tAWMA\u0006M_\u001eL7-\u00197QY\u0006t\u0007\"\u00026\b\u0001\u0004\u0019\u0017A\u0002;be\u001e,G\u000fC\u0003m\u000f\u0001\u0007Q.A\u0005gS2,\u0017J\u001c3fqB\u0011a.]\u0007\u0002_*\u0011\u0001/D\u0001\fI\u0006$\u0018m]8ve\u000e,7/\u0003\u0002s_\nIa)\u001b7f\u0013:$W\r_\u0001\u0016O\u0016$h)\u001b7f'>,(oY3TG\u0006tW\t_3d)\r)\u00181\u0001\n\u0003mb4Aa\u001e\u0001\u0001k\naAH]3gS:,W.\u001a8u}A\u0011A'_\u0005\u0003u6\u0011!\u0003R1uCN{WO]2f'\u000e\fg.\u0012=fG\")AP\u001eD\u0001{\u0006A!/\u001a7bi&|g.F\u0001\u007f!\tqw0C\u0002\u0002\u0002=\u0014\u0001\u0003S1e_>\u0004hi\u001d*fY\u0006$\u0018n\u001c8\t\u000f\u0005\u0015\u0001\u00021\u0001\u0002\b\u0005\u0011AM\u001a\t\u0004\u0003\u0013)ebAA\u0006\u0007:!\u0011QBA\r\u001d\u0011\ty!a\u0006\u000f\t\u0005E\u0011Q\u0003\b\u0004#\u0006M\u0011\"\u0001\f\n\u0005Q)\u0012B\u0001\n\u0014\u0013\t\u0001\u0012#A\tdY\u0016\f'o\u00159be.\u001cVm]:j_:\f1b\u00195fG.\fen]<feR)q'!\t\u0002*!A\u0011Q\u0001\u0006\u0005\u0002\u0004\t\u0019\u0003E\u00039\u0003K\t9!C\u0002\u0002(e\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\b\u0003WQ\u0001\u0019AA\u0017\u00039)\u0007\u0010]3di\u0016$\u0017I\\:xKJ\u0004b!a\f\u00028\u0005ub\u0002BA\u0019\u0003kq1!UA\u001a\u0013\u0005Q\u0014B\u0001#:\u0013\u0011\tI$a\u000f\u0003\u0007M+\u0017O\u0003\u0002EsA\u0019!)a\u0010\n\u0007\u0005\u0005sBA\u0002S_^\fq#Y:tKJ$X)\u001c9us6K7o]5oO&s\u0007/\u001e;\u0015\u0007]\n9\u0005C\u0004\u0002J-\u0001\r!a\u0013\u0002\u000bE,XM]=1\t\u00055\u0013q\u000b\t\u0006\u0005\u0006=\u00131K\u0005\u0004\u0003#z!a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003+\n9\u0006\u0004\u0001\u0005\u0019\u0005e\u0013qIA\u0001\u0002\u0003\u0015\t!a\u0017\u0003\u0007}#\u0013'\u0005\u0003\u0002^\u0005\r\u0004c\u0001\u001d\u0002`%\u0019\u0011\u0011M\u001d\u0003\u000f9{G\u000f[5oOB\u0019\u0001(!\u001a\n\u0007\u0005\u001d\u0014HA\u0002B]f\u0004")
public class KylinFileSourceScanExecSuite
extends SparkFunSuite
implements SQLHelper,
AdaptiveSparkPlanHelper,
LocalMetadata {
    private String metadata;
    private NLocalFileMetadataTestCase metaStore;
    private TestingServer zkTestServer;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$common$LocalMetadata$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$common$LocalMetadata$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public void beforeAll() {
        LocalMetadata.beforeAll$(this);
    }

    @Override
    public void appendMetadata(String metadata) {
        LocalMetadata.appendMetadata$(this, metadata);
    }

    @Override
    public void overwriteSystemProp(String key, String value) {
        LocalMetadata.overwriteSystemProp$(this, key, value);
    }

    @Override
    public void afterAll() {
        LocalMetadata.afterAll$(this);
    }

    public Option<SparkPlan> find(SparkPlan p, Function1<SparkPlan, Object> f) {
        return AdaptiveSparkPlanHelper.find$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, f);
    }

    public void foreach(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreach$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, f);
    }

    public void foreachUp(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreachUp$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, f);
    }

    public <A> Seq<A> mapPlans(SparkPlan p, Function1<SparkPlan, A> f) {
        return AdaptiveSparkPlanHelper.mapPlans$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, f);
    }

    public <A> Seq<A> flatMap(SparkPlan p, Function1<SparkPlan, TraversableOnce<A>> f) {
        return AdaptiveSparkPlanHelper.flatMap$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, f);
    }

    public <B> Seq<B> collect(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collect$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, pf);
    }

    public Seq<SparkPlan> collectLeaves(SparkPlan p) {
        return AdaptiveSparkPlanHelper.collectLeaves$((AdaptiveSparkPlanHelper)this, (SparkPlan)p);
    }

    public <B> Option<B> collectFirst(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collectFirst$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, pf);
    }

    public <B> Seq<B> collectWithSubqueries(SparkPlan p, PartialFunction<SparkPlan, B> f) {
        return AdaptiveSparkPlanHelper.collectWithSubqueries$((AdaptiveSparkPlanHelper)this, (SparkPlan)p, f);
    }

    public Seq<SparkPlan> subqueriesAll(SparkPlan p) {
        return AdaptiveSparkPlanHelper.subqueriesAll$((AdaptiveSparkPlanHelper)this, (SparkPlan)p);
    }

    public SparkPlan stripAQEPlan(SparkPlan p) {
        return AdaptiveSparkPlanHelper.stripAQEPlan$((AdaptiveSparkPlanHelper)this, (SparkPlan)p);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    @Override
    public String metadata() {
        return this.metadata;
    }

    @Override
    public void metadata_$eq(String x$1) {
        this.metadata = x$1;
    }

    @Override
    public NLocalFileMetadataTestCase metaStore() {
        return this.metaStore;
    }

    @Override
    public void metaStore_$eq(NLocalFileMetadataTestCase x$1) {
        this.metaStore = x$1;
    }

    @Override
    public TestingServer zkTestServer() {
        return this.zkTestServer;
    }

    @Override
    public void zkTestServer_$eq(TestingServer x$1) {
        this.zkTestServer = x$1;
    }

    private String sparkHome$lzycompute() {
        KylinFileSourceScanExecSuite kylinFileSourceScanExecSuite = this;
        synchronized (kylinFileSourceScanExecSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    public void beforeEach() {
        this.clearSparkSession();
    }

    @Override
    public void afterEach() {
        this.clearSparkSession();
    }

    private Dataset<Row> createSimpleFilePrunnerDF(SparkSession spark, String tempDir) {
        Dataset<Row> df = this.createSimpleDF(spark, tempDir);
        LogicalPlan plan = df.queryExecution().logical();
        FilePruner fp = (FilePruner)Mockito.mock(FilePruner.class);
        Mockito.when((Object)fp.listFilesInternal((Seq)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any())).thenReturn((Object)Nil$.MODULE$);
        Mockito.when((Object)fp.metadataOpsTimeNs()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        Mockito.when((Object)fp.rootPaths()).thenReturn((Object)Nil$.MODULE$);
        return Dataset$.MODULE$.ofRows(spark, this.replaceFileIndex(plan, (FileIndex)fp));
    }

    private Dataset<Row> createSimpleFileDeltaDF(SparkSession spark, String tempDir) {
        Dataset<Row> df = this.createSimpleDF(spark, tempDir);
        LogicalPlan plan = df.queryExecution().logical();
        KylinDeltaLogFileIndex fp = (KylinDeltaLogFileIndex)Mockito.mock(KylinDeltaLogFileIndex.class);
        Mockito.when((Object)fp.listFiles((Seq)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any())).thenReturn((Object)Nil$.MODULE$);
        Mockito.when((Object)fp.metadataOpsTimeNs()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        Mockito.when((Object)fp.rootPaths()).thenReturn((Object)Nil$.MODULE$);
        Mockito.when((Object)fp.DeltaExpressionCache()).thenReturn((Object)CacheBuilder.newBuilder().expireAfterAccess(12L, TimeUnit.HOURS).build());
        return Dataset$.MODULE$.ofRows(spark, this.replaceFileIndex(plan, (FileIndex)fp));
    }

    private Dataset<Row> createSimpleDF(SparkSession spark, String tempDir) {
        spark.range(10L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id % 2 as a", "id % 3 as b", "id as c"})).write().parquet(tempDir);
        return spark.read().parquet(tempDir).where("a = 0").groupBy("b", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)"sum"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    public LogicalPlan replaceFileIndex(LogicalPlan target, FileIndex fileIndex) {
        return (LogicalPlan)target.transform((PartialFunction)new scala.Serializable(null, fileIndex){
            public static final long serialVersionUID = 0L;
            private final FileIndex fileIndex$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                LogicalRelation logicalRelation;
                BaseRelation hfsr;
                A1 A1 = x1;
                if (A1 instanceof LogicalRelation && (hfsr = (logicalRelation = (LogicalRelation)A1).relation()) instanceof HadoopFsRelation) {
                    HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)hfsr;
                    object = logicalRelation.copy((BaseRelation)hadoopFsRelation.copy(this.fileIndex$1, hadoopFsRelation.copy$default$2(), hadoopFsRelation.copy$default$3(), hadoopFsRelation.copy$default$4(), hadoopFsRelation.copy$default$5(), hadoopFsRelation.copy$default$6(), hadoopFsRelation.sparkSession()), logicalRelation.copy$default$2(), logicalRelation.copy$default$3(), logicalRelation.copy$default$4());
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalRelation logicalRelation;
                BaseRelation hfsr;
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof LogicalRelation && (hfsr = (logicalRelation = (LogicalRelation)logicalPlan).relation()) instanceof HadoopFsRelation;
                return bl;
            }
            {
                this.fileIndex$1 = fileIndex$1;
            }
        });
    }

    private DataSourceScanExec getFileSourceScanExec(Dataset<Row> df) {
        return (DataSourceScanExec)this.collectFirst(df.queryExecution().executedPlan(), (PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof KylinFileSourceScanExec) {
                    KylinFileSourceScanExec kylinFileSourceScanExec;
                    object = kylinFileSourceScanExec = (KylinFileSourceScanExec)A1;
                } else if (A1 instanceof KylinStorageScanExec) {
                    KylinStorageScanExec kylinStorageScanExec = (KylinStorageScanExec)A1;
                    object = kylinStorageScanExec;
                } else if (A1 instanceof LayoutFileSourceScanExec) {
                    LayoutFileSourceScanExec layoutFileSourceScanExec = (LayoutFileSourceScanExec)A1;
                    object = layoutFileSourceScanExec;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                boolean bl = sparkPlan instanceof KylinFileSourceScanExec ? true : (sparkPlan instanceof KylinStorageScanExec ? true : sparkPlan instanceof LayoutFileSourceScanExec);
                return bl;
            }
        }).get();
    }

    public void clearSparkSession() {
        SparkSession$.MODULE$.setActiveSession(null);
        SparkSession$.MODULE$.setDefaultSession(null);
        SparkSession$.MODULE$.cleanupAnyExistingSession();
    }

    public void checkAnswer(Function0<Dataset<Row>> df, Seq<Row> expectedAnswer) {
        Dataset dataset;
        try {
            dataset = (Dataset)df.apply();
        }
        catch (AnalysisException ae) {
            if (ae.plan().isDefined()) {
                throw this.fail(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(110).append("\n               |Failed to analyze query: ").append((Object)ae).append("\n               |").append(ae.plan().get()).append("\n               |\n               |").append(package$.MODULE$.stackTraceToString((Throwable)ae)).append("\n               |").toString())).stripMargin(), new Position("KylinFileSourceScanExecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
            }
            throw ae;
        }
        Dataset analyzedDF = dataset;
        this.assertEmptyMissingInput(analyzedDF);
        QueryTest$.MODULE$.checkAnswer(analyzedDF, expectedAnswer, true);
    }

    public void assertEmptyMissingInput(Dataset<?> query) {
        AttributeSet $org_scalatest_assert_macro_left = query.queryExecution().analyzed().missingInput();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(46).append("The analyzed logical plan has missing inputs:\n").append(query.queryExecution().analyzed()).toString(), Prettifier$.MODULE$.default(), new Position("KylinFileSourceScanExecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        AttributeSet $org_scalatest_assert_macro_left2 = query.queryExecution().optimizedPlan().missingInput();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(47).append("The optimized logical plan has missing inputs:\n").append(query.queryExecution().optimizedPlan()).toString(), Prettifier$.MODULE$.default(), new Position("KylinFileSourceScanExecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
        AttributeSet $org_scalatest_assert_macro_left3 = query.queryExecution().executedPlan().missingInput();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)new StringBuilder(38).append("The physical plan has missing inputs:\n").append(query.queryExecution().executedPlan()).toString(), Prettifier$.MODULE$.default(), new Position("KylinFileSourceScanExecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
    }

    public static final /* synthetic */ void $anonfun$new$2(SparkSessionExtensions ext) {
        ext.injectPlannerStrategy((Function1 & Serializable & scala.Serializable)x$1 -> KylinSourceStrategy$.MODULE$);
        ext.injectPlannerStrategy((Function1 & Serializable & scala.Serializable)x$2 -> LayoutFileSourceStrategy$.MODULE$);
        ext.injectPlannerStrategy((Function1 & Serializable & scala.Serializable)x$3 -> new KylinDeltaSourceStrategy());
    }

    public static final /* synthetic */ void $anonfun$new$6(KylinFileSourceScanExecSuite $this, SparkSession spark$1, File path) {
        String tempDir = path.getCanonicalPath();
        Dataset<Row> df = $this.createSimpleFilePrunnerDF(spark$1, tempDir);
        DataSourceScanExec $org_scalatest_assert_macro_left = $this.getFileSourceScanExec(df);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.sql.execution.KylinFileSourceScanExec", $org_scalatest_assert_macro_left instanceof KylinFileSourceScanExec, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KylinFileSourceScanExecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        RDD $org_scalatest_assert_macro_left2 = ((KylinFileSourceScanExec)$this.getFileSourceScanExec(df)).inputRDD();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.execution.datasources.CacheFileScanRDD", $org_scalatest_assert_macro_left2 instanceof CacheFileScanRDD, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KylinFileSourceScanExecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
    }

    public static final /* synthetic */ void $anonfun$new$7(KylinFileSourceScanExecSuite $this, SparkSession spark$1, File path) {
        String tempDir = path.getCanonicalPath();
        Dataset<Row> df = $this.createSimpleFileDeltaDF(spark$1, tempDir);
        DataSourceScanExec $org_scalatest_assert_macro_left = $this.getFileSourceScanExec(df);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.sql.execution.KylinStorageScanExec", $org_scalatest_assert_macro_left instanceof KylinStorageScanExec, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KylinFileSourceScanExecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        RDD $org_scalatest_assert_macro_left2 = ((KylinStorageScanExec)$this.getFileSourceScanExec(df)).inputRDD();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.execution.datasources.CacheFileScanRDD", $org_scalatest_assert_macro_left2 instanceof CacheFileScanRDD, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KylinFileSourceScanExecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
    }

    public static final /* synthetic */ void $anonfun$new$9(SparkSessionExtensions ext) {
        ext.injectPlannerStrategy((Function1 & Serializable & scala.Serializable)x$4 -> KylinSourceStrategy$.MODULE$);
        ext.injectPlannerStrategy((Function1 & Serializable & scala.Serializable)x$5 -> LayoutFileSourceStrategy$.MODULE$);
        ext.injectPlannerStrategy((Function1 & Serializable & scala.Serializable)x$6 -> new KylinDeltaSourceStrategy());
    }

    public static final /* synthetic */ void $anonfun$new$13(KylinFileSourceScanExecSuite $this, SparkSession spark$2, File path) {
        String tempDir = path.getCanonicalPath();
        Dataset<Row> df = $this.createSimpleFileDeltaDF(spark$2, tempDir);
        SparkPlan transformed = HeuristicTransform$.MODULE$.static().apply(df.queryExecution().executedPlan());
        Seq res = transformed.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                KylinStorageScanExecTransformer kylinStorageScanExecTransformer;
                A1 A1 = x1;
                Object object = A1 instanceof KylinStorageScanExecTransformer ? (kylinStorageScanExecTransformer = (KylinStorageScanExecTransformer)A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                boolean bl = sparkPlan instanceof KylinStorageScanExecTransformer;
                return bl;
            }
        });
        $this.assertResult(BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)res.size()), Prettifier$.MODULE$.default(), new Position("KylinFileSourceScanExecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
    }

    public static final /* synthetic */ void $anonfun$new$16(SparkSessionExtensions ext) {
        ext.injectPlannerStrategy((Function1 & Serializable & scala.Serializable)x$7 -> KylinSourceStrategy$.MODULE$);
        ext.injectPlannerStrategy((Function1 & Serializable & scala.Serializable)x$8 -> LayoutFileSourceStrategy$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$new$15(KylinFileSourceScanExecSuite $this, File path) {
        SparkSession$.MODULE$.cleanupAnyExistingSession();
        String tempDir = path.getCanonicalPath();
        SparkSession spark = SparkSession$.MODULE$.builder().master("local[1]").config("spark.kylin.soft-affinity.enabled", "false").withExtensions((Function1 & Serializable & scala.Serializable)ext -> {
            KylinFileSourceScanExecSuite.$anonfun$new$16(ext);
            return BoxedUnit.UNIT;
        }).getOrCreate();
        Dataset<Row> df = $this.createSimpleFilePrunnerDF(spark, tempDir);
        RDD $org_scalatest_assert_macro_left = ((KylinFileSourceScanExec)$this.getFileSourceScanExec(df)).inputRDD();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.sql.execution.datasources.FileScanRDD", $org_scalatest_assert_macro_left instanceof FileScanRDD, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KylinFileSourceScanExecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        spark.sparkContext().stop();
    }

    public static final /* synthetic */ void $anonfun$new$21(SparkSessionExtensions ext) {
        ext.injectPlannerStrategy((Function1 & Serializable & scala.Serializable)x$9 -> KylinSourceStrategy$.MODULE$);
        ext.injectPlannerStrategy((Function1 & Serializable & scala.Serializable)x$10 -> LayoutFileSourceStrategy$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$new$20(KylinFileSourceScanExecSuite $this, File path) {
        SparkSession$.MODULE$.cleanupAnyExistingSession();
        String tempDir = path.getCanonicalPath();
        SparkSession spark = SparkSession$.MODULE$.builder().master("local[1]").config("spark.kylin.soft-affinity.enabled", "true").config("spark.hadoop.spark.kylin.soft-affinity.enabled", "true").config("spark.hadoop.fs.file.impl", "org.apache.kylin.cache.kylin.OnlyForTestCacheFileSystem").config("fs.file.impl.disable.cache", "true").config("spark.extraListeners", "org.apache.kylin.softaffinity.scheduler.SoftAffinityListener").config("spark.hadoop.spark.kylin.local-cache.enabled", "true").config("spark.hadoop.spark.kylin.local-cache.use.legacy.file-input-stream", "true").config("spark.hadoop.spark.kylin.local-cache.use.buffer.file-input-stream", "false").withExtensions((Function1 & Serializable & scala.Serializable)ext -> {
            KylinFileSourceScanExecSuite.$anonfun$new$21(ext);
            return BoxedUnit.UNIT;
        }).getOrCreate();
        Dataset<Row> df = $this.createSimpleDF(spark, tempDir);
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)6)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)10)})), (List)Nil$.MODULE$)))));
        spark.sparkContext().stop();
    }

    public static final /* synthetic */ void $anonfun$new$27(SparkSessionExtensions ext) {
        ext.injectPlannerStrategy((Function1 & Serializable & scala.Serializable)x$11 -> KylinSourceStrategy$.MODULE$);
        ext.injectPlannerStrategy((Function1 & Serializable & scala.Serializable)x$12 -> LayoutFileSourceStrategy$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$new$26(KylinFileSourceScanExecSuite $this, File path) {
        SparkSession$.MODULE$.cleanupAnyExistingSession();
        String tempDir = path.getCanonicalPath();
        SparkSession spark = SparkSession$.MODULE$.builder().master("local[1]").config("spark.kylin.soft-affinity.enabled", "true").config("spark.hadoop.spark.kylin.soft-affinity.enabled", "true").config("spark.hadoop.fs.file.impl", "org.apache.kylin.cache.kylin.OnlyForTestCacheFileSystem").config("fs.file.impl.disable.cache", "true").config("spark.extraListeners", "org.apache.kylin.softaffinity.scheduler.SoftAffinityListener").config("spark.hadoop.spark.kylin.local-cache.enabled", "true").config("spark.hadoop.spark.kylin.local-cache.use.legacy.file-input-stream", "false").config("spark.hadoop.spark.kylin.local-cache.use.buffer.file-input-stream", "true").withExtensions((Function1 & Serializable & scala.Serializable)ext -> {
            KylinFileSourceScanExecSuite.$anonfun$new$27(ext);
            return BoxedUnit.UNIT;
        }).getOrCreate();
        Dataset<Row> df = $this.createSimpleDF(spark, tempDir);
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)6)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)4)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)10)})), (List)Nil$.MODULE$)))));
        spark.sparkContext().stop();
    }

    public KylinFileSourceScanExecSuite() {
        SQLHelper.$init$((SQLHelper)this);
        AdaptiveSparkPlanHelper.$init$((AdaptiveSparkPlanHelper)this);
        LocalMetadata.$init$(this);
        this.test("Create sharding read RDD with Soft affinity - CacheFileScanRDD", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkSession$.MODULE$.cleanupAnyExistingSession();
            SparkSession spark = SparkSession$.MODULE$.builder().master("local[1]").config("spark.kylin.soft-affinity.enabled", "true").withExtensions((Function1 & Serializable & scala.Serializable)ext -> {
                KylinFileSourceScanExecSuite.$anonfun$new$2(ext);
                return BoxedUnit.UNIT;
            }).getOrCreate();
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
                KylinFileSourceScanExecSuite.$anonfun$new$6(this, spark, path);
                return BoxedUnit.UNIT;
            });
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
                KylinFileSourceScanExecSuite.$anonfun$new$7(this, spark, path);
                return BoxedUnit.UNIT;
            });
            spark.sparkContext().stop();
        }, new Position("KylinFileSourceScanExecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        this.test("[Gluten] Create sharding read RDD with Soft affinity - CacheFileScanRDD", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            String chLibPath = System.getProperty("clickhouse.lib.path");
            if (StringUtils.isEmpty((CharSequence)chLibPath) || !new File(chLibPath).exists()) {
                this.log().warn("-Dclickhouse.lib.path is not set or path not exists, skip gluten config");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                SparkSession$.MODULE$.cleanupAnyExistingSession();
                SparkSession spark = SparkSession$.MODULE$.builder().master("local[1]").config("spark.kylin.soft-affinity.enabled", "true").config("spark.sql.shuffle.partitions", "1").config("spark.sql.adaptive.enabled", "false").config("spark.plugins", "org.apache.gluten.GlutenPlugin").config("spark.shuffle.manager", "org.apache.spark.shuffle.sort.ColumnarShuffleManager").config("spark.io.compression.codec", "LZ4").config("spark.gluten.sql.columnar.libpath", chLibPath).config("spark.gluten.sql.enable.native.validation", "false").config("spark.memory.offHeap.enabled", "true").config("spark.memory.offHeap.size", "2G").config("spark.gluten.sql.columnar.extended.columnar.pre.rules", "org.apache.spark.sql.execution.gluten.ConvertKylinFileSourceToGlutenRule").withExtensions((Function1 & Serializable & scala.Serializable)ext -> {
                    KylinFileSourceScanExecSuite.$anonfun$new$9(ext);
                    return BoxedUnit.UNIT;
                }).getOrCreate();
                this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
                    KylinFileSourceScanExecSuite.$anonfun$new$13(this, spark, path);
                    return BoxedUnit.UNIT;
                });
                spark.sparkContext().stop();
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        }, new Position("KylinFileSourceScanExecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        this.test("Create sharding read RDD without Soft affinity - FileScanRDD", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
            KylinFileSourceScanExecSuite.$anonfun$new$15(this, path);
            return BoxedUnit.UNIT;
        }), new Position("KylinFileSourceScanExecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        this.test("Create sharding read RDD with Soft affinity and Local cache - legacy in stream", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
            KylinFileSourceScanExecSuite.$anonfun$new$20(this, path);
            return BoxedUnit.UNIT;
        }), new Position("KylinFileSourceScanExecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        this.test("Create sharding read RDD with Soft affinity and Local cache - buffer in stream", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
            KylinFileSourceScanExecSuite.$anonfun$new$26(this, path);
            return BoxedUnit.UNIT;
        }), new Position("KylinFileSourceScanExecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
    }
}

