/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.jobs;

import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.cube.utils.StreamingUtils;
import org.apache.kylin.streaming.jobs.SparkJobLauncher;
import org.apache.kylin.streaming.jobs.StreamingJobListener;
import org.apache.kylin.streaming.manager.StreamingJobManager;
import org.apache.kylin.streaming.metadata.StreamingJobMeta;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.launcher.SparkLauncher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSparkJobLauncher
implements SparkJobLauncher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractSparkJobLauncher.class);
    protected KylinConfig config;
    protected String project;
    protected String modelId;
    protected String jobId;
    protected SparkAppHandle handler;
    protected SparkAppHandle.Listener listener;
    protected Map<String, String> env;
    protected StreamingJobManager streamingJobManager;
    protected StreamingJobMeta strmJob;
    protected JobTypeEnum jobType;
    protected String kylinJobJar;
    protected SparkLauncher launcher;

    protected static String javaPropertyFormatter(@Nonnull String key, @Nullable String value) {
        Preconditions.checkNotNull((Object)key, (Object)"the key of java property cannot be empty");
        return String.format(Locale.ROOT, " -D%s=%s ", key, value);
    }

    protected static Map<String, String> getStreamingSparkConfig(KylinConfig config) {
        return config.getStreamingSparkConfigOverride().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("spark.")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    protected static Map<String, String> getStreamingKafkaConfig(KylinConfig config) {
        return config.getStreamingKafkaConfigOverride();
    }

    @Override
    public void init(String project, String modelId, JobTypeEnum jobType) {
        this.project = project;
        this.modelId = modelId;
        this.jobId = StreamingUtils.getJobId((String)modelId, (String)jobType.name());
        this.jobType = jobType;
        this.env = Maps.newHashMap();
        this.config = KylinConfig.getInstanceFromEnv();
        this.kylinJobJar = this.config.getStreamingJobJarPath();
        this.listener = new StreamingJobListener(project, this.jobId);
        this.streamingJobManager = StreamingJobManager.getInstance(this.config, project);
        this.strmJob = this.streamingJobManager.getStreamingJobByUuid(StreamingUtils.getJobId((String)modelId, (String)jobType.name()));
        this.env.put("HADOOP_CONF_DIR", HadoopUtil.getHadoopConfDir());
        if (StringUtils.isEmpty((CharSequence)this.kylinJobJar) && !this.config.isUTEnv()) {
            throw new IllegalArgumentException("Missing kylin job jar");
        }
        this.launcher = new SparkLauncher(this.env);
        log.info("The {} - {} initialized successfully...", (Object)jobType, (Object)this.jobId);
    }

    @Override
    public abstract void launch();

    @Override
    public abstract void stop();
}

