/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.mapreduce;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;
import org.apache.orc.mapred.OrcMapredRecordReader;
import org.apache.orc.mapred.OrcStruct;

public class OrcMapreduceRecordReader<V extends WritableComparable>
extends org.apache.hadoop.mapreduce.RecordReader<NullWritable, V> {
    private final TypeDescription schema;
    private final RecordReader batchReader;
    private final VectorizedRowBatch batch;
    private int rowInBatch;
    private final V row;

    public OrcMapreduceRecordReader(RecordReader reader, TypeDescription schema) throws IOException {
        this.batchReader = reader;
        this.batch = schema.createRowBatch();
        this.schema = schema;
        this.rowInBatch = 0;
        this.row = OrcStruct.createValue(schema);
    }

    public OrcMapreduceRecordReader(Reader fileReader, Reader.Options options) throws IOException {
        this(fileReader, options, 1024);
    }

    public OrcMapreduceRecordReader(Reader fileReader, Reader.Options options, int rowBatchSize) throws IOException {
        this.batchReader = fileReader.rows(options);
        this.schema = options.getSchema() == null ? fileReader.getSchema() : options.getSchema();
        this.batch = this.schema.createRowBatch(rowBatchSize);
        this.rowInBatch = 0;
        this.row = OrcStruct.createValue(this.schema);
    }

    boolean ensureBatch() throws IOException {
        if (this.rowInBatch >= this.batch.size) {
            this.rowInBatch = 0;
            return this.batchReader.nextBatch(this.batch);
        }
        return true;
    }

    public void close() throws IOException {
        this.batchReader.close();
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) {
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (!this.ensureBatch()) {
            return false;
        }
        if (this.schema.getCategory() == TypeDescription.Category.STRUCT) {
            OrcStruct result = (OrcStruct)this.row;
            List children = this.schema.getChildren();
            int numberOfChildren = children.size();
            for (int i = 0; i < numberOfChildren; ++i) {
                result.setFieldValue(i, OrcMapredRecordReader.nextValue(this.batch.cols[i], this.rowInBatch, (TypeDescription)children.get(i), result.getFieldValue(i)));
            }
        } else {
            OrcMapredRecordReader.nextValue(this.batch.cols[0], this.rowInBatch, this.schema, this.row);
        }
        ++this.rowInBatch;
        return true;
    }

    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return NullWritable.get();
    }

    public V getCurrentValue() throws IOException, InterruptedException {
        return this.row;
    }

    public float getProgress() throws IOException {
        return this.batchReader.getProgress();
    }
}

