/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import lombok.Generated;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.util.ArgsTypeJsonDeserializer;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ArgsTypeJsonDeserializerTest {
    private static final ObjectMapper mapper = new ObjectMapper();

    ArgsTypeJsonDeserializerTest() {
    }

    @Test
    void testDeserialize() throws Exception {
        KylinException kylinException;
        HashMap map = Maps.newHashMap();
        map.put("bol_value", "null");
        map.put("int_value", "null");
        String jsonStr = mapper.writeValueAsString((Object)map);
        MockRequest request = (MockRequest)mapper.readValue(jsonStr, MockRequest.class);
        Assertions.assertEquals((Object)false, (Object)request.getBolValue());
        Assertions.assertEquals((int)0, (Integer)request.getIntValue());
        map = Maps.newHashMap();
        map.put("bol_value", "");
        map.put("int_value", "");
        jsonStr = mapper.writeValueAsString((Object)map);
        request = (MockRequest)mapper.readValue(jsonStr, MockRequest.class);
        Assertions.assertEquals((Object)false, (Object)request.getBolValue());
        Assertions.assertEquals((int)0, (Integer)request.getIntValue());
        map = Maps.newHashMap();
        map.put("bol_value", null);
        map.put("int_value", null);
        jsonStr = mapper.writeValueAsString((Object)map);
        request = (MockRequest)mapper.readValue(jsonStr, MockRequest.class);
        Assertions.assertEquals((Object)false, (Object)request.getBolValue());
        Assertions.assertEquals((int)0, (Integer)request.getIntValue());
        map = Maps.newHashMap();
        jsonStr = mapper.writeValueAsString((Object)map);
        request = (MockRequest)mapper.readValue(jsonStr, MockRequest.class);
        Assertions.assertEquals((Object)true, (Object)request.getBolValue());
        Assertions.assertEquals((int)1, (Integer)request.getIntValue());
        map = Maps.newHashMap();
        map.put("bol_value", "true");
        map.put("int_value", "99");
        jsonStr = mapper.writeValueAsString((Object)map);
        request = (MockRequest)mapper.readValue(jsonStr, MockRequest.class);
        Assertions.assertEquals((Object)true, (Object)request.getBolValue());
        Assertions.assertEquals((int)99, (Integer)request.getIntValue());
        map = Maps.newHashMap();
        map.put("bol_value", "true");
        map.put("int_value", "99");
        jsonStr = mapper.writeValueAsString((Object)map);
        request = (MockRequest)mapper.readValue(jsonStr, MockRequest.class);
        Assertions.assertEquals((Object)true, (Object)request.getBolValue());
        Assertions.assertEquals((int)99, (Integer)request.getIntValue());
        map = Maps.newHashMap();
        map.put("bol_value", "abc");
        jsonStr = mapper.writeValueAsString((Object)map);
        try {
            mapper.readValue(jsonStr, MockRequest.class);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof JsonMappingException));
            Assertions.assertTrue((boolean)(e.getCause() instanceof KylinException));
            kylinException = (KylinException)e.getCause();
            Assertions.assertEquals((Object)ErrorCodeServer.ARGS_TYPE_CHECK.getErrorCode().getCode(), (Object)kylinException.getErrorCode().getCodeString());
        }
        map = Maps.newHashMap();
        map.put("int_value", "abc");
        jsonStr = mapper.writeValueAsString((Object)map);
        try {
            mapper.readValue(jsonStr, MockRequest.class);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof JsonMappingException));
            Assertions.assertTrue((boolean)(e.getCause() instanceof KylinException));
            kylinException = (KylinException)e.getCause();
            Assertions.assertEquals((Object)ErrorCodeServer.ARGS_TYPE_CHECK.getErrorCode().getCode(), (Object)kylinException.getErrorCode().getCodeString());
        }
    }

    static class MockRequest {
        @JsonDeserialize(using=ArgsTypeJsonDeserializer.BooleanJsonDeserializer.class)
        @JsonProperty(value="bol_value")
        private Boolean bolValue = true;
        @JsonDeserialize(using=ArgsTypeJsonDeserializer.IntegerJsonDeserializer.class)
        @JsonProperty(value="int_value")
        private Integer intValue = 1;

        @Generated
        public MockRequest() {
        }

        @Generated
        public Boolean getBolValue() {
            return this.bolValue;
        }

        @Generated
        public Integer getIntValue() {
            return this.intValue;
        }

        @Generated
        public void setBolValue(Boolean bolValue) {
            this.bolValue = bolValue;
        }

        @Generated
        public void setIntValue(Integer intValue) {
            this.intValue = intValue;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MockRequest)) {
                return false;
            }
            MockRequest other = (MockRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$bolValue = this.getBolValue();
            Boolean other$bolValue = other.getBolValue();
            if (this$bolValue == null ? other$bolValue != null : !((Object)this$bolValue).equals(other$bolValue)) {
                return false;
            }
            Integer this$intValue = this.getIntValue();
            Integer other$intValue = other.getIntValue();
            return !(this$intValue == null ? other$intValue != null : !((Object)this$intValue).equals(other$intValue));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MockRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $bolValue = this.getBolValue();
            result = result * 59 + ($bolValue == null ? 43 : ((Object)$bolValue).hashCode());
            Integer $intValue = this.getIntValue();
            result = result * 59 + ($intValue == null ? 43 : ((Object)$intValue).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ArgsTypeJsonDeserializerTest.MockRequest(bolValue=" + this.getBolValue() + ", intValue=" + this.getIntValue() + ")";
        }
    }
}

