/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.Arrays;
import java.util.TimeZone;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.TimeZoneUtils;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.apache.kylin.junit.annotation.MultiTimezoneTest;
import org.junit.Assert;

@MetadataInfo(onlyProps=true)
public class TimeZoneUtilsTest {
    @MultiTimezoneTest(timezones={"UTC", "GMT+8", "GMT+15"})
    public void testSetDefaultTimeZone() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        TimeZoneUtils.setDefaultTimeZone((KylinConfig)kylinConfig);
        Assert.assertEquals((Object)TimeZone.getDefault().getID(), (Object)TimeZone.getDefault().toZoneId().getId());
        for (String timeZone : Arrays.asList("GMT+8", "CST", "PST", "UTC")) {
            kylinConfig.setProperty("kylin.web.timezone", timeZone);
            TimeZoneUtils.setDefaultTimeZone((KylinConfig)kylinConfig);
            Assert.assertEquals((Object)TimeZone.getDefault().getID(), (Object)TimeZone.getDefault().toZoneId().getId());
        }
    }
}

