/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.List;
import org.apache.kylin.engine.spark.utils.ExecutableHandleUtils;
import org.apache.kylin.engine.spark.utils.SparkJobFactoryUtils;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultExecutableOnModel;
import org.apache.kylin.job.execution.ExecutableHandler;
import org.apache.kylin.job.execution.MergerInfo;
import org.apache.kylin.job.util.ExecutableParaUtil;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutableAddCuboidHandler
extends ExecutableHandler {
    private static final Logger logger = LoggerFactory.getLogger(ExecutableAddCuboidHandler.class);

    public ExecutableAddCuboidHandler(DefaultExecutableOnModel job) {
        this(job.getProject(), job.getTargetSubject(), job.getSubmitter(), null, job.getId());
    }

    public ExecutableAddCuboidHandler(String project, String modelId, String owner, String segmentId, String jobId) {
        super(project, modelId, owner, segmentId, jobId);
    }

    public void handleFinished() {
        String project = this.getProject();
        String jobId = this.getJobId();
        String modelId = this.getModelId();
        DefaultExecutableOnModel executable = this.getExecutable();
        Preconditions.checkState((executable.getTasks().size() > 1 ? 1 : 0) != 0, (Object)("job " + jobId + " steps is not enough"));
        int errorOrPausedJobCount = this.getErrorOrPausedJobCount();
        String toBeDeletedLayoutIdsStr = ExecutableParaUtil.getToBeDeletedLayoutIdsStr((AbstractExecutable)executable);
        MergerInfo mergerInfo = new MergerInfo(project, toBeDeletedLayoutIdsStr, modelId, jobId, errorOrPausedJobCount, ExecutableHandler.HandlerType.ADD_CUBOID);
        ExecutableHandleUtils.getNeedMergeTasks(executable).forEach(task -> mergerInfo.addTaskMergeInfo(task, SparkJobFactoryUtils.needBuildSnapshots(task)));
        List<NDataLayout[]> mergedLayout = ExecutableHandleUtils.mergeMetadata(project, mergerInfo);
        List<AbstractExecutable> tasks = ExecutableHandleUtils.getNeedMergeTasks(executable);
        for (int idx = 0; idx < mergedLayout.size(); ++idx) {
            AbstractExecutable task2 = tasks.get(idx);
            NDataLayout[] layouts = mergedLayout.get(idx);
            ExecutableHandleUtils.recordDownJobStats(task2, layouts, project);
            task2.notifyUserIfNecessary(layouts);
        }
    }

    public void handleDiscardOrSuicidal() {
        DefaultExecutableOnModel job = this.getExecutable();
        if (!job.checkCuttingInJobByModel() || !job.checkAnyTargetSegmentAndPartitionExists()) {
            return;
        }
    }
}

