/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.engine.spark.utils.ExecutableHandleUtils;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.JobContext;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableHandler;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.execution.MergerInfo;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.table.InternalTableDesc;
import org.apache.kylin.metadata.table.InternalTableManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalTableLoadingStep
extends NSparkExecutable {
    private static final Logger logger = LoggerFactory.getLogger(InternalTableLoadingStep.class);

    public InternalTableLoadingStep(String sparkSubmitClassName) {
        this.setSparkSubmitClassName(sparkSubmitClassName);
        Boolean dropPartition = Boolean.parseBoolean(this.getParam("deletePartition"));
        if (dropPartition.booleanValue()) {
            this.setName("Drop Internal Table Partition");
        }
        this.setName("Load Internal Table");
    }

    public InternalTableLoadingStep(Object notSetId) {
        super(notSetId);
    }

    @Override
    protected Set<String> getMetadataDumpList(KylinConfig config) {
        HashSet dumpList = Sets.newHashSet();
        String table = this.getParam("table");
        NTableMetadataManager tblManager = NTableMetadataManager.getInstance((KylinConfig)config, (String)this.getProject());
        InternalTableManager internalTableManager = InternalTableManager.getInstance((KylinConfig)config, (String)this.getProject());
        TableDesc tableDesc = tblManager.getTableDesc(table);
        InternalTableDesc internalTable = internalTableManager.getInternalTableDesc(table);
        ProjectInstance projectInstance = NProjectManager.getInstance((KylinConfig)config).getProject(this.getProject());
        dumpList.add(tableDesc.getResourcePath());
        dumpList.add(internalTable.getResourcePath());
        dumpList.add(projectInstance.getResourcePath());
        dumpList.addAll(this.getLogicalViewMetaDumpList(config));
        return dumpList;
    }

    @Override
    public ExecuteResult doWork(JobContext context) throws ExecuteException {
        ExecuteResult result = super.doWork(context);
        if (!result.succeed()) {
            return result;
        }
        this.checkNeedQuit(true);
        MergerInfo mergerInfo = new MergerInfo(this.project, ExecutableHandler.HandlerType.LOAD_INTERNAL_TABLE);
        mergerInfo.addTaskMergeInfo((AbstractExecutable)this);
        ExecutableHandleUtils.mergeMetadataForTable(this.project, mergerInfo);
        return result;
    }

    public boolean isInternalTableSparkJob() {
        return true;
    }

    @Generated
    public InternalTableLoadingStep() {
    }
}

