/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.utils;

import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.engine.spark.job.InternalTableLoadingJob;
import org.apache.kylin.engine.spark.job.NSparkCubingJob;
import org.apache.kylin.engine.spark.job.NSparkCubingStep;
import org.apache.kylin.engine.spark.job.NSparkIndexPlanOptimizeJob;
import org.apache.kylin.engine.spark.job.NSparkLayoutDataOptimizeJob;
import org.apache.kylin.engine.spark.job.NSparkMergingJob;
import org.apache.kylin.engine.spark.job.NSparkSnapshotJob;
import org.apache.kylin.engine.spark.job.NTableSamplingJob;
import org.apache.kylin.job.execution.AbstractExecutable;

public class SparkJobFactoryUtils {
    private SparkJobFactoryUtils() {
    }

    public static void initJobFactory() {
        new NSparkCubingJob();
        new NSparkMergingJob();
        new NSparkSnapshotJob();
        new NTableSamplingJob();
        new NSparkLayoutDataOptimizeJob();
        new InternalTableLoadingJob();
        new NSparkIndexPlanOptimizeJob();
    }

    public static boolean needBuildSnapshots(AbstractExecutable buildTask) {
        if (buildTask instanceof NSparkCubingStep) {
            String p = buildTask.getParam("needBuildSnapshots");
            return StringUtils.isBlank((CharSequence)p) || Boolean.parseBoolean(p);
        }
        return false;
    }
}

