/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

public class SerializeToByteBuffer {
    public static ByteBuffer retrySerialize(IWriter writer) {
        int bufferSize = 65536;
        while (true) {
            try {
                ByteBuffer byteBuffer = ByteBuffer.allocate(bufferSize);
                writer.write(byteBuffer);
                return byteBuffer;
            }
            catch (BufferOverflowException boe) {
                System.out.println("Buffer size cannot hold the raw scans, resizing to 4 times : " + bufferSize);
                bufferSize *= 4;
                continue;
            }
            break;
        }
    }

    public static interface IWriter {
        public void write(ByteBuffer var1) throws BufferOverflowException;
    }
}

