/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;

public class StringHelper {
    public static final char QUOTE = '\'';
    public static final char DOUBLE_QUOTE = '\"';
    public static final char SLASH = '\\';
    public static final char BACKTICK = '`';

    private StringHelper() {
    }

    public static String join(Iterable<String> parts, String separator) {
        StringBuilder buf = new StringBuilder();
        for (String p : parts) {
            if (buf.length() > 0) {
                buf.append(separator);
            }
            buf.append(p);
        }
        return buf.toString();
    }

    public static void toUpperCaseArray(String[] source, String[] target) {
        if (source != null) {
            for (int i = 0; i < source.length; ++i) {
                if (source[i] == null) continue;
                target[i] = StringUtils.upperCase((String)source[i]);
            }
        }
    }

    public static String dropSuffix(String str, String suffix) {
        if (str.endsWith(suffix)) {
            return str.substring(0, str.length() - suffix.length());
        }
        return str;
    }

    public static String dropFirstSuffix(String str, String suffix) {
        if (str.contains(suffix)) {
            return str.substring(0, str.indexOf(suffix));
        }
        return str;
    }

    public static String min(Collection<String> strs) {
        String min = null;
        for (String s : strs) {
            if (min != null && min.compareTo(s) <= 0) continue;
            min = s;
        }
        return min;
    }

    public static String max(Collection<String> strs) {
        String max = null;
        for (String s : strs) {
            if (max != null && max.compareTo(s) >= 0) continue;
            max = s;
        }
        return max;
    }

    public static String min(String s1, String s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        return s1.compareTo(s2) < 0 ? s1 : s2;
    }

    public static String max(String s1, String s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        return s1.compareTo(s2) > 0 ? s1 : s2;
    }

    public static String[] subArray(String[] array, int start, int endExclusive) {
        if (start < 0 || start > endExclusive || endExclusive > array.length) {
            throw new IllegalArgumentException();
        }
        String[] result = new String[endExclusive - start];
        System.arraycopy(array, start, result, 0, endExclusive - start);
        return result;
    }

    public static String[] splitAndTrim(String str, String splitBy) {
        String[] split = str.split(splitBy);
        ArrayList<String> r = new ArrayList<String>(split.length);
        for (String s : split) {
            if ((s = s.trim()).isEmpty()) continue;
            r.add(s);
        }
        return r.toArray(new String[0]);
    }

    public static boolean equals(String a, String b) {
        return a == null ? b == null : a.equals(b);
    }

    public static boolean validateNumber(String s) {
        return Pattern.compile("^(0|[1-9]\\d*)$").matcher(s).matches();
    }

    public static boolean validateBoolean(String s) {
        return "true".equals(s) || "false".equals(s);
    }

    public static String[] split(String str, String splitBy) {
        return str.split(splitBy);
    }

    public static boolean validateUrl(String s) {
        return Pattern.compile("^(http(s)?://)?[a-zA-Z0-9._-]+(:[0-9]+)?(/[a-zA-Z0-9._-]+)*/?$").matcher(s).matches();
    }

    public static boolean validateHost(String s) {
        return Pattern.compile("^(http(s)?://)?[a-zA-Z0-9._-]+(:[0-9]+)?").matcher(s).matches();
    }

    public static boolean validateDbName(String s) {
        return Pattern.compile("^[0-9a-zA-Z_-]+$").matcher(s).matches();
    }

    public static boolean validateShellArgument(String s) {
        return Pattern.compile("^[a-zA-Z0-9_./-]+$").matcher(s).matches();
    }

    public static String escapeShellArguments(String args) {
        String[] expandArgs = (String[])Arrays.stream(args.split(" ")).filter(arg -> !arg.isEmpty()).toArray(String[]::new);
        return String.join((CharSequence)" ", StringHelper.escapeShellArguments(expandArgs));
    }

    public static String[] escapeShellArguments(String[] args) {
        Pattern keyPattern = Pattern.compile("^[a-zA-Z0-9-]+$");
        Iterator argsIterator = Arrays.stream(args).iterator();
        ArrayList<String> newArgs = new ArrayList<String>();
        while (argsIterator.hasNext()) {
            String value;
            String key;
            String cur = (String)argsIterator.next();
            if (!cur.startsWith("-")) {
                throw new IllegalArgumentException("Unexpected args found: " + Arrays.toString(args));
            }
            boolean useEqual = false;
            if (cur.contains("=")) {
                useEqual = true;
                int index = cur.indexOf(61);
                key = cur.substring(0, index);
                value = cur.substring(index + 1);
            } else {
                key = cur;
                value = (String)argsIterator.next();
            }
            if (!keyPattern.matcher(key).matches()) {
                throw new IllegalArgumentException("Unexpected args found: " + Arrays.toString(args));
            }
            if (value.startsWith("'") && value.endsWith("'") && value.length() >= 2) {
                value = value.substring(1, value.length() - 1);
            }
            String[] splitValues = value.split("'", -1);
            value = Arrays.stream(splitValues).map(v -> v.isEmpty() ? v : "'" + v + "'").collect(Collectors.joining("\\'"));
            if (useEqual) {
                newArgs.add(key + "=" + value);
                continue;
            }
            newArgs.add(key);
            newArgs.add(value);
        }
        return newArgs.toArray(new String[0]);
    }

    public static String backtickToDoubleQuote(String expression) {
        return StringHelper.convert(expression, '`', '\"');
    }

    public static String doubleQuoteToBacktick(String expression) {
        return StringHelper.convert(expression, '\"', '`');
    }

    private static String convert(String expression, char srcDelimiter, char dstDelimiter) {
        char[] chars = expression.toCharArray();
        ArrayList<Integer> quoteIndexes = new ArrayList<Integer>();
        List<Integer> indexList = StringHelper.findDelimiterIndexes(srcDelimiter, expression, quoteIndexes);
        for (Integer integer : indexList) {
            chars[integer.intValue()] = dstDelimiter;
        }
        for (Integer quoteIndex : quoteIndexes) {
            if (dstDelimiter == '\"') {
                chars[quoteIndex.intValue() - 1] = 39;
                continue;
            }
            if (dstDelimiter != '`') continue;
            chars[quoteIndex.intValue() - 1] = 92;
        }
        return new String(chars);
    }

    public static String backtickQuote(String identifier) {
        String str = StringUtils.remove((String)identifier, (char)'`');
        return '`' + str + '`';
    }

    public static String doubleQuote(String identifier) {
        String str = StringUtils.remove((String)identifier, (char)'\"');
        return '\"' + str + '\"';
    }

    public static List<Integer> findDelimiterIndexes(char key, String str, List<Integer> quoteIndexes) {
        Preconditions.checkState((key == '`' || key == '\"' ? 1 : 0) != 0);
        char[] chars = str.toCharArray();
        ArrayList indexList = Lists.newArrayList();
        ArrayList toMatchTokens = Lists.newArrayList();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (toMatchTokens.isEmpty()) {
                if (ch != key && ch != '\'') continue;
                toMatchTokens.add(new Pair<Integer, Character>(i, Character.valueOf(ch)));
                continue;
            }
            Pair exPair = (Pair)toMatchTokens.get(toMatchTokens.size() - 1);
            Character ex = (Character)exPair.getSecond();
            if (ch == ex.charValue() && ch == key) {
                toMatchTokens.add(new Pair<Integer, Character>(i, ex));
                Preconditions.checkState((toMatchTokens.size() == 2 ? 1 : 0) != 0);
                indexList.add(((Pair)toMatchTokens.get(0)).getFirst());
                indexList.add(((Pair)toMatchTokens.get(1)).getFirst());
                toMatchTokens.clear();
                continue;
            }
            if (ch != ex.charValue() || ch != '\'') continue;
            Preconditions.checkState((toMatchTokens.size() == 1 ? 1 : 0) != 0);
            boolean isDelimiter = StringHelper.isQuoteDelimiter(i, chars);
            if (isDelimiter && i + 1 < chars.length && chars[i + 1] == '\'') {
                quoteIndexes.add(++i);
                continue;
            }
            if (isDelimiter) {
                toMatchTokens.clear();
                continue;
            }
            quoteIndexes.add(i);
        }
        Preconditions.checkState((indexList.size() % 2 == 0 ? 1 : 0) != 0);
        return indexList;
    }

    private static boolean isQuoteDelimiter(int i, char[] chars) {
        int num = 0;
        for (int j = i - 1; j > 0 && chars[j] == '\\'; --j) {
            ++num;
        }
        return num % 2 == 0;
    }
}

