/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.core.v1;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.RollingUpdater;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.ReplicationControllerOperationsImpl;

class ReplicationControllerRollingUpdater
extends RollingUpdater<ReplicationController, ReplicationControllerList> {
    ReplicationControllerRollingUpdater(Client client, String namespace, long rollingTimeoutMillis, long loggingIntervalMillis) {
        super(client, namespace, rollingTimeoutMillis, loggingIntervalMillis);
    }

    @Override
    protected ReplicationController createClone(ReplicationController obj, String newName, String newDeploymentHash) {
        return ((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder(obj).editMetadata().withResourceVersion(null)).withName(newName)).endMetadata()).editSpec().withReplicas(Integer.valueOf(0))).addToSelector("deployment", newDeploymentHash)).editTemplate().editMetadata().addToLabels("deployment", newDeploymentHash)).endMetadata()).endTemplate()).endSpec()).build();
    }

    @Override
    protected FilterWatchListDeletable<Pod, PodList, PodResource> selectedPodLister(ReplicationController obj) {
        return (FilterWatchListDeletable)((NonNamespaceOperation)this.pods().inNamespace(this.namespace)).withLabels(obj.getSpec().getSelector());
    }

    @Override
    protected ReplicationController updateDeploymentKey(String name, String hash) {
        ReplicationController old = (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).get();
        ReplicationController updated = ((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicationControllerFluent.SpecNested)new ReplicationControllerBuilder(old).editSpec().addToSelector("deployment", hash)).editTemplate().editMetadata().addToLabels("deployment", hash)).endMetadata()).endTemplate()).endSpec()).build();
        return (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).replace((Object)updated);
    }

    @Override
    protected ReplicationController removeDeploymentKey(String name) {
        ReplicationController old = (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).get();
        ReplicationController updated = ((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicationControllerFluent.SpecNested)new ReplicationControllerBuilder(old).editSpec().removeFromSelector("deployment")).editTemplate().editMetadata().removeFromLabels("deployment")).endMetadata()).endTemplate()).endSpec()).build();
        return (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).replace((Object)updated);
    }

    @Override
    protected int getReplicas(ReplicationController obj) {
        return obj.getSpec().getReplicas();
    }

    @Override
    protected ReplicationController setReplicas(ReplicationController obj, int replicas) {
        return ((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)new ReplicationControllerBuilder(obj).editSpec().withReplicas(Integer.valueOf(replicas))).endSpec()).build();
    }

    @Override
    protected MixedOperation<ReplicationController, ReplicationControllerList, RollableScalableResource<ReplicationController>> resources() {
        return new ReplicationControllerOperationsImpl(this.client);
    }
}

