/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.store;

import java.io.IOException;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.FilterIndexOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.tests.store.MockDirectoryWrapper;
import org.apache.lucene.tests.util.LuceneTestCase;

public class MockIndexOutputWrapper
extends FilterIndexOutput {
    private MockDirectoryWrapper dir;
    private boolean first = true;
    final String name;
    byte[] singleByte = new byte[1];
    private boolean closed;

    public MockIndexOutputWrapper(MockDirectoryWrapper dir, IndexOutput out, String name) {
        super("MockIndexOutputWrapper(" + String.valueOf(out) + ")", out.getName(), out);
        this.dir = dir;
        this.name = name;
    }

    private void checkCrashed() throws IOException {
        if (this.dir.crashed) {
            throw new IOException(((Object)((Object)this.dir)).getClass().getSimpleName() + " has crashed; cannot write to " + this.name);
        }
    }

    private void checkDiskFull(byte[] b, int offset, DataInput in, long len) throws IOException {
        long freeSpace = this.dir.maxSize == 0L ? 0L : this.dir.maxSize - this.dir.sizeInBytes();
        long realUsage = 0L;
        if (this.dir.maxSize != 0L && freeSpace <= len) {
            realUsage = this.dir.sizeInBytes();
            freeSpace = this.dir.maxSize - realUsage;
        }
        if (this.dir.maxSize != 0L && freeSpace <= len) {
            if (freeSpace > 0L) {
                realUsage += freeSpace;
                if (b != null) {
                    this.out.writeBytes(b, offset, (int)freeSpace);
                } else {
                    this.out.copyBytes(in, (long)((int)freeSpace));
                }
            }
            if (realUsage > this.dir.maxUsedSize) {
                this.dir.maxUsedSize = realUsage;
            }
            String message = "fake disk full at " + this.dir.sizeInBytes() + " bytes when writing " + this.name + " (file length=" + this.out.getFilePointer();
            if (freeSpace > 0L) {
                message = message + "; wrote " + freeSpace + " of " + len + " bytes";
            }
            message = message + ")";
            if (LuceneTestCase.VERBOSE) {
                System.out.println(Thread.currentThread().getName() + ": MDW: now throw fake disk full");
                new Throwable().printStackTrace(System.out);
            }
            throw new IOException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.closed) {
            this.out.close();
            return;
        }
        this.closed = true;
        try (IndexOutput out = this.out;){
            assert (out != null);
            this.dir.maybeThrowDeterministicException();
        }
        finally {
            long size;
            this.dir.removeIndexOutput((IndexOutput)this, this.name);
            if (this.dir.trackDiskUsage && (size = this.dir.sizeInBytes()) > this.dir.maxUsedSize) {
                this.dir.maxUsedSize = size;
            }
        }
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new AlreadyClosedException("Already closed: " + String.valueOf((Object)this));
        }
    }

    public void writeByte(byte b) throws IOException {
        this.singleByte[0] = b;
        this.writeBytes(this.singleByte, 0, 1);
    }

    public void writeBytes(byte[] b, int offset, int len) throws IOException {
        this.ensureOpen();
        this.checkCrashed();
        this.checkDiskFull(b, offset, null, len);
        if (this.dir.randomState.nextInt(200) == 0) {
            int half = len / 2;
            this.out.writeBytes(b, offset, half);
            Thread.yield();
            this.out.writeBytes(b, offset + half, len - half);
        } else {
            this.out.writeBytes(b, offset, len);
        }
        this.dir.maybeThrowDeterministicException();
        if (this.first) {
            this.first = false;
            this.dir.maybeThrowIOException(this.name);
        }
    }

    public void writeBytes(byte[] b, int len) throws IOException {
        this.writeBytes(b, 0, len);
    }

    public void copyBytes(DataInput input, long numBytes) throws IOException {
        this.ensureOpen();
        this.checkCrashed();
        this.checkDiskFull(null, 0, input, numBytes);
        this.out.copyBytes(input, numBytes);
        this.dir.maybeThrowDeterministicException();
    }
}

