/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.events;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;

public final class TransferEventSupport {
    private final List listeners = new ArrayList();

    public void addTransferListener(TransferListener listener) {
        this.listeners.add(listener);
    }

    public void removeTransferListener(TransferListener listener) {
        this.listeners.remove(listener);
    }

    public boolean hasTransferListener(TransferListener listener) {
        return this.listeners.contains(listener);
    }

    public void fireTransferStarted(TransferEvent transferEvent) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            TransferListener listener = (TransferListener)iter.next();
            listener.transferStarted(transferEvent);
        }
    }

    public void fireTransferProgress(TransferEvent transferEvent, byte[] buffer, int length) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            TransferListener listener = (TransferListener)iter.next();
            listener.transferProgress(transferEvent, buffer, length);
        }
    }

    public void fireTransferCompleted(TransferEvent transferEvent) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            TransferListener listener = (TransferListener)iter.next();
            listener.transferCompleted(transferEvent);
        }
    }

    public void fireTransferError(TransferEvent transferEvent) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            TransferListener listener = (TransferListener)iter.next();
            listener.transferError(transferEvent);
        }
    }

    public void fireDebug(String message) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            TransferListener listener = (TransferListener)iter.next();
            listener.debug(message);
        }
    }

    public void fireTransferInitiated(TransferEvent transferEvent) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            TransferListener listener = (TransferListener)iter.next();
            listener.transferInitiated(transferEvent);
        }
    }
}

