/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.closeable;

import java.util.Collections;
import java.util.Iterator;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.closeable.SimpleCloseable;

public class SequentialCloseable
extends SimpleCloseable {
    private final Iterable<? extends Closeable> closeables;

    public SequentialCloseable(Object id, Object lock, Iterable<? extends Closeable> closeables) {
        super(id, lock);
        this.closeables = closeables == null ? Collections.emptyList() : closeables;
    }

    @Override
    protected void doClose(final boolean immediately) {
        final Iterator<? extends Closeable> iterator = this.closeables.iterator();
        SshFutureListener<CloseFuture> listener = new SshFutureListener<CloseFuture>(){
            final /* synthetic */ SequentialCloseable this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void operationComplete(CloseFuture previousFuture) {
                boolean traceEnabled = this.this$0.log.isTraceEnabled();
                while (iterator.hasNext()) {
                    Closeable c = (Closeable)iterator.next();
                    if (c == null) continue;
                    if (traceEnabled) {
                        this.this$0.log.trace("doClose({}) closing {} immediately={}", new Object[]{this, c, immediately});
                    }
                    CloseFuture nextFuture = c.close(immediately);
                    nextFuture.addListener(this);
                    return;
                }
                if (!iterator.hasNext()) {
                    if (this.this$0.log.isDebugEnabled()) {
                        this.this$0.log.debug("doClose({}) signal close complete immediately={}", (Object)this, (Object)immediately);
                    }
                    this.this$0.future.setClosed();
                }
            }
        };
        listener.operationComplete(null);
    }
}

