/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.cloud.oracle.adm;

import com.oracle.bmc.adm.model.ApplicationDependencyVulnerabilitySummary;
import com.oracle.bmc.adm.model.VulnerabilityAuditSummary;
import java.util.List;
import java.util.Set;

/**
 * Holder that just glues necessary data together. Contains summary, list of vulnerabilities
 * and an initial mapping to project files. 
 * 
 * @author sdedic
 */
final class VulnerabilityReport {
    public VulnerabilityAuditSummary summary;
    public List<ApplicationDependencyVulnerabilitySummary> items;
    
    /**
     * For some vulnerabilities, the source could not be found, still we want to display them. But
     * vulnerabilities that have been successfully mapped, but THEN 'disappeared' from the dependency
     * report should be either removed or reported as 'info' only: the user may have edited the
     * file, altered the artifact specs, so the report does not apply.
     */
    public Set<String> mappedVulnerabilities;

    public VulnerabilityReport() {
    }

    VulnerabilityReport(VulnerabilityAuditSummary summary, List<ApplicationDependencyVulnerabilitySummary> items) {
        this.summary = summary;
        this.items = items;
        this.mappedVulnerabilities = mappedVulnerabilities;
    }

    public VulnerabilityAuditSummary getSummary() {
        return summary;
    }

    public void setSummary(VulnerabilityAuditSummary summary) {
        this.summary = summary;
    }

    public List<ApplicationDependencyVulnerabilitySummary> getItems() {
        return items;
    }

    public void setItems(List<ApplicationDependencyVulnerabilitySummary> items) {
        this.items = items;
    }

    public Set<String> getMappedVulnerabilities() {
        return mappedVulnerabilities;
    }

    public void setMappedVulnerabilities(Set<String> mappedVulnerabilities) {
        this.mappedVulnerabilities = mappedVulnerabilities;
    }
}
