/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.params;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.ParamProviderResult;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.toolkit.client.ParamContextClient;
import org.apache.nifi.toolkit.client.ParamProviderClient;
import org.apache.nifi.web.api.entity.ParameterContextsEntity;
import org.apache.nifi.web.api.entity.ParameterProviderEntity;

public class GetParamProvider
extends AbstractNiFiCommand<ParamProviderResult> {
    public GetParamProvider() {
        super("get-param-provider", ParamProviderResult.class);
    }

    @Override
    public String getDescription() {
        return "Retrieves a parameter provider by id and lists each configured property and value, as well as any fetched parameter names";
    }

    @Override
    protected void doInitialize(Context provider) {
        this.addOption(CommandOption.PARAM_PROVIDER_ID.createOption());
    }

    @Override
    public ParamProviderResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String paramProviderId = this.getRequiredArg(properties, CommandOption.PARAM_PROVIDER_ID);
        ParamProviderClient paramProviderClient = client.getParamProviderClient();
        ParamContextClient paramContextClient = client.getParamContextClient();
        ParameterContextsEntity paramContextEntity = paramContextClient.getParamContexts();
        ParameterProviderEntity parameterProvider = paramProviderClient.getParamProvider(paramProviderId);
        return new ParamProviderResult(this.getResultType(properties), parameterProvider, paramContextEntity);
    }
}

