/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.crypto.key.pbkdf2;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.nifi.security.crypto.key.DerivedKey;
import org.apache.nifi.security.crypto.key.DerivedKeyProvider;
import org.apache.nifi.security.crypto.key.DerivedKeySpec;
import org.apache.nifi.security.crypto.key.DerivedSecretKey;
import org.apache.nifi.security.crypto.key.pbkdf2.Pbkdf2DerivedKeyParameterSpec;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;

public class Pbkdf2DerivedKeyProvider
implements DerivedKeyProvider<Pbkdf2DerivedKeyParameterSpec> {
    private static final Charset PASSWORD_CHARACTER_SET = StandardCharsets.UTF_8;
    private static final int BITS = 8;
    private static final Base64.Encoder encoder = Base64.getEncoder().withoutPadding();

    @Override
    public DerivedKey getDerivedKey(DerivedKeySpec<Pbkdf2DerivedKeyParameterSpec> derivedKeySpec) {
        byte[] derivedKeyBytes = this.getDerivedKeyBytes(derivedKeySpec);
        String serialized = encoder.encodeToString(derivedKeyBytes);
        return new DerivedSecretKey(derivedKeyBytes, derivedKeySpec.getAlgorithm(), serialized);
    }

    private byte[] getDerivedKeyBytes(DerivedKeySpec<Pbkdf2DerivedKeyParameterSpec> derivedKeySpec) {
        SHA512Digest digest = new SHA512Digest();
        PKCS5S2ParametersGenerator generator = new PKCS5S2ParametersGenerator((Digest)digest);
        byte[] password = new String(derivedKeySpec.getPassword()).getBytes(PASSWORD_CHARACTER_SET);
        Pbkdf2DerivedKeyParameterSpec parameterSpec = derivedKeySpec.getParameterSpec();
        byte[] salt = parameterSpec.getSalt();
        int iterations = parameterSpec.getIterations();
        generator.init(password, salt, iterations);
        int derivedKeyLengthBits = derivedKeySpec.getDerivedKeyLength() * 8;
        CipherParameters cipherParameters = generator.generateDerivedParameters(derivedKeyLengthBits);
        KeyParameter keyParameter = (KeyParameter)cipherParameters;
        return keyParameter.getKey();
    }
}

