/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

final class PathFence {
    private final List<Path> roots;

    static Builder builder() {
        return new Builder();
    }

    private PathFence(Builder builder) {
        this.roots = Arrays.stream(builder.roots).map(Path::toAbsolutePath).collect(Collectors.toList());
    }

    Path apply(String fileName) {
        Path path = Paths.get(fileName, new String[0]);
        if (this.roots.isEmpty()) {
            return path;
        }
        Path pathAbs = path.normalize().toAbsolutePath();
        Optional<Path> first = this.roots.stream().filter(pathAbs::startsWith).findFirst();
        if (first.isPresent()) {
            return path;
        }
        throw new IllegalArgumentException(String.format("[%s] -> [%s] not in the fence %s", fileName, pathAbs, this.roots));
    }

    static final class Builder
    implements Supplier<PathFence> {
        private static final Path[] EMPTY = new Path[0];
        private Path[] roots = EMPTY;

        Builder() {
        }

        @Override
        public PathFence get() {
            return new PathFence(this);
        }

        Builder setRoots(Path ... paths) {
            this.roots = paths != null ? (Path[])paths.clone() : EMPTY;
            return this;
        }
    }
}

