/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.cert.builder;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.apache.nifi.security.cert.builder.CertificateBuilder;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class StandardCertificateBuilder
implements CertificateBuilder {
    private static final String SIGNING_ALGORITHM = "SHA256withRSA";
    private static final String LOCALHOST = "localhost";
    private static final boolean CRITICAL = true;
    private static final boolean NOT_CRITICAL = false;
    private static final int STANDARD_KEY_USAGE = 248;
    private static final int AUTHORITY_KEY_USAGE = 254;
    private final BigInteger serialNumber = BigInteger.valueOf(System.nanoTime());
    private final KeyPair issuerKeyPair;
    private final X500Principal issuer;
    private final Duration validityPeriod;
    private PublicKey subjectPublicKey;
    private X500Principal subject;
    private Set<String> dnsSubjectAlternativeNames = Collections.emptySet();

    public StandardCertificateBuilder(KeyPair issuerKeyPair, X500Principal issuer, Duration validityPeriod) {
        this.issuerKeyPair = Objects.requireNonNull(issuerKeyPair, "Issuer Key Pair required");
        this.issuer = Objects.requireNonNull(issuer, "Issuer required");
        this.validityPeriod = Objects.requireNonNull(validityPeriod, "Validity Period required");
        this.subject = issuer;
        this.subjectPublicKey = issuerKeyPair.getPublic();
    }

    @Override
    public X509Certificate build() {
        X509CertificateHolder certificateHolder = this.getCertificateHolder();
        JcaX509CertificateConverter certificateConverter = new JcaX509CertificateConverter();
        try {
            return certificateConverter.getCertificate(certificateHolder);
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException("X.509 Certificate conversion failed", e);
        }
    }

    public StandardCertificateBuilder setSubject(X500Principal subject) {
        this.subject = Objects.requireNonNull(subject, "Subject required");
        return this;
    }

    public StandardCertificateBuilder setSubjectPublicKey(PublicKey subjectPublicKey) {
        this.subjectPublicKey = Objects.requireNonNull(subjectPublicKey, "Subject Public Key required");
        return this;
    }

    public StandardCertificateBuilder setDnsSubjectAlternativeNames(Collection<String> dnsSubjectAlternativeNames) {
        this.dnsSubjectAlternativeNames = new LinkedHashSet<String>(Objects.requireNonNull(dnsSubjectAlternativeNames, "DNS Names required"));
        return this;
    }

    private void setExtensions(X509v3CertificateBuilder certificateBuilder) {
        JcaX509ExtensionUtils extensionUtils = this.getExtensionUtils();
        try {
            BasicConstraints basicConstraints = this.getBasicConstraints();
            certificateBuilder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)basicConstraints);
            KeyUsage keyUsage = this.getKeyUsage(basicConstraints.isCA());
            certificateBuilder.addExtension(Extension.keyUsage, true, (ASN1Encodable)keyUsage);
            certificateBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extensionUtils.createSubjectKeyIdentifier(this.subjectPublicKey));
            PublicKey issuerPublicKey = this.issuerKeyPair.getPublic();
            certificateBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)extensionUtils.createAuthorityKeyIdentifier(issuerPublicKey));
            KeyPurposeId[] keyPurposes = new KeyPurposeId[]{KeyPurposeId.id_kp_clientAuth, KeyPurposeId.id_kp_serverAuth};
            ExtendedKeyUsage extendedKeyUsage = new ExtendedKeyUsage(keyPurposes);
            certificateBuilder.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)extendedKeyUsage);
            GeneralNames subjectAlternativeNames = this.getSubjectAlternativeNames();
            certificateBuilder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAlternativeNames);
        }
        catch (CertIOException e) {
            throw new IllegalArgumentException("Certificate Extension addition failed", e);
        }
    }

    private BasicConstraints getBasicConstraints() {
        PublicKey issuerPublicKey = this.issuerKeyPair.getPublic();
        boolean certificateAuthority = this.subjectPublicKey.equals(issuerPublicKey);
        return new BasicConstraints(certificateAuthority);
    }

    private KeyUsage getKeyUsage(boolean certificateAuthority) {
        int keyUsage = certificateAuthority ? 254 : 248;
        return new KeyUsage(keyUsage);
    }

    private GeneralNames getSubjectAlternativeNames() {
        LinkedHashSet<GeneralName> generalNames = new LinkedHashSet<GeneralName>();
        String subjectCommonName = this.getSubjectCommonName();
        GeneralName subjectGeneralName = new GeneralName(2, subjectCommonName);
        generalNames.add(subjectGeneralName);
        for (String dnsSubjectAlternativeName : this.dnsSubjectAlternativeNames) {
            GeneralName generalName = new GeneralName(2, dnsSubjectAlternativeName);
            generalNames.add(generalName);
        }
        return new GeneralNames(generalNames.toArray(new GeneralName[0]));
    }

    private String getSubjectCommonName() {
        String subjectCommonName;
        X500Name subjectName = this.getName(this.subject);
        RDN[] commonNames = subjectName.getRDNs(BCStyle.CN);
        if (commonNames.length == 0) {
            subjectCommonName = LOCALHOST;
        } else {
            RDN commonName = commonNames[0];
            ASN1Encodable commonNameEncoded = commonName.getFirst().getValue();
            subjectCommonName = IETFUtils.valueToString((ASN1Encodable)commonNameEncoded);
        }
        return subjectCommonName;
    }

    private X509CertificateHolder getCertificateHolder() {
        X509v3CertificateBuilder certificateBuilder = this.getCertificateBuilder();
        this.setExtensions(certificateBuilder);
        ContentSigner contentSigner = this.getContentSigner();
        return certificateBuilder.build(contentSigner);
    }

    private X509v3CertificateBuilder getCertificateBuilder() {
        X500Name issuerName = this.getName(this.issuer);
        Date notBefore = new Date();
        Date notAfter = Date.from(notBefore.toInstant().plus(this.validityPeriod));
        X500Name subjectName = this.getName(this.subject);
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)this.subjectPublicKey.getEncoded());
        return new X509v3CertificateBuilder(issuerName, this.serialNumber, notBefore, notAfter, subjectName, subjectPublicKeyInfo);
    }

    private ContentSigner getContentSigner() {
        JcaContentSignerBuilder contentSignerBuilder = new JcaContentSignerBuilder(SIGNING_ALGORITHM);
        PrivateKey issuerPrivateKey = this.issuerKeyPair.getPrivate();
        try {
            return contentSignerBuilder.build(issuerPrivateKey);
        }
        catch (OperatorCreationException e) {
            throw new IllegalArgumentException("Certificate Signer creation failed", e);
        }
    }

    private JcaX509ExtensionUtils getExtensionUtils() {
        try {
            return new JcaX509ExtensionUtils();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Certificate Extension Utilities creation failed", e);
        }
    }

    private X500Name getName(X500Principal principal) {
        return new X500Name(RFC4519Style.INSTANCE, principal.getName());
    }
}

