/****************************************************************************
 * arch/risc-v/src/rp23xx-rv/hardware/rp23xx_rp_ap.h
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_RISC_V_SRC_RP23XX_HARDWARE_RP23XX_RP_AP_H
#define __ARCH_RISC_V_SRC_RP23XX_HARDWARE_RP23XX_RP_AP_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include "hardware/rp23xx_memorymap.h"

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

#define RP23XX_RP_AP_CTRL_OFFSET 0x00000000
#define RP23XX_RP_AP_CTRL_BITS   0xc000007f
#define RP23XX_RP_AP_CTRL_RESET  0x00000000

#define RP23XX_RP_AP_CTRL_RESCUE_RESTART_RESET  0x0
#define RP23XX_RP_AP_CTRL_RESCUE_RESTART_BITS   0x80000000
#define RP23XX_RP_AP_CTRL_RESCUE_RESTART_MSB    31
#define RP23XX_RP_AP_CTRL_RESCUE_RESTART_LSB    31
#define RP23XX_RP_AP_CTRL_RESCUE_RESTART_ACCESS "RW"

#define RP23XX_RP_AP_CTRL_SPARE_RESET  0x0
#define RP23XX_RP_AP_CTRL_SPARE_BITS   0x40000000
#define RP23XX_RP_AP_CTRL_SPARE_MSB    30
#define RP23XX_RP_AP_CTRL_SPARE_LSB    30
#define RP23XX_RP_AP_CTRL_SPARE_ACCESS "RW"

#define RP23XX_RP_AP_CTRL_DBG_FRCE_GPIO_LPCK_RESET  0x0
#define RP23XX_RP_AP_CTRL_DBG_FRCE_GPIO_LPCK_BITS   0x00000040
#define RP23XX_RP_AP_CTRL_DBG_FRCE_GPIO_LPCK_MSB    6
#define RP23XX_RP_AP_CTRL_DBG_FRCE_GPIO_LPCK_LSB    6
#define RP23XX_RP_AP_CTRL_DBG_FRCE_GPIO_LPCK_ACCESS "RW"

#define RP23XX_RP_AP_CTRL_LPOSC_STABLE_FRCE_RESET  0x0
#define RP23XX_RP_AP_CTRL_LPOSC_STABLE_FRCE_BITS   0x00000020
#define RP23XX_RP_AP_CTRL_LPOSC_STABLE_FRCE_MSB    5
#define RP23XX_RP_AP_CTRL_LPOSC_STABLE_FRCE_LSB    5
#define RP23XX_RP_AP_CTRL_LPOSC_STABLE_FRCE_ACCESS "RW"

#define RP23XX_RP_AP_CTRL_POWMAN_DFT_ISO_OFF_RESET  0x0
#define RP23XX_RP_AP_CTRL_POWMAN_DFT_ISO_OFF_BITS   0x00000010
#define RP23XX_RP_AP_CTRL_POWMAN_DFT_ISO_OFF_MSB    4
#define RP23XX_RP_AP_CTRL_POWMAN_DFT_ISO_OFF_LSB    4
#define RP23XX_RP_AP_CTRL_POWMAN_DFT_ISO_OFF_ACCESS "RW"

#define RP23XX_RP_AP_CTRL_POWMAN_DFT_PWRON_RESET  0x0
#define RP23XX_RP_AP_CTRL_POWMAN_DFT_PWRON_BITS   0x00000008
#define RP23XX_RP_AP_CTRL_POWMAN_DFT_PWRON_MSB    3
#define RP23XX_RP_AP_CTRL_POWMAN_DFT_PWRON_LSB    3
#define RP23XX_RP_AP_CTRL_POWMAN_DFT_PWRON_ACCESS "RW"

#define RP23XX_RP_AP_CTRL_POWMAN_DBGMODE_RESET  0x0
#define RP23XX_RP_AP_CTRL_POWMAN_DBGMODE_BITS   0x00000004
#define RP23XX_RP_AP_CTRL_POWMAN_DBGMODE_MSB    2
#define RP23XX_RP_AP_CTRL_POWMAN_DBGMODE_LSB    2
#define RP23XX_RP_AP_CTRL_POWMAN_DBGMODE_ACCESS "RW"

#define RP23XX_RP_AP_CTRL_JTAG_FUNCSEL_RESET  0x0
#define RP23XX_RP_AP_CTRL_JTAG_FUNCSEL_BITS   0x00000002
#define RP23XX_RP_AP_CTRL_JTAG_FUNCSEL_MSB    1
#define RP23XX_RP_AP_CTRL_JTAG_FUNCSEL_LSB    1
#define RP23XX_RP_AP_CTRL_JTAG_FUNCSEL_ACCESS "RW"

#define RP23XX_RP_AP_CTRL_JTAG_TRSTN_RESET  0x0
#define RP23XX_RP_AP_CTRL_JTAG_TRSTN_BITS   0x00000001
#define RP23XX_RP_AP_CTRL_JTAG_TRSTN_MSB    0
#define RP23XX_RP_AP_CTRL_JTAG_TRSTN_LSB    0
#define RP23XX_RP_AP_CTRL_JTAG_TRSTN_ACCESS "RW"

#define RP23XX_RP_AP_DBGKEY_OFFSET 0x00000004
#define RP23XX_RP_AP_DBGKEY_BITS   0x00000007
#define RP23XX_RP_AP_DBGKEY_RESET  0x00000000

#define RP23XX_RP_AP_DBGKEY_RESET_RESET  0x0
#define RP23XX_RP_AP_DBGKEY_RESET_BITS   0x00000004
#define RP23XX_RP_AP_DBGKEY_RESET_MSB    2
#define RP23XX_RP_AP_DBGKEY_RESET_LSB    2
#define RP23XX_RP_AP_DBGKEY_RESET_ACCESS "RW"

#define RP23XX_RP_AP_DBGKEY_PUSH_RESET  0x0
#define RP23XX_RP_AP_DBGKEY_PUSH_BITS   0x00000002
#define RP23XX_RP_AP_DBGKEY_PUSH_MSB    1
#define RP23XX_RP_AP_DBGKEY_PUSH_LSB    1
#define RP23XX_RP_AP_DBGKEY_PUSH_ACCESS "RW"

#define RP23XX_RP_AP_DBGKEY_DATA_RESET  0x0
#define RP23XX_RP_AP_DBGKEY_DATA_BITS   0x00000001
#define RP23XX_RP_AP_DBGKEY_DATA_MSB    0
#define RP23XX_RP_AP_DBGKEY_DATA_LSB    0
#define RP23XX_RP_AP_DBGKEY_DATA_ACCESS "RW"

#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_OFFSET 0x00000008
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_BITS   0x00000fff
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_RESET  0x00000000

#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_USING_FAST_POWCK_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_USING_FAST_POWCK_BITS   0x00000800
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_USING_FAST_POWCK_MSB    11
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_USING_FAST_POWCK_LSB    11
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_USING_FAST_POWCK_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_WAITING_POWCK_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_WAITING_POWCK_BITS   0x00000400
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_WAITING_POWCK_MSB    10
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_WAITING_POWCK_LSB    10
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_WAITING_POWCK_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_WAITING_TIMCK_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_WAITING_TIMCK_BITS   0x00000200
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_WAITING_TIMCK_MSB    9
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_WAITING_TIMCK_LSB    9
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_WAITING_TIMCK_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_IS_PU_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_IS_PU_BITS   0x00000100
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_IS_PU_MSB    8
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_IS_PU_LSB    8
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_IS_PU_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_RESET_FROM_SEQ_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_RESET_FROM_SEQ_BITS   0x00000080
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_RESET_FROM_SEQ_MSB    7
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_RESET_FROM_SEQ_LSB    7
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_RESET_FROM_SEQ_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_ENAB_ACK_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_ENAB_ACK_BITS   0x00000040
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_ENAB_ACK_MSB    6
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_ENAB_ACK_LSB    6
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_ENAB_ACK_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_ISOLATE_FROM_SEQ_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_ISOLATE_FROM_SEQ_BITS   0x00000020
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_ISOLATE_FROM_SEQ_MSB    5
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_ISOLATE_FROM_SEQ_LSB    5
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_ISOLATE_FROM_SEQ_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_LARGE_ACK_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_LARGE_ACK_BITS   0x00000010
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_LARGE_ACK_MSB    4
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_LARGE_ACK_LSB    4
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_LARGE_ACK_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_SMALL_ACK2_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_SMALL_ACK2_BITS   0x00000008
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_SMALL_ACK2_MSB    3
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_SMALL_ACK2_LSB    3
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_SMALL_ACK2_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_SMALL_ACK1_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_SMALL_ACK1_BITS   0x00000004
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_SMALL_ACK1_MSB    2
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_SMALL_ACK1_LSB    2
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_SMALL_ACK1_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_SMALL_ACK0_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_SMALL_ACK0_BITS   0x00000002
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_SMALL_ACK0_MSB    1
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_SMALL_ACK0_LSB    1
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_SMALL_ACK0_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_IS_PD_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_IS_PD_BITS   0x00000001
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_IS_PD_MSB    0
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_IS_PD_LSB    0
#define RP23XX_RP_AP_DBG_POW_STATE_SWCORE_IS_PD_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_XIP_OFFSET 0x0000000c
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_BITS   0x000001ff
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_RESET  0x00000000

#define RP23XX_RP_AP_DBG_POW_STATE_XIP_IS_PU_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_IS_PU_BITS   0x00000100
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_IS_PU_MSB    8
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_IS_PU_LSB    8
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_IS_PU_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_XIP_RESET_FROM_SEQ_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_RESET_FROM_SEQ_BITS   0x00000080
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_RESET_FROM_SEQ_MSB    7
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_RESET_FROM_SEQ_LSB    7
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_RESET_FROM_SEQ_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_XIP_ENAB_ACK_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_ENAB_ACK_BITS   0x00000040
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_ENAB_ACK_MSB    6
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_ENAB_ACK_LSB    6
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_ENAB_ACK_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_XIP_ISOLATE_FROM_SEQ_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_ISOLATE_FROM_SEQ_BITS   0x00000020
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_ISOLATE_FROM_SEQ_MSB    5
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_ISOLATE_FROM_SEQ_LSB    5
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_ISOLATE_FROM_SEQ_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_XIP_LARGE_ACK_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_LARGE_ACK_BITS   0x00000010
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_LARGE_ACK_MSB    4
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_LARGE_ACK_LSB    4
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_LARGE_ACK_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_XIP_SMALL_ACK2_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_SMALL_ACK2_BITS   0x00000008
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_SMALL_ACK2_MSB    3
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_SMALL_ACK2_LSB    3
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_SMALL_ACK2_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_XIP_SMALL_ACK1_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_SMALL_ACK1_BITS   0x00000004
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_SMALL_ACK1_MSB    2
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_SMALL_ACK1_LSB    2
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_SMALL_ACK1_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_XIP_SMALL_ACK0_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_SMALL_ACK0_BITS   0x00000002
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_SMALL_ACK0_MSB    1
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_SMALL_ACK0_LSB    1
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_SMALL_ACK0_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_XIP_IS_PD_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_IS_PD_BITS   0x00000001
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_IS_PD_MSB    0
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_IS_PD_LSB    0
#define RP23XX_RP_AP_DBG_POW_STATE_XIP_IS_PD_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_OFFSET 0x00000010
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_BITS   0x000001ff
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_RESET  0x00000000

#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_IS_PU_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_IS_PU_BITS   0x00000100
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_IS_PU_MSB    8
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_IS_PU_LSB    8
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_IS_PU_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_RESET_FROM_SEQ_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_RESET_FROM_SEQ_BITS   0x00000080
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_RESET_FROM_SEQ_MSB    7
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_RESET_FROM_SEQ_LSB    7
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_RESET_FROM_SEQ_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_ENAB_ACK_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_ENAB_ACK_BITS   0x00000040
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_ENAB_ACK_MSB    6
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_ENAB_ACK_LSB    6
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_ENAB_ACK_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_ISOLATE_FROM_SEQ_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_ISOLATE_FROM_SEQ_BITS   0x00000020
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_ISOLATE_FROM_SEQ_MSB    5
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_ISOLATE_FROM_SEQ_LSB    5
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_ISOLATE_FROM_SEQ_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_LARGE_ACK_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_LARGE_ACK_BITS   0x00000010
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_LARGE_ACK_MSB    4
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_LARGE_ACK_LSB    4
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_LARGE_ACK_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_SMALL_ACK2_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_SMALL_ACK2_BITS   0x00000008
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_SMALL_ACK2_MSB    3
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_SMALL_ACK2_LSB    3
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_SMALL_ACK2_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_SMALL_ACK1_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_SMALL_ACK1_BITS   0x00000004
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_SMALL_ACK1_MSB    2
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_SMALL_ACK1_LSB    2
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_SMALL_ACK1_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_SMALL_ACK0_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_SMALL_ACK0_BITS   0x00000002
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_SMALL_ACK0_MSB    1
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_SMALL_ACK0_LSB    1
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_SMALL_ACK0_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_IS_PD_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_IS_PD_BITS   0x00000001
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_IS_PD_MSB    0
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_IS_PD_LSB    0
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM0_IS_PD_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_OFFSET 0x00000014
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_BITS   0x000001ff
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_RESET  0x00000000

#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_IS_PU_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_IS_PU_BITS   0x00000100
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_IS_PU_MSB    8
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_IS_PU_LSB    8
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_IS_PU_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_RESET_FROM_SEQ_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_RESET_FROM_SEQ_BITS   0x00000080
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_RESET_FROM_SEQ_MSB    7
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_RESET_FROM_SEQ_LSB    7
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_RESET_FROM_SEQ_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_ENAB_ACK_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_ENAB_ACK_BITS   0x00000040
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_ENAB_ACK_MSB    6
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_ENAB_ACK_LSB    6
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_ENAB_ACK_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_ISOLATE_FROM_SEQ_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_ISOLATE_FROM_SEQ_BITS   0x00000020
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_ISOLATE_FROM_SEQ_MSB    5
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_ISOLATE_FROM_SEQ_LSB    5
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_ISOLATE_FROM_SEQ_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_LARGE_ACK_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_LARGE_ACK_BITS   0x00000010
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_LARGE_ACK_MSB    4
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_LARGE_ACK_LSB    4
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_LARGE_ACK_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_SMALL_ACK2_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_SMALL_ACK2_BITS   0x00000008
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_SMALL_ACK2_MSB    3
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_SMALL_ACK2_LSB    3
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_SMALL_ACK2_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_SMALL_ACK1_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_SMALL_ACK1_BITS   0x00000004
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_SMALL_ACK1_MSB    2
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_SMALL_ACK1_LSB    2
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_SMALL_ACK1_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_SMALL_ACK0_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_SMALL_ACK0_BITS   0x00000002
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_SMALL_ACK0_MSB    1
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_SMALL_ACK0_LSB    1
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_SMALL_ACK0_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_IS_PD_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_IS_PD_BITS   0x00000001
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_IS_PD_MSB    0
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_IS_PD_LSB    0
#define RP23XX_RP_AP_DBG_POW_STATE_SRAM1_IS_PD_ACCESS "RO"

#define RP23XX_RP_AP_DBG_POW_OVRD_OFFSET 0x00000018
#define RP23XX_RP_AP_DBG_POW_OVRD_BITS   0x0000007f
#define RP23XX_RP_AP_DBG_POW_OVRD_RESET  0x00000000

#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_RESTART_FROM_XOSC_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_RESTART_FROM_XOSC_BITS   0x00000040
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_RESTART_FROM_XOSC_MSB    6
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_RESTART_FROM_XOSC_LSB    6
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_RESTART_FROM_XOSC_ACCESS "RW"

#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_RESET_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_RESET_BITS   0x00000020
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_RESET_MSB    5
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_RESET_LSB    5
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_RESET_ACCESS "RW"

#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_OVRD_RESET_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_OVRD_RESET_BITS   0x00000010
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_OVRD_RESET_MSB    4
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_OVRD_RESET_LSB    4
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_OVRD_RESET_ACCESS "RW"

#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_ISO_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_ISO_BITS   0x00000008
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_ISO_MSB    3
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_ISO_LSB    3
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_ISO_ACCESS "RW"

#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_OVRD_ISO_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_OVRD_ISO_BITS   0x00000004
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_OVRD_ISO_MSB    2
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_OVRD_ISO_LSB    2
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_OVRD_ISO_ACCESS "RW"

#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_OVRD_LARGE_REQ_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_OVRD_LARGE_REQ_BITS   0x00000002
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_OVRD_LARGE_REQ_MSB    1
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_OVRD_LARGE_REQ_LSB    1
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_OVRD_LARGE_REQ_ACCESS "RW"

#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_OVRD_SMALL_REQ_RESET  0x0
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_OVRD_SMALL_REQ_BITS   0x00000001
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_OVRD_SMALL_REQ_MSB    0
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_OVRD_SMALL_REQ_LSB    0
#define RP23XX_RP_AP_DBG_POW_OVRD_DBG_POW_OVRD_SMALL_REQ_ACCESS "RW"

#define RP23XX_RP_AP_DBG_POW_OUTPUT_TO_GPIO_OFFSET 0x0000001c
#define RP23XX_RP_AP_DBG_POW_OUTPUT_TO_GPIO_BITS   0x00000fff
#define RP23XX_RP_AP_DBG_POW_OUTPUT_TO_GPIO_RESET  0x00000000

#define RP23XX_RP_AP_DBG_POW_OUTPUT_TO_GPIO_ENABLE_RESET  0x000
#define RP23XX_RP_AP_DBG_POW_OUTPUT_TO_GPIO_ENABLE_BITS   0x00000fff
#define RP23XX_RP_AP_DBG_POW_OUTPUT_TO_GPIO_ENABLE_MSB    11
#define RP23XX_RP_AP_DBG_POW_OUTPUT_TO_GPIO_ENABLE_LSB    0
#define RP23XX_RP_AP_DBG_POW_OUTPUT_TO_GPIO_ENABLE_ACCESS "RW"

#define RP23XX_RP_AP_IDR_OFFSET 0x00000dfc
#define RP23XX_RP_AP_IDR_BITS   0xffffffff
#define RP23XX_RP_AP_IDR_RESET  "-"
#define RP23XX_RP_AP_IDR_MSB    31
#define RP23XX_RP_AP_IDR_LSB    0
#define RP23XX_RP_AP_IDR_ACCESS "RO"

#endif /* __ARCH_RISC_V_SRC_RP23XX_HARDWARE_RP23XX_RP_AP_H */
