/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.core.sip;

import gov.nist.javax.sip.DialogTimeoutEvent;
import gov.nist.javax.sip.SipListenerExt;
import gov.nist.javax.sip.SipStackExt;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.clientauthutils.AuthenticationHelper;
import gov.nist.javax.sip.clientauthutils.UserCredentials;
import gov.nist.javax.sip.stack.NioMessageProcessorFactory;
import java.text.ParseException;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.ListeningPoint;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.openmeetings.core.sip.ISipCallbacks;
import org.apache.openmeetings.core.sip.SipManager;
import org.apache.openmeetings.db.entity.room.Room;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SipStackProcessor
implements SipListenerExt {
    private static final Logger log = LoggerFactory.getLogger(SipStackProcessor.class);
    private static final String SIP_TRANSPORT = "ws";
    private final SipManager manager;
    private final ISipCallbacks callbacks;
    private final String sipHost;
    private final int wsPort;
    private final String omSipUser;
    private final String omSipPasswd;
    private final String localWsHost;
    private final int localWsPort;
    private final String tag;
    private final SipProvider sipProvider;
    private final SipStackExt sipStack;
    private final MessageFactory messageFactory;
    private final HeaderFactory headerFactory;
    private final AddressFactory addressFactory;
    private final ContactHeader contactHeader;
    private final AtomicLong cseq = new AtomicLong();
    private final Random rnd = new Random();
    private Dialog dialog;

    private static final <T> Consumer<T> noop() {
        return t -> {};
    }

    SipStackProcessor(SipManager manager, String name, int localWsPort, ISipCallbacks callbacks) throws Exception {
        this.manager = manager;
        this.callbacks = callbacks;
        this.sipHost = manager.getSipHostname();
        this.wsPort = manager.getWsPort();
        this.omSipUser = manager.getOmSipUser();
        this.omSipPasswd = manager.getOmSipPasswd();
        this.localWsHost = manager.getLocalWsHost();
        this.localWsPort = localWsPort;
        SipFactory sipFactory = SipFactory.getInstance();
        Properties properties = new Properties();
        properties.setProperty("javax.sip.STACK_NAME", name);
        if (log.isTraceEnabled()) {
            properties.setProperty("gov.nist.javax.sip.TRACE_LEVEL", "32");
        }
        properties.setProperty("gov.nist.javax.sip.LOG_MESSAGE_CONTENT", "true");
        properties.setProperty("gov.nist.javax.sip.MESSAGE_PROCESSOR_FACTORY", NioMessageProcessorFactory.class.getName());
        this.sipStack = new SipStackImpl(properties);
        this.tag = this.getRnd(10);
        this.messageFactory = sipFactory.createMessageFactory();
        this.headerFactory = sipFactory.createHeaderFactory();
        this.addressFactory = sipFactory.createAddressFactory();
        ListeningPoint listeningPoint = this.sipStack.createListeningPoint(this.localWsHost, localWsPort, SIP_TRANSPORT);
        this.sipProvider = this.sipStack.createSipProvider(listeningPoint);
        this.sipProvider.addSipListener((SipListener)this);
        Address contact = this.createAddr(this.omSipUser, this.localWsHost, uri -> {
            try {
                uri.setPort(localWsPort);
                uri.setTransportParam(SIP_TRANSPORT);
            }
            catch (ParseException e) {
                log.error("fail to create contact address", (Throwable)e);
            }
        });
        this.contactHeader = this.headerFactory.createContactHeader(contact);
    }

    public void processDialogTerminated(DialogTerminatedEvent evt) {
        log.error("processDialogTerminated: \n{}", (Object)evt);
    }

    public void processIOException(IOExceptionEvent evt) {
        log.error("processIOException: \n{}", (Object)evt);
    }

    public void processTimeout(TimeoutEvent evt) {
        log.error("processTimeout: \n{}", (Object)evt);
    }

    public void processTransactionTerminated(TransactionTerminatedEvent evt) {
        log.error("processTransactionTerminated: \n{}", (Object)evt);
    }

    public void processDialogTimeout(DialogTimeoutEvent timeoutEvent) {
        log.error("processDialogTimeout: \n{}", (Object)timeoutEvent);
    }

    public void processRequest(RequestEvent evt) {
        log.debug("processRequest: \n\n{}", (Object)evt.getRequest());
        Request rq = evt.getRequest();
        String method = rq.getMethod();
        try {
            if ("OPTIONS".equals(method) || "BYE".equals(method)) {
                ServerTransaction transaction = evt.getServerTransaction();
                if (transaction == null) {
                    transaction = this.sipProvider.getNewServerTransaction(rq);
                }
                Response resp = this.messageFactory.createResponse(200, rq);
                resp.addHeader((Header)this.contactHeader);
                transaction.sendResponse(resp);
            }
        }
        catch (Exception e) {
            log.error("processRequest", (Throwable)e);
        }
    }

    public void processResponse(ResponseEvent evt) {
        Response resp = evt.getResponse();
        ClientTransaction curTrans = evt.getClientTransaction();
        Request prevReq = curTrans.getRequest();
        log.warn("Response code: {} on {}", (Object)resp.getStatusCode(), (Object)prevReq.getMethod());
        switch (resp.getStatusCode()) {
            case 401: {
                this.processUnauth(evt);
                break;
            }
            case 200: {
                if ("REGISTER".equals(prevReq.getMethod())) {
                    this.callbacks.onRegisterOk();
                    break;
                }
                if ("INVITE".equals(prevReq.getMethod())) {
                    this.dialog = evt.getDialog();
                    this.callbacks.onInviteOk(new String((byte[])resp.getContent()), answer -> this.ack(evt, (String)answer));
                    break;
                }
                if (!"BYE".equals(prevReq.getMethod())) break;
                this.doDestroy();
                break;
            }
            case 100: 
            case 180: {
                break;
            }
            default: {
                log.debug("No handler for response: \n\n{}", (Object)resp);
            }
        }
    }

    private void ack(ResponseEvent evt, String answer) {
        try {
            Response resp = evt.getResponse();
            Dialog dlg = evt.getDialog();
            CSeqHeader cseqHead = (CSeqHeader)resp.getHeader("CSeq");
            Request ack = dlg.createAck(cseqHead.getSeqNumber());
            this.addSdp(ack, answer);
            dlg.sendAck(ack);
        }
        catch (Exception e) {
            log.error("ack {}", (Object)evt, (Object)e);
        }
    }

    private void sayBye() {
        try {
            Request req = this.dialog.createRequest("BYE");
            ClientTransaction ct = this.sipProvider.getNewClientTransaction(req);
            this.dialog.sendRequest(ct);
        }
        catch (SipException e) {
            log.error("bye ", (Throwable)e);
        }
    }

    private String getRnd(int count) {
        return this.rnd.ints(48, 123).filter(ch -> ch >= 48 && ch <= 57 || ch >= 97 && ch <= 122).limit(count).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    private Address createAddr(String user) {
        return this.createAddr(user, this.sipHost, SipStackProcessor.noop());
    }

    private Address createAddr(String user, String host, Consumer<SipUri> cons) {
        try {
            SipUri uri = new SipUri();
            uri.setHost(host);
            uri.setUser(user);
            cons.accept(uri);
            return this.addressFactory.createAddress(user, (URI)uri);
        }
        catch (ParseException e) {
            log.error("fail to create address", (Throwable)e);
            return null;
        }
    }

    private void sendRequest(String method, String to, Consumer<SipUri> uriCons, Consumer<Request> reqCons) {
        try {
            SipUri uri = new SipUri();
            uri.setHost(this.sipHost);
            uri.setPort(this.wsPort);
            uri.setTransportParam(SIP_TRANSPORT);
            uri.setMethodParam("GET");
            uri.setHeader("Host", this.sipHost);
            uri.setHeader("Location", "/ws");
            uriCons.accept(uri);
            Request request = this.messageFactory.createRequest((URI)uri, method, this.sipProvider.getNewCallId(), this.headerFactory.createCSeqHeader(this.cseq.incrementAndGet(), method), this.headerFactory.createFromHeader(this.createAddr(this.omSipUser), this.tag), this.headerFactory.createToHeader(this.createAddr(to), null), List.of(this.headerFactory.createViaHeader(this.localWsHost, this.localWsPort, SIP_TRANSPORT, null)), this.headerFactory.createMaxForwardsHeader(70));
            request.addHeader((Header)this.contactHeader);
            request.addHeader((Header)this.headerFactory.createExpiresHeader(600));
            reqCons.accept(request);
            ClientTransaction trans = this.sipProvider.getNewClientTransaction(request);
            trans.sendRequest();
        }
        catch (Exception e) {
            log.error("Error while sending request", (Throwable)e);
        }
    }

    private void processUnauth(ResponseEvent evt) {
        Response resp = evt.getResponse();
        ClientTransaction curTrans = evt.getClientTransaction();
        AuthenticationHelper helper = this.sipStack.getAuthenticationHelper((trans, s) -> new UserCredentials(){

            public String getUserName() {
                return SipStackProcessor.this.omSipUser;
            }

            public String getPassword() {
                return SipStackProcessor.this.omSipPasswd;
            }

            public String getSipDomain() {
                return "asterisk";
            }
        }, this.headerFactory);
        try {
            ClientTransaction trans2 = helper.handleChallenge(resp, curTrans, this.sipProvider, 5);
            trans2.sendRequest();
        }
        catch (SipException e) {
            log.error("Error while sending AUTH", (Throwable)e);
        }
    }

    private void addAllow(Request req) throws ParseException {
        req.addHeader((Header)this.headerFactory.createAllowHeader("ACK,CANCEL,INVITE,MESSAGE,BYE,OPTIONS,INFO,NOTIFY,REFER"));
    }

    public void register() {
        this.sendRequest("REGISTER", this.omSipUser, SipStackProcessor.noop(), req -> {
            try {
                this.addAllow((Request)req);
            }
            catch (ParseException e) {
                log.error("fail to create allow header", (Throwable)e);
            }
        });
    }

    private void addSdp(Request req, String sdp) throws Exception {
        if (sdp != null) {
            req.addHeader((Header)this.headerFactory.createContentLengthHeader(sdp.length()));
            req.setContent((Object)sdp, this.headerFactory.createContentTypeHeader("application", "sdp"));
        }
    }

    public void invite(Room r, String sdp) {
        String sipNumber = SipManager.getSipNumber(r);
        if (sipNumber == null) {
            log.warn("Failed to get SIP number for room: {}", (Object)r);
            return;
        }
        this.sendRequest("INVITE", sipNumber, uri -> uri.setUser(sipNumber), req -> {
            try {
                this.addAllow((Request)req);
                this.addSdp((Request)req, sdp);
            }
            catch (Exception e) {
                log.error("fail patch invite request", (Throwable)e);
            }
        });
    }

    public void destroy() {
        if (this.dialog != null) {
            this.sayBye();
        } else {
            this.doDestroy();
        }
    }

    private void doDestroy() {
        this.sipStack.stop();
        this.manager.freePort(this.localWsPort);
    }
}

