/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.room.poll;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesome6IconType;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.dao.room.PollDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.room.RoomPoll;
import org.apache.openmeetings.db.entity.room.RoomPollAnswer;
import org.apache.openmeetings.db.util.ws.RoomMessage;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.MainPanel;
import org.apache.openmeetings.web.common.OmModalCloseButton;
import org.apache.openmeetings.web.common.confirmation.ConfirmationHelper;
import org.apache.openmeetings.web.room.poll.CreatePollDialog;
import org.apache.openmeetings.web.room.poll.VoteDialog;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.danekja.java.util.function.serializable.SerializableConsumer;
import org.wicketstuff.jqplot.behavior.JqPlotBehavior;
import org.wicketstuff.jqplot.behavior.JqPlotCssResourceReference;
import org.wicketstuff.jqplot.behavior.JqPlotJavascriptResourceReference;
import org.wicketstuff.jqplot.lib.Chart;
import org.wicketstuff.jqplot.lib.ChartConfiguration;
import org.wicketstuff.jqplot.lib.JqPlotResources;
import org.wicketstuff.jqplot.lib.JqPlotUtils;
import org.wicketstuff.jqplot.lib.chart.BarChart;
import org.wicketstuff.jqplot.lib.chart.PieChart;
import org.wicketstuff.jqplot.lib.elements.Highlighter;
import org.wicketstuff.jqplot.lib.elements.Location;
import org.wicketstuff.jqplot.lib.elements.RendererOptions;

public class PollResultsDialog
extends Modal<RoomPoll> {
    private static final long serialVersionUID = 1L;
    private static final String[] NUM_TICKS = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    private final WebMarkupContainer chartDiv = new WebMarkupContainer("chart");
    private final Long roomId;
    private PollSelectForm selForm;
    private PollResultsForm dispForm;
    private BootstrapAjaxLink<String> close;
    private BootstrapAjaxLink<String> delete;
    private BootstrapAjaxLink<String> clone;
    private boolean moderator = false;
    private boolean opened = false;
    private String chartSimple;
    private String chartPie;
    private final CreatePollDialog createPoll;
    private DropDownChoice<String> chartType;
    @Inject
    private PollDao pollDao;
    @Inject
    private UserDao userDao;

    public PollResultsDialog(String id, CreatePollDialog createPoll, Long roomId) {
        super(id);
        this.roomId = roomId;
        this.createPoll = createPoll;
    }

    protected void onInitialize() {
        this.header((IModel)new ResourceModel("37"));
        this.setUseCloseHandler(true);
        this.chartSimple = this.getString("1414");
        this.chartPie = this.getString("1415");
        Component[] componentArray = new Component[1];
        this.selForm = new PollSelectForm("selForm");
        componentArray[0] = this.selForm;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.dispForm = new PollResultsForm("dispForm");
        componentArray2[0] = this.dispForm;
        this.add(componentArray2);
        this.close = new BootstrapAjaxLink<String>("button", null, Buttons.Type.Outline_Danger, (IModel)new ResourceModel("1418")){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                Long id = ((RoomPoll)PollResultsDialog.this.dispForm.getModelObject()).getId();
                PollResultsDialog.this.pollDao.close(PollResultsDialog.this.roomId);
                PollResultsDialog.this.selForm.updateModel((IPartialPageRequestHandler)target);
                RoomPoll p = PollResultsDialog.this.pollDao.get(id);
                PollResultsDialog.this.selForm.select.setModelObject((Object)p);
                PollResultsDialog.this.dispForm.updateModel(p, true, (IPartialPageRequestHandler)target);
                WebSocketHelper.sendRoom((RoomMessage)new RoomMessage(PollResultsDialog.this.roomId, ((MainPanel)((Object)this.findParent(MainPanel.class))).getClient(), RoomMessage.Type.POLL_UPDATED));
                PollResultsDialog.this.close((IPartialPageRequestHandler)target);
            }
        };
        this.addButton((Component)this.close);
        this.close.setIconType((IconType)FontAwesome6IconType.xmark_s).add(new Behavior[]{ConfirmationHelper.newOkCancelDangerConfirm((Component)this, this.getString("1419"))});
        this.close.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        this.delete = new BootstrapAjaxLink<String>("button", null, Buttons.Type.Outline_Danger, (IModel)new ResourceModel("1420")){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                PollResultsDialog.this.pollDao.delete((RoomPoll)PollResultsDialog.this.dispForm.getModelObject());
                PollResultsDialog.this.selForm.updateModel((IPartialPageRequestHandler)target);
                PollResultsDialog.this.dispForm.updateModel((RoomPoll)PollResultsDialog.this.selForm.select.getModelObject(), true, (IPartialPageRequestHandler)target);
                WebSocketHelper.sendRoom((RoomMessage)new RoomMessage(PollResultsDialog.this.roomId, ((MainPanel)((Object)this.findParent(MainPanel.class))).getClient(), RoomMessage.Type.POLL_UPDATED));
                PollResultsDialog.this.close((IPartialPageRequestHandler)target);
            }
        };
        this.addButton((Component)this.delete);
        this.delete.setIconType((IconType)FontAwesome6IconType.trash_s).add(new Behavior[]{ConfirmationHelper.newOkCancelDangerConfirm((Component)this, this.getString("1421"))});
        this.delete.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        this.clone = new BootstrapAjaxLink<String>("button", null, Buttons.Type.Outline_Danger, (IModel)new ResourceModel("poll.clone")){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                RoomPoll rp = (RoomPoll)PollResultsDialog.this.dispForm.getModelObject();
                RoomPoll nrp = new RoomPoll();
                nrp.setCreator(PollResultsDialog.this.userDao.get(WebSession.getUserId()));
                nrp.setName(rp.getName());
                nrp.setQuestion(rp.getQuestion());
                nrp.setType(rp.getType());
                nrp.setRoom(rp.getRoom());
                PollResultsDialog.this.createPoll.setModelObject(nrp);
                PollResultsDialog.this.createPoll.setModelObject(nrp);
                target.add(new Component[]{PollResultsDialog.this.createPoll.getForm()});
                PollResultsDialog.this.createPoll.show((IPartialPageRequestHandler)target);
                PollResultsDialog.this.close((IPartialPageRequestHandler)target);
            }
        };
        this.addButton((Component)this.clone);
        this.clone.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        this.addButton((Component)OmModalCloseButton.of());
        this.add(new Component[]{this.chartDiv.setOutputMarkupId(true)});
        super.onInitialize();
    }

    public void updateModel(IPartialPageRequestHandler target, boolean onOpen, boolean moderator) {
        this.selForm.updateModel(target);
        this.moderator = moderator;
        RoomPoll p = (RoomPoll)this.selForm.select.getModelObject();
        this.dispForm.updateModel(p, !onOpen, target);
    }

    private StringBuilder getScript(Chart<?> chart, boolean onShow) {
        StringBuilder sb = new StringBuilder().append("$('#").append(this.chartDiv.getMarkupId()).append("').html(''); ");
        if (onShow) {
            sb.append("$('#").append(this.getMarkupId()).append("').off('shown.bs.modal').on('shown.bs.modal', function (e) {\n");
        }
        sb.append("$.jqplot('").append(this.chartDiv.getMarkupId()).append("', ").append(chart.getChartData().toJsonString()).append(", ").append(JqPlotUtils.jqPlotToJson((ChartConfiguration)chart.getChartConfiguration())).append(");");
        if (onShow) {
            sb.append("});");
        }
        return sb;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JqPlotJavascriptResourceReference.get()));
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)JqPlotCssResourceReference.get()));
        PieChart c1 = new PieChart(null);
        c1.getChartConfiguration().setHighlighter(new Highlighter());
        for (Chart chart : new Chart[]{c1, new BarChart(null)}) {
            for (String resource : JqPlotUtils.retriveJavaScriptResources((Chart)chart)) {
                response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(JqPlotBehavior.class, PollResultsDialog.removeMinified(resource))));
            }
        }
    }

    private static String removeMinified(String inName) {
        Object name = inName;
        int idxOfExtension = ((String)name).lastIndexOf(46);
        if (idxOfExtension > -1) {
            String extension = ((String)name).substring(idxOfExtension);
            if (((String)(name = ((String)name).substring(0, ((String)name).length() - extension.length() + 1))).endsWith(".min.")) {
                name = ((String)name).substring(0, ((String)name).length() - 5) + extension;
            }
        }
        return name;
    }

    public Modal<RoomPoll> show(IPartialPageRequestHandler handler) {
        this.opened = true;
        super.show(handler);
        this.redraw(handler, true);
        return this;
    }

    public void onClose(IPartialPageRequestHandler handler) {
        this.opened = false;
    }

    public boolean isOpened() {
        return this.opened;
    }

    private String[] getTicks(RoomPoll p) {
        String[] stringArray;
        if (p != null && RoomPoll.Type.NUMERIC == p.getType()) {
            stringArray = NUM_TICKS;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = this.getString("35");
            stringArray = stringArray2;
            stringArray2[1] = this.getString("34");
        }
        return stringArray;
    }

    private static Integer[] initValues(int size) {
        Integer[] values = new Integer[size];
        for (int i = 0; i < size; ++i) {
            values[i] = 0;
        }
        return values;
    }

    private static Integer[] getValues(RoomPoll p) {
        Integer[] values = PollResultsDialog.initValues(p != null && RoomPoll.Type.NUMERIC == p.getType() ? 10 : 2);
        if (p != null) {
            for (RoomPollAnswer a : p.getAnswers()) {
                Integer n;
                int n2;
                Integer[] integerArray;
                if (RoomPoll.Type.NUMERIC == p.getType()) {
                    integerArray = values;
                    n2 = a.getPointList() - 1;
                    n = integerArray[n2];
                    integerArray[n2] = integerArray[n2] + 1;
                    continue;
                }
                integerArray = values;
                n2 = Boolean.FALSE.equals(a.getAnswer()) ? 0 : 1;
                n = integerArray[n2];
                integerArray[n2] = integerArray[n2] + 1;
            }
        }
        return values;
    }

    private BarChart<Integer> barChart(RoomPoll p) {
        String[] ticks = this.getTicks(p);
        BarChart barChart = new BarChart(null);
        barChart.addValue(List.of(PollResultsDialog.getValues(p)));
        barChart.getSeriesDefaults().setRendererOptions(new RendererOptions().setHighlightMouseDown(Boolean.valueOf(true)).setShowDataLabels(Boolean.valueOf(true)).setFill(Boolean.valueOf(false)).setSliceMargin(Integer.valueOf(4)).setLineWidth(Integer.valueOf(5)).setBarDirection("horizontal"));
        Highlighter h = new Highlighter();
        h.setShow(Boolean.valueOf(true));
        h.setFormatString("%s, %P");
        h.setTooltipLocation(Location.ne);
        h.setShowTooltip(Boolean.valueOf(true));
        h.setUseAxesFormatters(Boolean.valueOf(false));
        ChartConfiguration cfg = barChart.getChartConfiguration();
        cfg.setLegend(null).setHighlighter(h);
        cfg.axesInstance().setXaxis(null);
        cfg.axesInstance().yAxisInstance().setTicks(ticks).setRenderer(JqPlotResources.CategoryAxisRenderer);
        return barChart;
    }

    private PieChart<Integer> pieChart(RoomPoll p) {
        PieChart pieChart = new PieChart(null);
        String[] ticks = this.getTicks(p);
        Integer[] values = PollResultsDialog.getValues(p);
        for (int i = 0; i < values.length; ++i) {
            pieChart.addValue(ticks[i], (Number)values[i]);
        }
        pieChart.getSeriesDefaults().setRendererOptions(new RendererOptions().setHighlightMouseDown(Boolean.valueOf(true)).setShowDataLabels(Boolean.valueOf(true)).setFill(Boolean.valueOf(false)).setSliceMargin(Integer.valueOf(4)).setLineWidth(Integer.valueOf(5)));
        Highlighter h = new Highlighter();
        h.setShow(Boolean.valueOf(true));
        h.setFormatString("%s, %P");
        h.setTooltipLocation(Location.ne);
        h.setShowTooltip(Boolean.valueOf(true));
        h.setUseAxesFormatters(Boolean.valueOf(false));
        pieChart.getChartConfiguration().setLegend(null).setHighlighter(h);
        return pieChart;
    }

    private void redraw(IPartialPageRequestHandler handler, boolean onShow) {
        RoomPoll p = (RoomPoll)this.dispForm.getModelObject();
        BarChart<Integer> chart = this.chartSimple.equals(this.chartType.getModelObject()) ? this.barChart(p) : this.pieChart(p);
        handler.appendJavaScript((CharSequence)this.getScript((Chart<?>)chart, onShow));
    }

    private class PollSelectForm
    extends Form<RoomPoll> {
        private static final long serialVersionUID = 1L;
        private DropDownChoice<RoomPoll> select;

        PollSelectForm(String id) {
            super(id);
            this.setOutputMarkupId(true);
        }

        protected void onInitialize() {
            super.onInitialize();
            Component[] componentArray = new Component[1];
            this.select = new DropDownChoice("polls", (IModel)Model.of((Serializable)((RoomPoll)null)), new ArrayList(), (IChoiceRenderer)new ChoiceRenderer<RoomPoll>(){
                private static final long serialVersionUID = 1L;

                public Object getDisplayValue(RoomPoll poll) {
                    if (poll == null) {
                        return "";
                    }
                    return poll.getName() + (String)(poll.isArchived() ? "" : " (" + PollSelectForm.this.getString("1413") + ")");
                }

                public String getIdValue(RoomPoll poll, int index) {
                    return poll == null ? "" : "" + poll.getId();
                }
            });
            componentArray[0] = this.select.add(new Behavior[]{AjaxFormComponentUpdatingBehavior.onUpdate((String)"change", (SerializableConsumer & Serializable)target -> PollResultsDialog.this.dispForm.updateModel((RoomPoll)this.select.getModelObject(), true, (IPartialPageRequestHandler)target))});
            this.add(componentArray);
            this.updateModel(null);
        }

        public void updateModel(IPartialPageRequestHandler handler) {
            ArrayList<RoomPoll> list = new ArrayList<RoomPoll>();
            RoomPoll p = PollResultsDialog.this.pollDao.getByRoom(PollResultsDialog.this.roomId);
            if (p != null) {
                list.add(p);
            }
            list.addAll(PollResultsDialog.this.pollDao.getArchived(PollResultsDialog.this.roomId));
            this.select.setChoices(list);
            this.select.setModelObject(list.isEmpty() ? null : (RoomPoll)list.get(0));
            if (handler != null) {
                handler.add(new Component[]{this});
            }
        }
    }

    private class PollResultsForm
    extends Form<RoomPoll> {
        private static final long serialVersionUID = 1L;
        private final Label name;
        private final Label question;
        private final Label count;

        PollResultsForm(String id) {
            super(id, (IModel)Model.of((Serializable)((RoomPoll)null)));
            this.name = new Label("name", (IModel)Model.of((Serializable)((Object)((String)null))));
            this.question = new Label("question", (IModel)Model.of((Serializable)((Object)((String)null))));
            this.count = new Label("count", (IModel)Model.of((Serializable)Integer.valueOf(0)));
            this.setOutputMarkupId(true);
        }

        protected void onInitialize() {
            this.add(new Component[]{this.name, this.question, this.count});
            PollResultsDialog.this.chartType = new DropDownChoice("chartType", (IModel)Model.of((Serializable)((Object)PollResultsDialog.this.chartSimple)), List.of(PollResultsDialog.this.chartSimple, PollResultsDialog.this.chartPie));
            this.add(new Component[]{PollResultsDialog.this.chartType.add(new Behavior[]{AjaxFormComponentUpdatingBehavior.onUpdate((String)"change", (SerializableConsumer & Serializable)target -> PollResultsDialog.this.redraw((IPartialPageRequestHandler)target, false))})});
            super.onInitialize();
        }

        public void updateModel(RoomPoll poll, boolean redraw, IPartialPageRequestHandler handler) {
            this.setModelObject(poll);
            this.name.setDefaultModelObject((Object)(poll == null ? "" : VoteDialog.getName((Component)this, poll.getCreator())));
            this.question.setDefaultModelObject((Object)(poll == null ? "" : poll.getQuestion()));
            this.count.setDefaultModelObject((Object)(poll == null ? 0 : poll.getAnswers().size()));
            handler.add(new Component[]{this});
            PollResultsDialog.this.close.setVisible(PollResultsDialog.this.moderator && poll != null && !poll.isArchived());
            PollResultsDialog.this.clone.setVisible(PollResultsDialog.this.moderator && poll != null && poll.isArchived());
            PollResultsDialog.this.delete.setVisible(PollResultsDialog.this.moderator);
            handler.add(new Component[]{PollResultsDialog.this.close, PollResultsDialog.this.clone, PollResultsDialog.this.delete});
            if (redraw) {
                PollResultsDialog.this.redraw(handler, false);
            }
        }
    }
}

