/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.rpc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.crypto.CipherInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.crypto.CryptoInputStream;
import org.apache.hadoop.crypto.CryptoOutputStream;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.hdds.client.DefaultReplicationConfig;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.RatisReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfigValidator;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.ContainerClientMetrics;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.StreamBufferArgs;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.client.ClientTrustManager;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.BlockLocationInfo;
import org.apache.hadoop.hdds.scm.storage.ByteBufferStreamOutput;
import org.apache.hadoop.hdds.scm.storage.MultipartInputStream;
import org.apache.hadoop.hdds.security.x509.certificate.client.CACertificateProvider;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.io.ByteBufferPool;
import org.apache.hadoop.io.ElasticByteBufferPool;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.OzoneConfigKeys;
import org.apache.hadoop.ozone.OzoneFsServerDefaults;
import org.apache.hadoop.ozone.OzoneManagerVersion;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.client.BucketArgs;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneKeyDetails;
import org.apache.hadoop.ozone.client.OzoneKeyLocation;
import org.apache.hadoop.ozone.client.OzoneMultipartUpload;
import org.apache.hadoop.ozone.client.OzoneMultipartUploadList;
import org.apache.hadoop.ozone.client.OzoneMultipartUploadPartListParts;
import org.apache.hadoop.ozone.client.OzoneSnapshot;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.TenantArgs;
import org.apache.hadoop.ozone.client.VolumeArgs;
import org.apache.hadoop.ozone.client.io.BlockInputStreamFactory;
import org.apache.hadoop.ozone.client.io.BlockInputStreamFactoryImpl;
import org.apache.hadoop.ozone.client.io.CipherOutputStreamOzone;
import org.apache.hadoop.ozone.client.io.ECBlockInputStream;
import org.apache.hadoop.ozone.client.io.ECKeyOutputStream;
import org.apache.hadoop.ozone.client.io.KeyDataStreamOutput;
import org.apache.hadoop.ozone.client.io.KeyInputStream;
import org.apache.hadoop.ozone.client.io.KeyOutputStream;
import org.apache.hadoop.ozone.client.io.LengthInputStream;
import org.apache.hadoop.ozone.client.io.OzoneCryptoInputStream;
import org.apache.hadoop.ozone.client.io.OzoneDataStreamOutput;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.client.rpc.OzoneKMSUtil;
import org.apache.hadoop.ozone.om.OmConfig;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketEncryptionKeyInfo;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.DeleteTenantState;
import org.apache.hadoop.ozone.om.helpers.ErrorInfo;
import org.apache.hadoop.ozone.om.helpers.KeyInfoWithVolumeContext;
import org.apache.hadoop.ozone.om.helpers.LeaseKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmBucketArgs;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDeleteKeys;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmMultipartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteList;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadList;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadListParts;
import org.apache.hadoop.ozone.om.helpers.OmPartInfo;
import org.apache.hadoop.ozone.om.helpers.OmRenameKeys;
import org.apache.hadoop.ozone.om.helpers.OmTenantArgs;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OpenKeySession;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatusLight;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.om.helpers.S3VolumeContext;
import org.apache.hadoop.ozone.om.helpers.ServiceInfo;
import org.apache.hadoop.ozone.om.helpers.ServiceInfoEx;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.helpers.TenantStateList;
import org.apache.hadoop.ozone.om.helpers.TenantUserInfoValue;
import org.apache.hadoop.ozone.om.helpers.TenantUserList;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.om.protocol.S3Auth;
import org.apache.hadoop.ozone.om.protocolPB.OmTransport;
import org.apache.hadoop.ozone.om.protocolPB.OmTransportFactory;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerClientProtocol;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolClientSideTranslatorPB;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.GDPRSymmetricKey;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.snapshot.CancelSnapshotDiffResponse;
import org.apache.hadoop.ozone.snapshot.ListSnapshotDiffJobResponse;
import org.apache.hadoop.ozone.snapshot.ListSnapshotResponse;
import org.apache.hadoop.ozone.snapshot.SnapshotDiffResponse;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Time;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.function.CheckedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcClient
implements ClientProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(RpcClient.class);
    private static final int EC_RECONSTRUCT_STRIPE_READ_POOL_MIN_SIZE = 3;
    private static final int WRITE_POOL_MIN_SIZE = 1;
    private final ConfigurationSource conf;
    private final OzoneManagerClientProtocol ozoneManagerClient;
    private final XceiverClientFactory xceiverClientManager;
    private final UserGroupInformation ugi;
    private UserGroupInformation s3gUgi;
    private final ClientId clientId = ClientId.randomId();
    private final boolean unsafeByteBufferConversion;
    private Text dtService;
    private final boolean topologyAwareReadEnabled;
    private final boolean checkKeyNameEnabled;
    private final OzoneClientConfig clientConfig;
    private final ReplicationConfigValidator replicationConfigValidator;
    private final Cache<URI, KeyProvider> keyProviderCache;
    private final boolean getLatestVersionLocation;
    private final ByteBufferPool byteBufferPool;
    private final BlockInputStreamFactory blockInputStreamFactory;
    private final OzoneManagerVersion omVersion;
    private final MemoizedSupplier<ExecutorService> ecReconstructExecutor;
    private final ContainerClientMetrics clientMetrics;
    private final MemoizedSupplier<ExecutorService> writeExecutor;
    private final AtomicBoolean isS3GRequest = new AtomicBoolean(false);
    private volatile OzoneFsServerDefaults serverDefaults;
    private volatile long serverDefaultsLastUpdate;
    private final long serverDefaultsValidityPeriod;

    public RpcClient(ConfigurationSource conf, String omServiceId) throws IOException {
        Preconditions.checkNotNull((Object)conf);
        this.conf = conf;
        this.ugi = UserGroupInformation.getCurrentUser();
        this.replicationConfigValidator = (ReplicationConfigValidator)this.conf.getObject(ReplicationConfigValidator.class);
        this.clientConfig = (OzoneClientConfig)conf.getObject(OzoneClientConfig.class);
        this.ecReconstructExecutor = MemoizedSupplier.valueOf(() -> RpcClient.createThreadPoolExecutor(3, this.clientConfig.getEcReconstructStripeReadPoolLimit(), "ec-reconstruct-reader-TID-%d"));
        this.writeExecutor = MemoizedSupplier.valueOf(() -> RpcClient.createThreadPoolExecutor(1, Integer.MAX_VALUE, "client-write-TID-%d"));
        OmTransport omTransport = this.createOmTransport(omServiceId);
        OzoneManagerProtocolClientSideTranslatorPB ozoneManagerProtocolClientSideTranslatorPB = new OzoneManagerProtocolClientSideTranslatorPB(omTransport, this.clientId.toString());
        this.ozoneManagerClient = (OzoneManagerClientProtocol)TracingUtil.createProxy((Object)ozoneManagerProtocolClientSideTranslatorPB, OzoneManagerClientProtocol.class, (ConfigurationSource)conf);
        if (this.getThreadLocalS3Auth() != null) {
            this.s3gUgi = UserGroupInformation.createRemoteUser((String)this.getThreadLocalS3Auth().getUserPrincipal());
        }
        this.dtService = omTransport.getDelegationTokenService();
        ServiceInfoEx serviceInfoEx = this.ozoneManagerClient.getServiceInfo();
        this.omVersion = RpcClient.getOmVersion(serviceInfoEx);
        if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf)) {
            OzoneManagerVersion minOmVersion;
            boolean isS3 = conf.getBoolean("ozone.s3.auth.check", false);
            ozoneManagerProtocolClientSideTranslatorPB.setS3AuthCheck(isS3);
            if (isS3 && !RpcClient.validateOmVersion(minOmVersion = (OzoneManagerVersion)conf.getEnum("ozone.client.required.om.version.min", (Enum)OzoneManagerVersion.DEFAULT_VERSION), serviceInfoEx.getServiceInfoList())) {
                if (LOG.isDebugEnabled()) {
                    for (ServiceInfo s : serviceInfoEx.getServiceInfoList()) {
                        LOG.debug("Node {} version {}", (Object)s.getHostname(), (Object)s.getProtobuf().getOMVersion());
                    }
                }
                throw new RuntimeException("Minimum OzoneManager version required is: " + minOmVersion + ", in the service list there are not enough Ozone Managers meet the criteria.");
            }
        }
        this.xceiverClientManager = this.createXceiverClientFactory(serviceInfoEx);
        this.unsafeByteBufferConversion = conf.getBoolean("ozone.UnsafeByteOperations.enabled", true);
        this.topologyAwareReadEnabled = conf.getBoolean("ozone.network.topology.aware.read", true);
        this.checkKeyNameEnabled = ((OmConfig)conf.getObject(OmConfig.class)).isKeyNameCharacterCheckEnabled();
        this.getLatestVersionLocation = conf.getBoolean("ozone.client.key.latest.version.location", true);
        long keyProviderCacheExpiryMs = conf.getTimeDuration("ozone.client.key.provider.cache.expiry", OzoneConfigKeys.OZONE_CLIENT_KEY_PROVIDER_CACHE_EXPIRY_DEFAULT, TimeUnit.MILLISECONDS);
        this.keyProviderCache = CacheBuilder.newBuilder().expireAfterAccess(keyProviderCacheExpiryMs, TimeUnit.MILLISECONDS).removalListener((RemovalListener)new RemovalListener<URI, KeyProvider>(){

            public void onRemoval(@Nonnull RemovalNotification<URI, KeyProvider> notification) {
                try {
                    assert (notification.getValue() != null);
                    ((KeyProvider)notification.getValue()).close();
                }
                catch (Throwable t) {
                    LOG.error("Error closing KeyProvider with uri [" + notification.getKey() + "]", t);
                }
            }
        }).build();
        this.byteBufferPool = new ElasticByteBufferPool();
        this.blockInputStreamFactory = BlockInputStreamFactoryImpl.getInstance((ByteBufferPool)this.byteBufferPool, this.ecReconstructExecutor);
        this.clientMetrics = ContainerClientMetrics.acquire();
        this.serverDefaultsValidityPeriod = conf.getTimeDuration("ozone.client.server-defaults.validity.period.ms", OzoneConfigKeys.OZONE_CLIENT_SERVER_DEFAULTS_VALIDITY_PERIOD_MS_DEFAULT, TimeUnit.MILLISECONDS);
        TracingUtil.initTracing((String)"client", (ConfigurationSource)conf);
    }

    public XceiverClientFactory getXceiverClientManager() {
        return this.xceiverClientManager;
    }

    public static OzoneManagerVersion getOmVersion(ServiceInfoEx info) {
        OzoneManagerVersion version = OzoneManagerVersion.CURRENT;
        for (ServiceInfo si : info.getServiceInfoList()) {
            OzoneManagerVersion current;
            if (si.getNodeType() != HddsProtos.NodeType.OM || version.compareTo((Enum)(current = OzoneManagerVersion.fromProtoValue((int)si.getProtobuf().getOMVersion()))) <= 0) continue;
            version = current;
        }
        LOG.trace("Ozone Manager version is {}", (Object)version.name());
        return version;
    }

    static boolean validateOmVersion(OzoneManagerVersion minimumVersion, List<ServiceInfo> serviceInfoList) {
        if (minimumVersion == OzoneManagerVersion.FUTURE_VERSION) {
            throw new IllegalArgumentException("Configuration error, expected OzoneManager version config evaluates to a future version.");
        }
        if (minimumVersion == null || minimumVersion == OzoneManagerVersion.DEFAULT_VERSION) {
            return true;
        }
        boolean found = false;
        for (ServiceInfo s : serviceInfoList) {
            if (s.getNodeType() != HddsProtos.NodeType.OM) continue;
            OzoneManagerVersion omv = OzoneManagerVersion.fromProtoValue((int)s.getProtobuf().getOMVersion());
            if (minimumVersion.compareTo((Enum)omv) > 0) {
                return false;
            }
            found = true;
        }
        return found;
    }

    @Nonnull
    @VisibleForTesting
    protected XceiverClientFactory createXceiverClientFactory(ServiceInfoEx serviceInfo) throws IOException {
        ClientTrustManager trustManager = null;
        if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)this.conf)) {
            CACertificateProvider remoteCAProvider = () -> this.ozoneManagerClient.getServiceInfo().provideCACerts();
            trustManager = new ClientTrustManager(remoteCAProvider, (CACertificateProvider)serviceInfo);
        }
        return new XceiverClientManager(this.conf, (XceiverClientManager.ScmClientConfig)this.conf.getObject(XceiverClientManager.ScmClientConfig.class), trustManager);
    }

    @VisibleForTesting
    protected OmTransport createOmTransport(String omServiceId) throws IOException {
        return OmTransportFactory.create((ConfigurationSource)this.conf, (UserGroupInformation)this.ugi, (String)omServiceId);
    }

    @Override
    public List<OzoneManagerProtocolProtos.OMRoleInfo> getOmRoleInfos() throws IOException {
        List serviceList = this.ozoneManagerClient.getServiceList();
        ArrayList<OzoneManagerProtocolProtos.OMRoleInfo> roleInfos = new ArrayList<OzoneManagerProtocolProtos.OMRoleInfo>();
        for (ServiceInfo serviceInfo : serviceList) {
            OzoneManagerProtocolProtos.OMRoleInfo omRoleInfo;
            if (!serviceInfo.getNodeType().equals((Object)HddsProtos.NodeType.OM) || (omRoleInfo = serviceInfo.getOmRoleInfo()) == null) continue;
            roleInfos.add(omRoleInfo);
        }
        return roleInfos;
    }

    @Override
    public void createVolume(String volumeName) throws IOException {
        this.createVolume(volumeName, VolumeArgs.newBuilder().build());
    }

    @Override
    public void createVolume(String volumeName, VolumeArgs volArgs) throws IOException {
        RpcClient.verifyVolumeName(volumeName);
        Preconditions.checkNotNull((Object)volArgs);
        RpcClient.verifyCountsQuota(volArgs.getQuotaInNamespace());
        RpcClient.verifySpaceQuota(volArgs.getQuotaInBytes());
        String admin = volArgs.getAdmin() == null ? this.ugi.getShortUserName() : volArgs.getAdmin();
        String owner = volArgs.getOwner() == null ? this.ugi.getShortUserName() : volArgs.getOwner();
        long quotaInNamespace = volArgs.getQuotaInNamespace();
        long quotaInBytes = volArgs.getQuotaInBytes();
        OmVolumeArgs.Builder builder = OmVolumeArgs.newBuilder();
        builder.setVolume(volumeName);
        builder.setAdminName(admin);
        builder.setOwnerName(owner);
        builder.setQuotaInBytes(quotaInBytes);
        builder.setQuotaInNamespace(quotaInNamespace);
        builder.setUsedNamespace(0L);
        builder.addAllMetadata(volArgs.getMetadata());
        List<OzoneAcl> volumeAcls = volArgs.getAcls();
        if (volumeAcls != null) {
            for (OzoneAcl ozoneAcl : volumeAcls.stream().distinct().collect(Collectors.toList())) {
                builder.addOzoneAcls(ozoneAcl);
            }
        }
        if (volArgs.getQuotaInBytes() == 0L) {
            LOG.info("Creating Volume: {}, with {} as owner.", (Object)volumeName, (Object)owner);
        } else {
            LOG.info("Creating Volume: {}, with {} as owner and space quota set to {} bytes, counts quota set to {}", new Object[]{volumeName, owner, quotaInBytes, quotaInNamespace});
        }
        this.ozoneManagerClient.createVolume(builder.build());
    }

    @Override
    public boolean setVolumeOwner(String volumeName, String owner) throws IOException {
        RpcClient.verifyVolumeName(volumeName);
        Preconditions.checkNotNull((Object)owner);
        return this.ozoneManagerClient.setOwner(volumeName, owner);
    }

    @Override
    public void setVolumeQuota(String volumeName, long quotaInNamespace, long quotaInBytes) throws IOException {
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyCountsQuota(quotaInNamespace);
        RpcClient.verifySpaceQuota(quotaInBytes);
        OmVolumeArgs omVolumeArgs = this.ozoneManagerClient.getVolumeInfo(volumeName);
        if (omVolumeArgs.getQuotaInNamespace() == -2L) {
            LOG.warn("Volume {} is created before version 1.1.0, usedNamespace may be inaccurate and it is not recommended to enable quota.", (Object)volumeName);
        }
        this.ozoneManagerClient.setQuota(volumeName, quotaInNamespace, quotaInBytes);
    }

    @Override
    public OzoneVolume getVolumeDetails(String volumeName) throws IOException {
        RpcClient.verifyVolumeName(volumeName);
        OmVolumeArgs volume = this.ozoneManagerClient.getVolumeInfo(volumeName);
        return this.buildOzoneVolume(volume);
    }

    @Override
    public S3VolumeContext getS3VolumeContext() throws IOException {
        S3VolumeContext resp = this.ozoneManagerClient.getS3VolumeContext();
        String userPrincipal = resp.getUserPrincipal();
        this.updateS3Principal(userPrincipal);
        return resp;
    }

    private void updateS3Principal(String userPrincipal) {
        S3Auth s3Auth = this.getThreadLocalS3Auth();
        if (s3Auth != null) {
            LOG.debug("Updating S3Auth.userPrincipal to {}", (Object)userPrincipal);
            s3Auth.setUserPrincipal(userPrincipal);
            this.setThreadLocalS3Auth(s3Auth);
        }
    }

    @Override
    public OzoneVolume buildOzoneVolume(OmVolumeArgs volume) {
        return OzoneVolume.newBuilder(this.conf, this).setName(volume.getVolume()).setAdmin(volume.getAdminName()).setOwner(volume.getOwnerName()).setQuotaInBytes(volume.getQuotaInBytes()).setQuotaInNamespace(volume.getQuotaInNamespace()).setUsedNamespace(volume.getUsedNamespace()).setCreationTime(volume.getCreationTime()).setModificationTime(volume.getModificationTime()).setAcls(volume.getAcls()).setMetadata(volume.getMetadata()).setRefCount(volume.getRefCount()).build();
    }

    @Override
    public boolean checkVolumeAccess(String volumeName, OzoneAcl acl) throws IOException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public void deleteVolume(String volumeName) throws IOException {
        RpcClient.verifyVolumeName(volumeName);
        this.ozoneManagerClient.deleteVolume(volumeName);
    }

    @Override
    public List<OzoneVolume> listVolumes(String volumePrefix, String prevVolume, int maxListResult) throws IOException {
        List volumes = this.ozoneManagerClient.listAllVolumes(volumePrefix, prevVolume, maxListResult);
        return volumes.stream().map(volume -> OzoneVolume.newBuilder(this.conf, this).setName(volume.getVolume()).setAdmin(volume.getAdminName()).setOwner(volume.getOwnerName()).setQuotaInBytes(volume.getQuotaInBytes()).setQuotaInNamespace(volume.getQuotaInNamespace()).setUsedNamespace(volume.getUsedNamespace()).setCreationTime(volume.getCreationTime()).setModificationTime(volume.getModificationTime()).setAcls(volume.getAcls()).build()).collect(Collectors.toList());
    }

    @Override
    public List<OzoneVolume> listVolumes(String user, String volumePrefix, String prevVolume, int maxListResult) throws IOException {
        List volumes = this.ozoneManagerClient.listVolumeByUser(user, volumePrefix, prevVolume, maxListResult);
        return volumes.stream().map(volume -> OzoneVolume.newBuilder(this.conf, this).setName(volume.getVolume()).setAdmin(volume.getAdminName()).setOwner(volume.getOwnerName()).setQuotaInBytes(volume.getQuotaInBytes()).setQuotaInNamespace(volume.getQuotaInNamespace()).setUsedNamespace(volume.getUsedNamespace()).setCreationTime(volume.getCreationTime()).setModificationTime(volume.getModificationTime()).setAcls(volume.getAcls()).setMetadata(volume.getMetadata()).build()).collect(Collectors.toList());
    }

    @Override
    public void createBucket(String volumeName, String bucketName) throws IOException {
        this.createBucket(volumeName, bucketName, BucketArgs.newBuilder().build());
    }

    @Override
    public void createBucket(String volumeName, String bucketName, BucketArgs bucketArgs) throws IOException {
        DefaultReplicationConfig defaultReplicationConfig;
        String owner;
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyBucketName(bucketName);
        Preconditions.checkNotNull((Object)bucketArgs);
        RpcClient.verifyCountsQuota(bucketArgs.getQuotaInNamespace());
        RpcClient.verifySpaceQuota(bucketArgs.getQuotaInBytes());
        if (this.omVersion.compareTo((Enum)OzoneManagerVersion.ERASURE_CODED_STORAGE_SUPPORT) < 0 && bucketArgs.getDefaultReplicationConfig() != null && bucketArgs.getDefaultReplicationConfig().getType() == ReplicationType.EC) {
            throw new IOException("Can not set the default replication of the bucket to Erasure Coded replication, as OzoneManager does not support Erasure Coded replication.");
        }
        if (this.getThreadLocalS3Auth() != null) {
            UserGroupInformation s3gUGI = UserGroupInformation.createRemoteUser((String)this.getThreadLocalS3Auth().getUserPrincipal());
            owner = s3gUGI.getShortUserName();
        } else {
            owner = bucketArgs.getOwner() == null ? this.ugi.getShortUserName() : bucketArgs.getOwner();
        }
        boolean isVersionEnabled = bucketArgs.getVersioning();
        StorageType storageType = bucketArgs.getStorageType() == null ? StorageType.DEFAULT : bucketArgs.getStorageType();
        BucketLayout bucketLayout = bucketArgs.getBucketLayout();
        BucketEncryptionKeyInfo bek = null;
        if (bucketArgs.getEncryptionKey() != null) {
            bek = new BucketEncryptionKeyInfo.Builder().setKeyName(bucketArgs.getEncryptionKey()).build();
        }
        OmBucketInfo.Builder builder = OmBucketInfo.newBuilder();
        builder.setVolumeName(volumeName).setBucketName(bucketName).setIsVersionEnabled(isVersionEnabled).addAllMetadata(bucketArgs.getMetadata()).setStorageType(storageType).setSourceVolume(bucketArgs.getSourceVolume()).setSourceBucket(bucketArgs.getSourceBucket()).setQuotaInBytes(bucketArgs.getQuotaInBytes()).setQuotaInNamespace(bucketArgs.getQuotaInNamespace()).setBucketLayout(bucketLayout).setOwner(owner);
        if (bucketArgs.getAcls() != null) {
            builder.setAcls(bucketArgs.getAcls());
        }
        if (bucketArgs.getSourceVolume() != null && bucketArgs.getSourceBucket() != null) {
            builder.addAcl(OzoneAcl.LINK_BUCKET_DEFAULT_ACL);
        }
        if (bek != null) {
            builder.setBucketEncryptionKey(bek);
        }
        if ((defaultReplicationConfig = bucketArgs.getDefaultReplicationConfig()) != null) {
            builder.setDefaultReplicationConfig(defaultReplicationConfig);
        }
        String replicationType = defaultReplicationConfig == null ? "server-side default replication type" : defaultReplicationConfig.getType().toString();
        String layoutMsg = bucketLayout != null ? "with bucket layout " + bucketLayout : "with server-side default bucket layout";
        LOG.info("Creating Bucket: {}/{}, {}, {} as owner, Versioning {}, Storage Type set to {} and Encryption set to {}, Replication Type set to {}, Namespace Quota set to {}, Space Quota set to {} ", new Object[]{volumeName, bucketName, layoutMsg, owner, isVersionEnabled, storageType, bek != null, replicationType, bucketArgs.getQuotaInNamespace(), bucketArgs.getQuotaInBytes()});
        this.ozoneManagerClient.createBucket(builder.build());
    }

    private static void verifyVolumeName(String volumeName) throws OMException {
        try {
            HddsClientUtils.verifyResourceName((String)volumeName, (String)"volume", (boolean)false);
        }
        catch (IllegalArgumentException e) {
            throw new OMException(e.getMessage(), OMException.ResultCodes.INVALID_VOLUME_NAME);
        }
    }

    private static void verifyBucketName(String bucketName) throws OMException {
        try {
            HddsClientUtils.verifyResourceName((String)bucketName, (String)"bucket", (boolean)false);
        }
        catch (IllegalArgumentException e) {
            throw new OMException(e.getMessage(), OMException.ResultCodes.INVALID_BUCKET_NAME);
        }
    }

    private static void verifyCountsQuota(long quota) throws OMException {
        if (quota < -1L || quota == 0L) {
            throw new IllegalArgumentException("Invalid values for quota : counts quota is :" + quota + ".");
        }
    }

    private static void verifySpaceQuota(long quota) throws OMException {
        if (quota < -1L || quota == 0L) {
            throw new IllegalArgumentException("Invalid values for quota : space quota is :" + quota + ".");
        }
    }

    private UserGroupInformation getRealUserInfo() {
        if (this.ozoneManagerClient.getThreadLocalS3Auth() != null) {
            return this.s3gUgi;
        }
        return this.ugi;
    }

    @Override
    public Token<OzoneTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        Token token = this.ozoneManagerClient.getDelegationToken(renewer);
        if (token != null) {
            token.setService(this.dtService);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created token {} for dtService {}", (Object)token, (Object)this.dtService);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Cannot get ozone delegation token for renewer {} to access service {}", (Object)renewer, (Object)this.dtService);
        }
        return token;
    }

    @Override
    public long renewDelegationToken(Token<OzoneTokenIdentifier> token) throws IOException {
        return this.ozoneManagerClient.renewDelegationToken(token);
    }

    @Override
    public void cancelDelegationToken(Token<OzoneTokenIdentifier> token) throws IOException {
        this.ozoneManagerClient.cancelDelegationToken(token);
    }

    @Override
    @Nonnull
    public S3SecretValue getS3Secret(String kerberosID) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)kerberosID), (Object)"kerberosID cannot be null or empty.");
        return this.ozoneManagerClient.getS3Secret(kerberosID);
    }

    @Override
    public S3SecretValue getS3Secret(String kerberosID, boolean createIfNotExist) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)kerberosID), (Object)"kerberosID cannot be null or empty.");
        return this.ozoneManagerClient.getS3Secret(kerberosID, createIfNotExist);
    }

    @Override
    public S3SecretValue setS3Secret(String accessId, String secretKey) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)accessId), (Object)"accessId cannot be null or empty.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)secretKey), (Object)"secretKey cannot be null or empty.");
        return this.ozoneManagerClient.setS3Secret(accessId, secretKey);
    }

    @Override
    public void revokeS3Secret(String kerberosID) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)kerberosID), (Object)"kerberosID cannot be null or empty.");
        this.ozoneManagerClient.revokeS3Secret(kerberosID);
    }

    @Override
    public void createTenant(String tenantId) throws IOException {
        this.createTenant(tenantId, TenantArgs.newBuilder().setVolumeName(tenantId).build());
    }

    @Override
    public void createTenant(String tenantId, TenantArgs tenantArgs) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)tenantId), (Object)"tenantId cannot be null or empty.");
        Preconditions.checkNotNull((Object)tenantArgs);
        String volumeName = tenantArgs.getVolumeName();
        RpcClient.verifyVolumeName(volumeName);
        boolean forceCreationWhenVolumeExists = tenantArgs.getForceCreationWhenVolumeExists();
        OmTenantArgs.Builder builder = OmTenantArgs.newBuilder();
        builder.setTenantId(tenantId);
        builder.setVolumeName(volumeName);
        builder.setForceCreationWhenVolumeExists(tenantArgs.getForceCreationWhenVolumeExists());
        LOG.info("Creating Tenant: '{}', with volume: '{}', forceCreationWhenVolumeExists: {}", new Object[]{tenantId, volumeName, forceCreationWhenVolumeExists});
        this.ozoneManagerClient.createTenant(builder.build());
    }

    @Override
    public DeleteTenantState deleteTenant(String tenantId) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)tenantId), (Object)"tenantId cannot be null or empty.");
        return this.ozoneManagerClient.deleteTenant(tenantId);
    }

    @Override
    public S3SecretValue tenantAssignUserAccessId(String username, String tenantId, String accessId) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)username), (Object)"username can't be null or empty.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)tenantId), (Object)"tenantId can't be null or empty.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)accessId), (Object)"accessId can't be null or empty.");
        Preconditions.checkArgument((accessId.length() <= 100 ? 1 : 0) != 0, (Object)("accessId length (" + accessId.length() + ") exceeds the maximum length allowed (" + 100 + ")"));
        return this.ozoneManagerClient.tenantAssignUserAccessId(username, tenantId, accessId);
    }

    @Override
    public void tenantRevokeUserAccessId(String accessId) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)accessId), (Object)"accessId can't be null or empty.");
        this.ozoneManagerClient.tenantRevokeUserAccessId(accessId);
    }

    @Override
    public String createSnapshot(String volumeName, String bucketName, String snapshotName) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)volumeName), (Object)"volume can't be null or empty.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)bucketName), (Object)"bucket can't be null or empty.");
        return this.ozoneManagerClient.createSnapshot(volumeName, bucketName, snapshotName);
    }

    @Override
    public void renameSnapshot(String volumeName, String bucketName, String snapshotOldName, String snapshotNewName) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)volumeName), (Object)"volume can't be null or empty.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)bucketName), (Object)"bucket can't be null or empty.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)snapshotOldName), (Object)"old snapshot name can't be null or empty.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)snapshotNewName), (Object)"new snapshot name can't be null or empty.");
        this.ozoneManagerClient.renameSnapshot(volumeName, bucketName, snapshotOldName, snapshotNewName);
    }

    @Override
    public void deleteSnapshot(String volumeName, String bucketName, String snapshotName) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)volumeName), (Object)"volume can't be null or empty.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)bucketName), (Object)"bucket can't be null or empty.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)snapshotName), (Object)"snapshot name can't be null or empty.");
        this.ozoneManagerClient.deleteSnapshot(volumeName, bucketName, snapshotName);
    }

    @Override
    public OzoneSnapshot getSnapshotInfo(String volumeName, String bucketName, String snapshotName) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)volumeName), (Object)"volume can't be null or empty.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)bucketName), (Object)"bucket can't be null or empty.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)snapshotName), (Object)"snapshot name can't be null or empty.");
        SnapshotInfo snapshotInfo = this.ozoneManagerClient.getSnapshotInfo(volumeName, bucketName, snapshotName);
        return OzoneSnapshot.fromSnapshotInfo(snapshotInfo);
    }

    @Override
    @Deprecated
    public String printCompactionLogDag(String fileNamePrefix, String graphType) throws IOException {
        return this.ozoneManagerClient.printCompactionLogDag(fileNamePrefix, graphType);
    }

    @Override
    public SnapshotDiffResponse snapshotDiff(String volumeName, String bucketName, String fromSnapshot, String toSnapshot, String token, int pageSize, boolean forceFullDiff, boolean disableNativeDiff) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)volumeName), (Object)"volume can't be null or empty.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)bucketName), (Object)"bucket can't be null or empty.");
        return this.ozoneManagerClient.snapshotDiff(volumeName, bucketName, fromSnapshot, toSnapshot, token, pageSize, forceFullDiff, disableNativeDiff);
    }

    @Override
    public CancelSnapshotDiffResponse cancelSnapshotDiff(String volumeName, String bucketName, String fromSnapshot, String toSnapshot) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)volumeName), (Object)"volume can't be null or empty.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)bucketName), (Object)"bucket can't be null or empty.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)fromSnapshot), (Object)"fromSnapshot can't be null or empty.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)toSnapshot), (Object)"toSnapshot can't be null or empty.");
        return this.ozoneManagerClient.cancelSnapshotDiff(volumeName, bucketName, fromSnapshot, toSnapshot);
    }

    @Override
    public ListSnapshotDiffJobResponse listSnapshotDiffJobs(String volumeName, String bucketName, String jobStatus, boolean listAllStatus, String prevSnapshotDiffJob, int maxListResult) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)volumeName), (Object)"volume can't be null or empty.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)bucketName), (Object)"bucket can't be null or empty.");
        return this.ozoneManagerClient.listSnapshotDiffJobs(volumeName, bucketName, jobStatus, listAllStatus, prevSnapshotDiffJob, maxListResult);
    }

    @Override
    public ListSnapshotResponse listSnapshot(String volumeName, String bucketName, String snapshotPrefix, String prevSnapshot, int maxListResult) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)volumeName), (Object)"volume can't be null or empty.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)bucketName), (Object)"bucket can't be null or empty.");
        return this.ozoneManagerClient.listSnapshot(volumeName, bucketName, snapshotPrefix, prevSnapshot, maxListResult);
    }

    @Override
    public void tenantAssignAdmin(String accessId, String tenantId, boolean delegated) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)accessId), (Object)"accessId can't be null or empty.");
        this.ozoneManagerClient.tenantAssignAdmin(accessId, tenantId, delegated);
    }

    @Override
    public void tenantRevokeAdmin(String accessId, String tenantId) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)accessId), (Object)"accessId can't be null or empty.");
        this.ozoneManagerClient.tenantRevokeAdmin(accessId, tenantId);
    }

    @Override
    public TenantUserInfoValue tenantGetUserInfo(String userPrincipal) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)userPrincipal), (Object)"userPrincipal can't be null or empty.");
        return this.ozoneManagerClient.tenantGetUserInfo(userPrincipal);
    }

    @Override
    public TenantStateList listTenant() throws IOException {
        return this.ozoneManagerClient.listTenant();
    }

    @Override
    public TenantUserList listUsersInTenant(String tenantId, String prefix) throws IOException {
        return this.ozoneManagerClient.listUsersInTenant(tenantId, prefix);
    }

    @Override
    public void setBucketVersioning(String volumeName, String bucketName, Boolean versioning) throws IOException {
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyBucketName(bucketName);
        Preconditions.checkNotNull((Object)versioning);
        OmBucketArgs.Builder builder = OmBucketArgs.newBuilder();
        builder.setVolumeName(volumeName).setBucketName(bucketName).setIsVersionEnabled(versioning);
        this.ozoneManagerClient.setBucketProperty(builder.build());
    }

    @Override
    public void setBucketStorageType(String volumeName, String bucketName, StorageType storageType) throws IOException {
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyBucketName(bucketName);
        Preconditions.checkNotNull((Object)storageType);
        OmBucketArgs.Builder builder = OmBucketArgs.newBuilder();
        builder.setVolumeName(volumeName).setBucketName(bucketName).setStorageType(storageType);
        this.ozoneManagerClient.setBucketProperty(builder.build());
    }

    @Override
    public void setBucketQuota(String volumeName, String bucketName, long quotaInNamespace, long quotaInBytes) throws IOException {
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyBucketName(bucketName);
        RpcClient.verifyCountsQuota(quotaInNamespace);
        RpcClient.verifySpaceQuota(quotaInBytes);
        OmBucketArgs.Builder builder = OmBucketArgs.newBuilder();
        builder.setVolumeName(volumeName).setBucketName(bucketName).setQuotaInBytes(quotaInBytes).setQuotaInNamespace(quotaInNamespace);
        OmBucketInfo omBucketInfo = this.ozoneManagerClient.getBucketInfo(volumeName, bucketName);
        if (omBucketInfo.getQuotaInNamespace() == -2L || omBucketInfo.getUsedBytes() == -2L) {
            LOG.warn("Bucket {} is created before version 1.1.0, usedBytes or usedNamespace may be inaccurate and it is not recommended to enable quota.", (Object)bucketName);
        }
        this.ozoneManagerClient.setBucketProperty(builder.build());
    }

    @Override
    @Deprecated
    public void setEncryptionKey(String volumeName, String bucketName, String bekName) throws IOException {
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyBucketName(bucketName);
        OmBucketArgs.Builder builder = OmBucketArgs.newBuilder();
        BucketEncryptionKeyInfo bek = new BucketEncryptionKeyInfo.Builder().setKeyName(bekName).build();
        builder.setVolumeName(volumeName).setBucketName(bucketName).setBucketEncryptionKey(bek);
        OmBucketArgs finalArgs = builder.build();
        this.ozoneManagerClient.setBucketProperty(finalArgs);
    }

    @Override
    public void setReplicationConfig(String volumeName, String bucketName, ReplicationConfig replicationConfig) throws IOException {
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyBucketName(bucketName);
        Preconditions.checkNotNull((Object)replicationConfig);
        if (this.omVersion.compareTo((Enum)OzoneManagerVersion.ERASURE_CODED_STORAGE_SUPPORT) < 0 && replicationConfig.getReplicationType() == HddsProtos.ReplicationType.EC) {
            throw new IOException("Can not set the default replication of the bucket to Erasure Coded replication, as OzoneManager does not support Erasure Coded replication.");
        }
        OmBucketArgs.Builder builder = OmBucketArgs.newBuilder();
        builder.setVolumeName(volumeName).setBucketName(bucketName).setDefaultReplicationConfig(new DefaultReplicationConfig(replicationConfig));
        this.ozoneManagerClient.setBucketProperty(builder.build());
    }

    @Override
    public void deleteBucket(String volumeName, String bucketName) throws IOException {
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyBucketName(bucketName);
        this.ozoneManagerClient.deleteBucket(volumeName, bucketName);
    }

    @Override
    public void checkBucketAccess(String volumeName, String bucketName) throws IOException {
    }

    @Override
    public OzoneBucket getBucketDetails(String volumeName, String bucketName) throws IOException {
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyBucketName(bucketName);
        OmBucketInfo bucketInfo = this.ozoneManagerClient.getBucketInfo(volumeName, bucketName);
        return OzoneBucket.newBuilder(this.conf, this).setVolumeName(bucketInfo.getVolumeName()).setName(bucketInfo.getBucketName()).setStorageType(bucketInfo.getStorageType()).setVersioning(bucketInfo.getIsVersionEnabled()).setCreationTime(bucketInfo.getCreationTime()).setModificationTime(bucketInfo.getModificationTime()).setMetadata(bucketInfo.getMetadata()).setEncryptionKeyName(bucketInfo.getEncryptionKeyInfo() != null ? bucketInfo.getEncryptionKeyInfo().getKeyName() : null).setSourceVolume(bucketInfo.getSourceVolume()).setSourceBucket(bucketInfo.getSourceBucket()).setUsedBytes(bucketInfo.getTotalBucketSpace()).setUsedNamespace(bucketInfo.getTotalBucketNamespace()).setQuotaInBytes(bucketInfo.getQuotaInBytes()).setQuotaInNamespace(bucketInfo.getQuotaInNamespace()).setBucketLayout(bucketInfo.getBucketLayout()).setOwner(bucketInfo.getOwner()).setDefaultReplicationConfig(bucketInfo.getDefaultReplicationConfig()).build();
    }

    @Override
    public List<OzoneBucket> listBuckets(String volumeName, String bucketPrefix, String prevBucket, int maxListResult, boolean hasSnapshot) throws IOException {
        List buckets = this.ozoneManagerClient.listBuckets(volumeName, prevBucket, bucketPrefix, maxListResult, hasSnapshot);
        return buckets.stream().map(bucket -> OzoneBucket.newBuilder(this.conf, this).setVolumeName(bucket.getVolumeName()).setName(bucket.getBucketName()).setStorageType(bucket.getStorageType()).setVersioning(bucket.getIsVersionEnabled()).setCreationTime(bucket.getCreationTime()).setModificationTime(bucket.getModificationTime()).setMetadata(bucket.getMetadata()).setEncryptionKeyName(bucket.getEncryptionKeyInfo() != null ? bucket.getEncryptionKeyInfo().getKeyName() : null).setSourceVolume(bucket.getSourceVolume()).setSourceBucket(bucket.getSourceBucket()).setUsedBytes(bucket.getTotalBucketSpace()).setUsedNamespace(bucket.getTotalBucketNamespace()).setQuotaInBytes(bucket.getQuotaInBytes()).setQuotaInNamespace(bucket.getQuotaInNamespace()).setBucketLayout(bucket.getBucketLayout()).setOwner(bucket.getOwner()).setDefaultReplicationConfig(bucket.getDefaultReplicationConfig()).build()).collect(Collectors.toList());
    }

    @Override
    @Deprecated
    public OzoneOutputStream createKey(String volumeName, String bucketName, String keyName, long size, ReplicationType type, ReplicationFactor factor, Map<String, String> metadata) throws IOException {
        return this.createKey(volumeName, bucketName, keyName, size, ReplicationConfig.fromTypeAndFactor((ReplicationType)type, (ReplicationFactor)factor), metadata);
    }

    @Override
    public OzoneOutputStream createKey(String volumeName, String bucketName, String keyName, long size, ReplicationConfig replicationConfig, Map<String, String> metadata) throws IOException {
        return this.createKey(volumeName, bucketName, keyName, size, replicationConfig, metadata, Collections.emptyMap());
    }

    @Override
    public OzoneOutputStream createKey(String volumeName, String bucketName, String keyName, long size, ReplicationConfig replicationConfig, Map<String, String> metadata, Map<String, String> tags) throws IOException {
        this.createKeyPreChecks(volumeName, bucketName, keyName, replicationConfig);
        if (this.omVersion.compareTo((Enum)OzoneManagerVersion.OBJECT_TAG) < 0 && tags != null && !tags.isEmpty()) {
            throw new IOException("OzoneManager does not support object tags");
        }
        String ownerName = this.getRealUserInfo().getShortUserName();
        OmKeyArgs.Builder builder = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setDataSize(size).setReplicationConfig(replicationConfig).addAllMetadataGdpr(metadata).addAllTags(tags).setLatestVersionLocation(this.getLatestVersionLocation).setOwnerName(ownerName);
        OpenKeySession openKey = this.ozoneManagerClient.openKey(builder.build());
        if (this.isS3GRequest.get() && size == 0L) {
            openKey.getKeyInfo().setDataSize(size);
        }
        return this.createOutputStream(openKey);
    }

    @Override
    public OzoneOutputStream rewriteKey(String volumeName, String bucketName, String keyName, long size, long existingKeyGeneration, ReplicationConfig replicationConfig, Map<String, String> metadata) throws IOException {
        if (this.omVersion.compareTo((Enum)OzoneManagerVersion.ATOMIC_REWRITE_KEY) < 0) {
            throw new IOException("OzoneManager does not support atomic key rewrite.");
        }
        this.createKeyPreChecks(volumeName, bucketName, keyName, replicationConfig);
        OmKeyArgs.Builder builder = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setDataSize(size).setReplicationConfig(replicationConfig).addAllMetadataGdpr(metadata).setLatestVersionLocation(this.getLatestVersionLocation).setExpectedDataGeneration(existingKeyGeneration);
        OpenKeySession openKey = this.ozoneManagerClient.openKey(builder.build());
        if (this.isS3GRequest.get() && size == 0L) {
            openKey.getKeyInfo().setDataSize(0L);
        }
        return this.createOutputStream(openKey);
    }

    private void createKeyPreChecks(String volumeName, String bucketName, String keyName, ReplicationConfig replicationConfig) throws IOException {
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyBucketName(bucketName);
        if (this.checkKeyNameEnabled) {
            HddsClientUtils.verifyKeyName((String)keyName);
        }
        HddsClientUtils.checkNotNull((Object[])new String[]{keyName});
        if (this.omVersion.compareTo((Enum)OzoneManagerVersion.ERASURE_CODED_STORAGE_SUPPORT) < 0 && replicationConfig != null && replicationConfig.getReplicationType() == HddsProtos.ReplicationType.EC) {
            throw new IOException("Can not set the replication of the key to Erasure Coded replication, as OzoneManager does not support Erasure Coded replication.");
        }
        if (replicationConfig != null) {
            this.replicationConfigValidator.validate(replicationConfig);
        }
    }

    @Override
    public OzoneDataStreamOutput createStreamKey(String volumeName, String bucketName, String keyName, long size, ReplicationConfig replicationConfig, Map<String, String> metadata) throws IOException {
        return this.createStreamKey(volumeName, bucketName, keyName, size, replicationConfig, metadata, Collections.emptyMap());
    }

    @Override
    public OzoneDataStreamOutput createStreamKey(String volumeName, String bucketName, String keyName, long size, ReplicationConfig replicationConfig, Map<String, String> metadata, Map<String, String> tags) throws IOException {
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyBucketName(bucketName);
        if (this.checkKeyNameEnabled) {
            HddsClientUtils.verifyKeyName((String)keyName);
        }
        HddsClientUtils.checkNotNull((Object[])new String[]{keyName});
        if (this.omVersion.compareTo((Enum)OzoneManagerVersion.OBJECT_TAG) < 0 && tags != null && !tags.isEmpty()) {
            throw new IOException("OzoneManager does not support object tags");
        }
        String ownerName = this.getRealUserInfo().getShortUserName();
        OmKeyArgs.Builder builder = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setDataSize(size).setReplicationConfig(replicationConfig).addAllMetadataGdpr(metadata).addAllTags(tags).setSortDatanodesInPipeline(true).setOwnerName(ownerName);
        OpenKeySession openKey = this.ozoneManagerClient.openKey(builder.build());
        return this.createDataStreamOutput(openKey);
    }

    private KeyProvider.KeyVersion getDEK(FileEncryptionInfo feInfo) throws IOException {
        OzoneKMSUtil.checkCryptoProtocolVersion(feInfo);
        KeyProvider.KeyVersion decrypted = null;
        try {
            UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
            if (this.getThreadLocalS3Auth() != null) {
                String userPrincipal = this.getThreadLocalS3Auth().getUserPrincipal();
                Preconditions.checkNotNull((Object)userPrincipal);
                UserGroupInformation s3gUGI = UserGroupInformation.createRemoteUser((String)userPrincipal);
                UserGroupInformation proxyUser = UserGroupInformation.createProxyUser((String)s3gUGI.getShortUserName(), (UserGroupInformation)loginUser);
                decrypted = (KeyProvider.KeyVersion)proxyUser.doAs(() -> OzoneKMSUtil.decryptEncryptedDataEncryptionKey(feInfo, this.getKeyProvider()));
            } else {
                decrypted = OzoneKMSUtil.decryptEncryptedDataEncryptionKey(feInfo, this.getKeyProvider());
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted during decrypt key", ex);
        }
        return decrypted;
    }

    @Override
    public OzoneInputStream getKey(String volumeName, String bucketName, String keyName) throws IOException {
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyBucketName(bucketName);
        Preconditions.checkNotNull((Object)keyName);
        OmKeyInfo keyInfo = this.getKeyInfo(volumeName, bucketName, keyName, false);
        return this.getInputStreamWithRetryFunction(keyInfo);
    }

    @Override
    public Map<OmKeyLocationInfo, Map<DatanodeDetails, OzoneInputStream>> getKeysEveryReplicas(String volumeName, String bucketName, String keyName) throws IOException {
        LinkedHashMap<OmKeyLocationInfo, Map<DatanodeDetails, OzoneInputStream>> result = new LinkedHashMap<OmKeyLocationInfo, Map<DatanodeDetails, OzoneInputStream>>();
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyBucketName(bucketName);
        OmKeyInfo keyInfo = this.getKeyInfo(volumeName, bucketName, keyName, true);
        List keyLocationInfos = keyInfo.getLatestVersionLocations().getBlocksLatestVersionOnly();
        ReplicationConfig replicationConfig = keyInfo.getReplicationConfig();
        for (OmKeyLocationInfo locationInfo : keyLocationInfos) {
            HashMap<DatanodeDetails, OzoneInputStream> blocks = new HashMap<DatanodeDetails, OzoneInputStream>();
            Pipeline pipelineBefore = locationInfo.getPipeline();
            List datanodes = pipelineBefore.getNodes();
            for (DatanodeDetails dn : datanodes) {
                Pipeline pipeline = pipelineBefore.copyForReadFromNode(dn);
                long length = replicationConfig instanceof ECReplicationConfig ? ECBlockInputStream.internalBlockLength((int)pipelineBefore.getReplicaIndex(dn), (ECReplicationConfig)((ECReplicationConfig)replicationConfig), (long)locationInfo.getLength()) : locationInfo.getLength();
                OmKeyLocationInfo dnKeyLocation = new OmKeyLocationInfo.Builder().setBlockID(locationInfo.getBlockID()).setLength(length).setOffset(locationInfo.getOffset()).setToken(locationInfo.getToken()).setPartNumber(locationInfo.getPartNumber()).setCreateVersion(locationInfo.getCreateVersion()).setPipeline(pipeline).build();
                List<OmKeyLocationInfo> keyLocationInfoList = Collections.singletonList(dnKeyLocation);
                OmKeyLocationInfoGroup keyLocationInfoGroup = new OmKeyLocationInfoGroup(0L, keyLocationInfoList);
                List<OmKeyLocationInfoGroup> keyLocationInfoGroups = Collections.singletonList(keyLocationInfoGroup);
                keyInfo.setKeyLocationVersions(keyLocationInfoGroups);
                OmKeyInfo dnKeyInfo = new OmKeyInfo.Builder().setVolumeName(keyInfo.getVolumeName()).setBucketName(keyInfo.getBucketName()).setKeyName(keyInfo.getKeyName()).setOmKeyLocationInfos(keyInfo.getKeyLocationVersions()).setDataSize(keyInfo.getDataSize()).setCreationTime(keyInfo.getCreationTime()).setModificationTime(keyInfo.getModificationTime()).setReplicationConfig((ReplicationConfig)(replicationConfig instanceof ECReplicationConfig ? RatisReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.ONE) : keyInfo.getReplicationConfig())).setFileEncryptionInfo(keyInfo.getFileEncryptionInfo()).setAcls(keyInfo.getAcls()).setObjectID(keyInfo.getObjectID()).setUpdateID(keyInfo.getUpdateID()).setParentObjectID(keyInfo.getParentObjectID()).setFileChecksum(keyInfo.getFileChecksum()).setOwnerName(keyInfo.getOwnerName()).build();
                dnKeyInfo.setMetadata(keyInfo.getMetadata());
                dnKeyInfo.setKeyLocationVersions(keyLocationInfoGroups);
                blocks.put(dn, this.createInputStream(dnKeyInfo, Function.identity()));
            }
            result.put(locationInfo, blocks);
        }
        return result;
    }

    @Override
    public void deleteKey(String volumeName, String bucketName, String keyName, boolean recursive) throws IOException {
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyBucketName(bucketName);
        Preconditions.checkNotNull((Object)keyName);
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setRecursive(recursive).build();
        this.ozoneManagerClient.deleteKey(keyArgs);
    }

    @Override
    public void deleteKeys(String volumeName, String bucketName, List<String> keyNameList) throws IOException {
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyBucketName(bucketName);
        Preconditions.checkNotNull(keyNameList);
        OmDeleteKeys omDeleteKeys = new OmDeleteKeys(volumeName, bucketName, keyNameList);
        this.ozoneManagerClient.deleteKeys(omDeleteKeys);
    }

    @Override
    public Map<String, ErrorInfo> deleteKeys(String volumeName, String bucketName, List<String> keyNameList, boolean quiet) throws IOException {
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyBucketName(bucketName);
        Preconditions.checkNotNull(keyNameList);
        OmDeleteKeys omDeleteKeys = new OmDeleteKeys(volumeName, bucketName, keyNameList);
        return this.ozoneManagerClient.deleteKeys(omDeleteKeys, quiet);
    }

    @Override
    public void renameKey(String volumeName, String bucketName, String fromKeyName, String toKeyName) throws IOException {
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyBucketName(bucketName);
        if (this.checkKeyNameEnabled) {
            HddsClientUtils.verifyKeyName((String)toKeyName);
        }
        HddsClientUtils.checkNotNull((Object[])new String[]{fromKeyName, toKeyName});
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(fromKeyName).build();
        this.ozoneManagerClient.renameKey(keyArgs, toKeyName);
    }

    @Override
    @Deprecated
    public void renameKeys(String volumeName, String bucketName, Map<String, String> keyMap) throws IOException {
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyBucketName(bucketName);
        HddsClientUtils.checkNotNull((Object[])new Map[]{keyMap});
        OmRenameKeys omRenameKeys = new OmRenameKeys(volumeName, bucketName, keyMap, null);
        this.ozoneManagerClient.renameKeys(omRenameKeys);
    }

    @Override
    public List<OzoneKey> listKeys(String volumeName, String bucketName, String keyPrefix, String prevKey, int maxListResult) throws IOException {
        if (this.omVersion.compareTo((Enum)OzoneManagerVersion.LIGHTWEIGHT_LIST_KEYS) >= 0) {
            List keys = this.ozoneManagerClient.listKeysLight(volumeName, bucketName, prevKey, keyPrefix, maxListResult).getKeys();
            return keys.stream().map(key -> new OzoneKey(key.getVolumeName(), key.getBucketName(), key.getKeyName(), key.getDataSize(), key.getCreationTime(), key.getModificationTime(), key.getReplicationConfig(), Collections.singletonMap("ETag", key.getETag()), key.isFile(), key.getOwnerName(), Collections.emptyMap())).collect(Collectors.toList());
        }
        List keys = this.ozoneManagerClient.listKeys(volumeName, bucketName, prevKey, keyPrefix, maxListResult).getKeys();
        return keys.stream().map(key -> new OzoneKey(key.getVolumeName(), key.getBucketName(), key.getKeyName(), key.getDataSize(), key.getCreationTime(), key.getModificationTime(), key.getReplicationConfig(), key.getMetadata(), key.isFile(), key.getOwnerName(), key.getTags())).collect(Collectors.toList());
    }

    @Override
    public OzoneKeyDetails getKeyDetails(String volumeName, String bucketName, String keyName) throws IOException {
        OmKeyInfo keyInfo = this.getKeyInfo(volumeName, bucketName, keyName, false);
        return this.getOzoneKeyDetails(keyInfo);
    }

    @Nonnull
    private OzoneKeyDetails getOzoneKeyDetails(OmKeyInfo keyInfo) {
        ArrayList<OzoneKeyLocation> ozoneKeyLocations = new ArrayList<OzoneKeyLocation>();
        long lastKeyOffset = 0L;
        List omKeyLocationInfos = keyInfo.getLatestVersionLocations().getBlocksLatestVersionOnly();
        for (OmKeyLocationInfo info : omKeyLocationInfos) {
            ozoneKeyLocations.add(new OzoneKeyLocation(info.getContainerID(), info.getLocalID(), info.getLength(), info.getOffset(), lastKeyOffset));
            lastKeyOffset += info.getLength();
        }
        return new OzoneKeyDetails(keyInfo.getVolumeName(), keyInfo.getBucketName(), keyInfo.getKeyName(), keyInfo.getDataSize(), keyInfo.getCreationTime(), keyInfo.getModificationTime(), ozoneKeyLocations, keyInfo.getReplicationConfig(), keyInfo.getMetadata(), keyInfo.getFileEncryptionInfo(), (CheckedSupplier<OzoneInputStream, IOException>)((CheckedSupplier)() -> this.getInputStreamWithRetryFunction(keyInfo)), keyInfo.isFile(), keyInfo.getOwnerName(), keyInfo.getTags(), keyInfo.getGeneration());
    }

    @Override
    public OzoneKeyDetails getS3KeyDetails(String bucketName, String keyName) throws IOException {
        OmKeyInfo keyInfo = this.getS3KeyInfo(bucketName, keyName, false);
        return this.getOzoneKeyDetails(keyInfo);
    }

    @Override
    public OzoneKeyDetails getS3KeyDetails(String bucketName, String keyName, int partNumber) throws IOException {
        OmKeyInfo keyInfo;
        if (this.omVersion.compareTo((Enum)OzoneManagerVersion.S3_PART_AWARE_GET) >= 0) {
            keyInfo = this.getS3PartKeyInfo(bucketName, keyName, partNumber);
        } else {
            keyInfo = this.getS3KeyInfo(bucketName, keyName, false);
            List filteredKeyLocationInfo = keyInfo.getLatestVersionLocations().getBlocksLatestVersionOnly().stream().filter(omKeyLocationInfo -> omKeyLocationInfo.getPartNumber() == partNumber).collect(Collectors.toList());
            keyInfo.updateLocationInfoList(filteredKeyLocationInfo, true, true);
            keyInfo.setDataSize(filteredKeyLocationInfo.stream().mapToLong(BlockLocationInfo::getLength).sum());
        }
        return this.getOzoneKeyDetails(keyInfo);
    }

    @Nonnull
    private OmKeyInfo getS3KeyInfo(String bucketName, String keyName, boolean isHeadOp) throws IOException {
        RpcClient.verifyBucketName(bucketName);
        Preconditions.checkNotNull((Object)keyName);
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName("s3v").setBucketName(bucketName).setKeyName(keyName).setSortDatanodesInPipeline(this.topologyAwareReadEnabled).setLatestVersionLocation(this.getLatestVersionLocation).setForceUpdateContainerCacheFromSCM(false).setHeadOp(isHeadOp).build();
        KeyInfoWithVolumeContext keyInfoWithS3Context = this.ozoneManagerClient.getKeyInfo(keyArgs, true);
        keyInfoWithS3Context.getUserPrincipal().ifPresent(this::updateS3Principal);
        return keyInfoWithS3Context.getKeyInfo();
    }

    @Nonnull
    private OmKeyInfo getS3PartKeyInfo(String bucketName, String keyName, int partNumber) throws IOException {
        RpcClient.verifyBucketName(bucketName);
        Preconditions.checkNotNull((Object)keyName);
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName("s3v").setBucketName(bucketName).setKeyName(keyName).setSortDatanodesInPipeline(this.topologyAwareReadEnabled).setLatestVersionLocation(this.getLatestVersionLocation).setForceUpdateContainerCacheFromSCM(false).setMultipartUploadPartNumber(partNumber).build();
        KeyInfoWithVolumeContext keyInfoWithS3Context = this.ozoneManagerClient.getKeyInfo(keyArgs, true);
        keyInfoWithS3Context.getUserPrincipal().ifPresent(this::updateS3Principal);
        return keyInfoWithS3Context.getKeyInfo();
    }

    @Override
    public OmKeyInfo getKeyInfo(String volumeName, String bucketName, String keyName, boolean forceUpdateContainerCache) throws IOException {
        Preconditions.checkNotNull((Object)volumeName);
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)keyName);
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setSortDatanodesInPipeline(this.topologyAwareReadEnabled).setLatestVersionLocation(this.getLatestVersionLocation).setForceUpdateContainerCacheFromSCM(forceUpdateContainerCache).build();
        return this.getKeyInfo(keyArgs);
    }

    private OmKeyInfo getKeyInfo(OmKeyArgs keyArgs) throws IOException {
        OmKeyInfo keyInfo = this.omVersion.compareTo((Enum)OzoneManagerVersion.OPTIMIZED_GET_KEY_INFO) >= 0 ? this.ozoneManagerClient.getKeyInfo(keyArgs, false).getKeyInfo() : this.ozoneManagerClient.lookupKey(keyArgs);
        return keyInfo;
    }

    @Override
    public void close() throws IOException {
        if (this.ecReconstructExecutor.isInitialized()) {
            ((ExecutorService)this.ecReconstructExecutor.get()).shutdownNow();
        }
        if (this.writeExecutor.isInitialized()) {
            ((ExecutorService)this.writeExecutor.get()).shutdownNow();
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (AutoCloseable[])new AutoCloseable[]{this.ozoneManagerClient, this.xceiverClientManager});
        this.keyProviderCache.invalidateAll();
        this.keyProviderCache.cleanUp();
        ContainerClientMetrics.release();
    }

    @Override
    @Deprecated
    public OmMultipartInfo initiateMultipartUpload(String volumeName, String bucketName, String keyName, ReplicationType type, ReplicationFactor factor) throws IOException {
        return this.initiateMultipartUpload(volumeName, bucketName, keyName, ReplicationConfig.fromTypeAndFactor((ReplicationType)type, (ReplicationFactor)factor));
    }

    @Override
    public OmMultipartInfo initiateMultipartUpload(String volumeName, String bucketName, String keyName, ReplicationConfig replicationConfig) throws IOException {
        return this.initiateMultipartUpload(volumeName, bucketName, keyName, replicationConfig, Collections.emptyMap());
    }

    @Override
    public OmMultipartInfo initiateMultipartUpload(String volumeName, String bucketName, String keyName, ReplicationConfig replicationConfig, Map<String, String> metadata) throws IOException {
        return this.initiateMultipartUpload(volumeName, bucketName, keyName, replicationConfig, metadata, Collections.emptyMap());
    }

    @Override
    public OmMultipartInfo initiateMultipartUpload(String volumeName, String bucketName, String keyName, ReplicationConfig replicationConfig, Map<String, String> metadata, Map<String, String> tags) throws IOException {
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyBucketName(bucketName);
        HddsClientUtils.checkNotNull((Object[])new String[]{keyName});
        String ownerName = this.getRealUserInfo().getShortUserName();
        if (this.omVersion.compareTo((Enum)OzoneManagerVersion.ERASURE_CODED_STORAGE_SUPPORT) < 0 && replicationConfig != null && replicationConfig.getReplicationType() == HddsProtos.ReplicationType.EC) {
            throw new IOException("Can not set the replication of the file to Erasure Coded replication, as OzoneManager does not support Erasure Coded replication.");
        }
        if (this.omVersion.compareTo((Enum)OzoneManagerVersion.OBJECT_TAG) < 0 && tags != null && !tags.isEmpty()) {
            throw new IOException("OzoneManager does not support object tags");
        }
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setReplicationConfig(replicationConfig).addAllMetadataGdpr(metadata).setOwnerName(ownerName).addAllTags(tags).build();
        OmMultipartInfo multipartInfo = this.ozoneManagerClient.initiateMultipartUpload(keyArgs);
        return multipartInfo;
    }

    private OpenKeySession newMultipartOpenKey(String volumeName, String bucketName, String keyName, long size, int partNumber, String uploadID, boolean sortDatanodesInPipeline) throws IOException {
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyBucketName(bucketName);
        if (this.checkKeyNameEnabled) {
            HddsClientUtils.verifyKeyName((String)keyName);
        }
        HddsClientUtils.checkNotNull((Object[])new String[]{keyName, uploadID});
        if (partNumber <= 0 || partNumber > 10000) {
            throw new OMException("Part number must be an integer between 1 and 10000, inclusive", OMException.ResultCodes.INVALID_PART);
        }
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"size should be greater than or equal to zero");
        String ownerName = this.getRealUserInfo().getShortUserName();
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setDataSize(size).setIsMultipartKey(true).setMultipartUploadID(uploadID).setMultipartUploadPartNumber(partNumber).setSortDatanodesInPipeline(sortDatanodesInPipeline).setOwnerName(ownerName).build();
        return this.ozoneManagerClient.openKey(keyArgs);
    }

    @Override
    public OzoneOutputStream createMultipartKey(String volumeName, String bucketName, String keyName, long size, int partNumber, String uploadID) throws IOException {
        OpenKeySession openKey = this.newMultipartOpenKey(volumeName, bucketName, keyName, size, partNumber, uploadID, false);
        return this.createMultipartOutputStream(openKey, uploadID, partNumber);
    }

    private OzoneOutputStream createMultipartOutputStream(OpenKeySession openKey, String uploadID, int partNumber) throws IOException {
        KeyOutputStream keyOutputStream = this.createKeyOutputStream(openKey).setMultipartNumber(partNumber).setMultipartUploadID(uploadID).setIsMultipartKey(true).build();
        return this.createOutputStream(openKey, keyOutputStream);
    }

    @Override
    public OzoneDataStreamOutput createMultipartStreamKey(String volumeName, String bucketName, String keyName, long size, int partNumber, String uploadID) throws IOException {
        OzoneOutputStream out;
        OpenKeySession openKey = this.newMultipartOpenKey(volumeName, bucketName, keyName, size, partNumber, uploadID, true);
        ReplicationConfig replicationConfig = openKey.getKeyInfo().getReplicationConfig();
        if (replicationConfig.getReplicationType() == HddsProtos.ReplicationType.RATIS) {
            KeyDataStreamOutput keyOutputStream = this.newKeyOutputStreamBuilder().setHandler(openKey).setReplicationConfig(replicationConfig).setMultipartNumber(partNumber).setMultipartUploadID(uploadID).setIsMultipartKey(true).build();
            keyOutputStream.addPreallocateBlocks(openKey.getKeyInfo().getLatestVersionLocations(), openKey.getOpenVersion());
            OzoneOutputStream secureOut = this.createSecureOutputStream(openKey, (OutputStream)((Object)keyOutputStream), null);
            out = secureOut != null ? secureOut : keyOutputStream;
        } else {
            out = this.createMultipartOutputStream(openKey, uploadID, partNumber);
        }
        return new OzoneDataStreamOutput((ByteBufferStreamOutput)out, (Syncable)out);
    }

    @Override
    public OmMultipartUploadCompleteInfo completeMultipartUpload(String volumeName, String bucketName, String keyName, String uploadID, Map<Integer, String> partsMap) throws IOException {
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyBucketName(bucketName);
        HddsClientUtils.checkNotNull((Object[])new String[]{keyName, uploadID});
        String ownerName = this.getRealUserInfo().getShortUserName();
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setMultipartUploadID(uploadID).setOwnerName(ownerName).build();
        OmMultipartUploadCompleteList omMultipartUploadCompleteList = new OmMultipartUploadCompleteList(partsMap);
        OmMultipartUploadCompleteInfo omMultipartUploadCompleteInfo = this.ozoneManagerClient.completeMultipartUpload(keyArgs, omMultipartUploadCompleteList);
        return omMultipartUploadCompleteInfo;
    }

    @Override
    public void abortMultipartUpload(String volumeName, String bucketName, String keyName, String uploadID) throws IOException {
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyBucketName(bucketName);
        HddsClientUtils.checkNotNull((Object[])new String[]{keyName, uploadID});
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setMultipartUploadID(uploadID).build();
        this.ozoneManagerClient.abortMultipartUpload(omKeyArgs);
    }

    @Override
    public OzoneMultipartUploadPartListParts listParts(String volumeName, String bucketName, String keyName, String uploadID, int partNumberMarker, int maxParts) throws IOException {
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyBucketName(bucketName);
        HddsClientUtils.checkNotNull((Object[])new String[]{uploadID});
        Preconditions.checkArgument((maxParts > 0 ? 1 : 0) != 0, (Object)"Max Parts Should be greater than zero");
        Preconditions.checkArgument((partNumberMarker >= 0 ? 1 : 0) != 0, (Object)"Part Number Marker Should be greater than or equal to zero, as part numbers starts from 1 and ranges till 10000");
        OmMultipartUploadListParts omMultipartUploadListParts = this.ozoneManagerClient.listParts(volumeName, bucketName, keyName, uploadID, partNumberMarker, maxParts);
        OzoneMultipartUploadPartListParts ozoneMultipartUploadPartListParts = new OzoneMultipartUploadPartListParts(omMultipartUploadListParts.getReplicationConfig(), omMultipartUploadListParts.getNextPartNumberMarker(), omMultipartUploadListParts.isTruncated());
        for (OmPartInfo omPartInfo : omMultipartUploadListParts.getPartInfoList()) {
            ozoneMultipartUploadPartListParts.addPart(new OzoneMultipartUploadPartListParts.PartInfo(omPartInfo.getPartNumber(), omPartInfo.getPartName(), omPartInfo.getModificationTime(), omPartInfo.getSize(), omPartInfo.getETag()));
        }
        return ozoneMultipartUploadPartListParts;
    }

    @Override
    public OzoneMultipartUploadList listMultipartUploads(String volumeName, String bucketName, String prefix, String keyMarker, String uploadIdMarker, int maxUploads) throws IOException {
        OmMultipartUploadList omMultipartUploadList = this.omVersion.compareTo((Enum)OzoneManagerVersion.S3_LIST_MULTIPART_UPLOADS_PAGINATION) >= 0 ? this.ozoneManagerClient.listMultipartUploads(volumeName, bucketName, prefix, keyMarker, uploadIdMarker, maxUploads, true) : this.ozoneManagerClient.listMultipartUploads(volumeName, bucketName, prefix, keyMarker, uploadIdMarker, maxUploads, false);
        List<OzoneMultipartUpload> uploads = omMultipartUploadList.getUploads().stream().map(upload -> new OzoneMultipartUpload(upload.getVolumeName(), upload.getBucketName(), upload.getKeyName(), upload.getUploadId(), upload.getCreationTime(), upload.getReplicationConfig())).collect(Collectors.toList());
        OzoneMultipartUploadList result = new OzoneMultipartUploadList(uploads, omMultipartUploadList.getNextKeyMarker(), omMultipartUploadList.getNextUploadIdMarker(), omMultipartUploadList.isTruncated());
        return result;
    }

    @Override
    public OzoneFileStatus getOzoneFileStatus(String volumeName, String bucketName, String keyName) throws IOException {
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setSortDatanodesInPipeline(this.topologyAwareReadEnabled).setLatestVersionLocation(this.getLatestVersionLocation).build();
        return this.ozoneManagerClient.getFileStatus(keyArgs);
    }

    @Override
    public void createDirectory(String volumeName, String bucketName, String keyName) throws IOException {
        String ownerName = this.getRealUserInfo().getShortUserName();
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setOwnerName(ownerName).build();
        this.ozoneManagerClient.createDirectory(keyArgs);
    }

    @Override
    public OzoneInputStream readFile(String volumeName, String bucketName, String keyName) throws IOException {
        OmKeyInfo keyInfo;
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setSortDatanodesInPipeline(this.topologyAwareReadEnabled).setLatestVersionLocation(this.getLatestVersionLocation).build();
        if (this.omVersion.compareTo((Enum)OzoneManagerVersion.OPTIMIZED_GET_KEY_INFO) >= 0) {
            keyInfo = this.ozoneManagerClient.getKeyInfo(keyArgs, false).getKeyInfo();
            if (!keyInfo.isFile()) {
                throw new OMException(keyName + " is not a file.", OMException.ResultCodes.NOT_A_FILE);
            }
        } else {
            keyInfo = this.ozoneManagerClient.lookupFile(keyArgs);
        }
        return this.getInputStreamWithRetryFunction(keyInfo);
    }

    @Override
    @Deprecated
    public OzoneOutputStream createFile(String volumeName, String bucketName, String keyName, long size, ReplicationType type, ReplicationFactor factor, boolean overWrite, boolean recursive) throws IOException {
        return this.createFile(volumeName, bucketName, keyName, size, ReplicationConfig.fromTypeAndFactor((ReplicationType)type, (ReplicationFactor)factor), overWrite, recursive);
    }

    private OzoneInputStream getInputStreamWithRetryFunction(OmKeyInfo keyInfo) throws IOException {
        return this.createInputStream(keyInfo, omKeyInfo -> {
            try {
                return this.getKeyInfo(omKeyInfo.getVolumeName(), omKeyInfo.getBucketName(), omKeyInfo.getKeyName(), true);
            }
            catch (IOException e) {
                LOG.error("Unable to lookup key {} on retry.", (Object)keyInfo.getKeyName(), (Object)e);
                return null;
            }
        });
    }

    @Override
    public OzoneOutputStream createFile(String volumeName, String bucketName, String keyName, long size, ReplicationConfig replicationConfig, boolean overWrite, boolean recursive) throws IOException {
        if (this.omVersion.compareTo((Enum)OzoneManagerVersion.ERASURE_CODED_STORAGE_SUPPORT) < 0 && replicationConfig.getReplicationType() == HddsProtos.ReplicationType.EC) {
            throw new IOException("Can not set the replication of the file to Erasure Coded replication, as OzoneManager does not support Erasure Coded replication.");
        }
        String ownerName = this.getRealUserInfo().getShortUserName();
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setDataSize(size).setReplicationConfig(replicationConfig).setLatestVersionLocation(this.getLatestVersionLocation).setOwnerName(ownerName).build();
        OpenKeySession keySession = this.ozoneManagerClient.createFile(keyArgs, overWrite, recursive);
        return this.createOutputStream(keySession);
    }

    private OmKeyArgs prepareOmKeyArgs(String volumeName, String bucketName, String keyName) {
        return new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setSortDatanodesInPipeline(this.topologyAwareReadEnabled).setLatestVersionLocation(this.getLatestVersionLocation).build();
    }

    @Override
    public OzoneDataStreamOutput createStreamFile(String volumeName, String bucketName, String keyName, long size, ReplicationConfig replicationConfig, boolean overWrite, boolean recursive) throws IOException {
        String ownerName = this.getRealUserInfo().getShortUserName();
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setDataSize(size).setReplicationConfig(replicationConfig).setLatestVersionLocation(this.getLatestVersionLocation).setSortDatanodesInPipeline(true).setOwnerName(ownerName).build();
        OpenKeySession keySession = this.ozoneManagerClient.createFile(keyArgs, overWrite, recursive);
        return this.createDataStreamOutput(keySession);
    }

    @Override
    public List<OzoneFileStatus> listStatus(String volumeName, String bucketName, String keyName, boolean recursive, String startKey, long numEntries) throws IOException {
        OmKeyArgs keyArgs = this.prepareOmKeyArgs(volumeName, bucketName, keyName);
        return this.ozoneManagerClient.listStatus(keyArgs, recursive, startKey, numEntries);
    }

    @Override
    public List<OzoneFileStatus> listStatus(String volumeName, String bucketName, String keyName, boolean recursive, String startKey, long numEntries, boolean allowPartialPrefixes) throws IOException {
        OmKeyArgs keyArgs = this.prepareOmKeyArgs(volumeName, bucketName, keyName);
        return this.ozoneManagerClient.listStatus(keyArgs, recursive, startKey, numEntries, allowPartialPrefixes);
    }

    @Override
    public List<OzoneFileStatusLight> listStatusLight(String volumeName, String bucketName, String keyName, boolean recursive, String startKey, long numEntries, boolean allowPartialPrefixes) throws IOException {
        OmKeyArgs keyArgs = this.prepareOmKeyArgs(volumeName, bucketName, keyName);
        if (this.omVersion.compareTo((Enum)OzoneManagerVersion.LIGHTWEIGHT_LIST_STATUS) >= 0) {
            return this.ozoneManagerClient.listStatusLight(keyArgs, recursive, startKey, numEntries, allowPartialPrefixes);
        }
        return this.ozoneManagerClient.listStatus(keyArgs, recursive, startKey, numEntries, allowPartialPrefixes).stream().map(OzoneFileStatusLight::fromOzoneFileStatus).collect(Collectors.toList());
    }

    @Override
    public boolean addAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        return this.ozoneManagerClient.addAcl(obj, acl);
    }

    @Override
    public boolean removeAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        return this.ozoneManagerClient.removeAcl(obj, acl);
    }

    @Override
    public boolean setAcl(OzoneObj obj, List<OzoneAcl> acls) throws IOException {
        return this.ozoneManagerClient.setAcl(obj, acls);
    }

    @Override
    public List<OzoneAcl> getAcl(OzoneObj obj) throws IOException {
        return this.ozoneManagerClient.getAcl(obj);
    }

    static GDPRSymmetricKey getGDPRSymmetricKey(Map<String, String> metadata, int mode) throws Exception {
        if (!Boolean.parseBoolean(metadata.get("gdprEnabled"))) {
            return null;
        }
        GDPRSymmetricKey gk = new GDPRSymmetricKey(metadata.get("secret"), metadata.get("algorithm"));
        try {
            gk.getCipher().init(mode, gk.getSecretKey());
        }
        catch (InvalidKeyException e) {
            if (e.getMessage().contains("Illegal key size or default parameters")) {
                LOG.error("Missing Unlimited Strength Policy jars. Please install Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files");
            }
            throw e;
        }
        return gk;
    }

    private OzoneInputStream createInputStream(OmKeyInfo keyInfo, Function<OmKeyInfo, OmKeyInfo> retryFunction) throws IOException {
        FileEncryptionInfo feInfo = keyInfo.getFileEncryptionInfo();
        if (feInfo == null) {
            LengthInputStream lengthInputStream = KeyInputStream.getFromOmKeyInfo(keyInfo, this.xceiverClientManager, retryFunction, this.blockInputStreamFactory, this.clientConfig);
            try {
                GDPRSymmetricKey gk = RpcClient.getGDPRSymmetricKey(keyInfo.getMetadata(), 2);
                if (gk != null) {
                    return new OzoneInputStream(new CipherInputStream((InputStream)lengthInputStream, gk.getCipher()));
                }
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
            return new OzoneInputStream(lengthInputStream.getWrappedStream());
        }
        if (!keyInfo.getLatestVersionLocations().isMultipartKey()) {
            LengthInputStream lengthInputStream = KeyInputStream.getFromOmKeyInfo(keyInfo, this.xceiverClientManager, retryFunction, this.blockInputStreamFactory, this.clientConfig);
            KeyProvider.KeyVersion decrypted = this.getDEK(feInfo);
            CryptoInputStream cryptoIn = new CryptoInputStream(lengthInputStream.getWrappedStream(), OzoneKMSUtil.getCryptoCodec(this.conf, feInfo), decrypted.getMaterial(), feInfo.getIV());
            return new OzoneInputStream((InputStream)cryptoIn);
        }
        List<LengthInputStream> lengthInputStreams = KeyInputStream.getStreamsFromKeyInfo(keyInfo, this.xceiverClientManager, retryFunction, this.blockInputStreamFactory, this.clientConfig);
        KeyProvider.KeyVersion decrypted = this.getDEK(feInfo);
        ArrayList<OzoneCryptoInputStream> cryptoInputStreams = new ArrayList<OzoneCryptoInputStream>();
        for (int i = 0; i < lengthInputStreams.size(); ++i) {
            LengthInputStream lengthInputStream = lengthInputStreams.get(i);
            OzoneCryptoInputStream ozoneCryptoInputStream = new OzoneCryptoInputStream(lengthInputStream, OzoneKMSUtil.getCryptoCodec(this.conf, feInfo), decrypted.getMaterial(), feInfo.getIV(), keyInfo.getKeyName(), i);
            cryptoInputStreams.add(ozoneCryptoInputStream);
        }
        return new OzoneInputStream((InputStream)new MultipartInputStream(keyInfo.getKeyName(), cryptoInputStreams));
    }

    private OzoneDataStreamOutput createDataStreamOutput(OpenKeySession openKey) throws IOException {
        OzoneOutputStream out;
        ReplicationConfig replicationConfig = openKey.getKeyInfo().getReplicationConfig();
        if (replicationConfig.getReplicationType() == HddsProtos.ReplicationType.RATIS) {
            KeyDataStreamOutput keyOutputStream = this.newKeyOutputStreamBuilder().setHandler(openKey).setReplicationConfig(replicationConfig).build();
            keyOutputStream.addPreallocateBlocks(openKey.getKeyInfo().getLatestVersionLocations(), openKey.getOpenVersion());
            OzoneOutputStream secureOut = this.createSecureOutputStream(openKey, (OutputStream)((Object)keyOutputStream), null);
            out = secureOut != null ? secureOut : keyOutputStream;
        } else {
            out = this.createOutputStream(openKey);
        }
        return new OzoneDataStreamOutput((ByteBufferStreamOutput)out, (Syncable)out);
    }

    private KeyDataStreamOutput.Builder newKeyOutputStreamBuilder() {
        return new KeyDataStreamOutput.Builder().setXceiverClientManager(this.xceiverClientManager).setOmClient((OzoneManagerProtocol)this.ozoneManagerClient).enableUnsafeByteBufferConversion(this.unsafeByteBufferConversion).setConfig(this.clientConfig).setAtomicKeyCreation(this.isS3GRequest.get());
    }

    private OzoneOutputStream createOutputStream(OpenKeySession openKey) throws IOException {
        KeyOutputStream keyOutputStream = this.createKeyOutputStream(openKey).build();
        return this.createOutputStream(openKey, keyOutputStream);
    }

    private OzoneOutputStream createOutputStream(OpenKeySession openKey, KeyOutputStream keyOutputStream) throws IOException {
        boolean enableHsync = OzoneFSUtils.canEnableHsync((ConfigurationSource)this.conf, (boolean)true);
        keyOutputStream.addPreallocateBlocks(openKey.getKeyInfo().getLatestVersionLocations(), openKey.getOpenVersion());
        OzoneOutputStream out = this.createSecureOutputStream(openKey, keyOutputStream, keyOutputStream);
        return out != null ? out : new OzoneOutputStream(keyOutputStream, enableHsync);
    }

    private OzoneOutputStream createSecureOutputStream(OpenKeySession openKey, OutputStream keyOutputStream, Syncable syncable) throws IOException {
        boolean enableHsync = OzoneFSUtils.canEnableHsync((ConfigurationSource)this.conf, (boolean)true);
        FileEncryptionInfo feInfo = openKey.getKeyInfo().getFileEncryptionInfo();
        if (feInfo != null) {
            KeyProvider.KeyVersion decrypted = this.getDEK(feInfo);
            CryptoOutputStream cryptoOut = new CryptoOutputStream(keyOutputStream, OzoneKMSUtil.getCryptoCodec(this.conf, feInfo), decrypted.getMaterial(), feInfo.getIV());
            return new OzoneOutputStream((Syncable)cryptoOut, enableHsync);
        }
        try {
            GDPRSymmetricKey gk = RpcClient.getGDPRSymmetricKey(openKey.getKeyInfo().getMetadata(), 1);
            if (gk != null) {
                return new OzoneOutputStream(new CipherOutputStreamOzone(keyOutputStream, gk.getCipher()), syncable, enableHsync);
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        return null;
    }

    private KeyOutputStream.Builder createKeyOutputStream(OpenKeySession openKey) {
        ReplicationConfig replicationConfig = openKey.getKeyInfo().getReplicationConfig();
        StreamBufferArgs streamBufferArgs = StreamBufferArgs.getDefaultStreamBufferArgs((ReplicationConfig)replicationConfig, (OzoneClientConfig)this.clientConfig);
        KeyOutputStream.Builder builder = replicationConfig.getReplicationType() == HddsProtos.ReplicationType.EC ? new ECKeyOutputStream.Builder().setReplicationConfig((ECReplicationConfig)replicationConfig).setByteBufferPool(this.byteBufferPool).setS3CredentialsProvider(this.getS3CredentialsProvider()) : new KeyOutputStream.Builder().setReplicationConfig(replicationConfig);
        return builder.setHandler(openKey).setXceiverClientManager(this.xceiverClientManager).setOmClient((OzoneManagerProtocol)this.ozoneManagerClient).enableUnsafeByteBufferConversion(this.unsafeByteBufferConversion).setConfig(this.clientConfig).setAtomicKeyCreation(this.isS3GRequest.get()).setClientMetrics(this.clientMetrics).setExecutorServiceSupplier((Supplier<ExecutorService>)this.writeExecutor).setStreamBufferArgs(streamBufferArgs).setOmVersion(this.omVersion);
    }

    @Override
    public KeyProvider getKeyProvider() throws IOException {
        final URI kmsUri = this.getKeyProviderUri();
        if (kmsUri == null) {
            return null;
        }
        try {
            return (KeyProvider)this.keyProviderCache.get((Object)kmsUri, (Callable)new Callable<KeyProvider>(){

                @Override
                public KeyProvider call() throws Exception {
                    return OzoneKMSUtil.getKeyProvider(RpcClient.this.conf, kmsUri);
                }
            });
        }
        catch (Exception e) {
            LOG.error("Can't create KeyProvider for Ozone RpcClient.", (Throwable)e);
            return null;
        }
    }

    @Override
    public OzoneFsServerDefaults getServerDefaults() throws IOException {
        long now = Time.monotonicNow();
        if (this.serverDefaults == null || now - this.serverDefaultsLastUpdate > this.serverDefaultsValidityPeriod) {
            try {
                for (ServiceInfo si : this.ozoneManagerClient.getServiceInfo().getServiceInfoList()) {
                    if (si.getServerDefaults() == null) continue;
                    this.serverDefaults = si.getServerDefaults();
                    this.serverDefaultsLastUpdate = now;
                    break;
                }
            }
            catch (Exception e) {
                LOG.warn("Could not get server defaults from OM.", (Throwable)e);
            }
        }
        return this.serverDefaults;
    }

    @Override
    public URI getKeyProviderUri() throws IOException {
        String keyProviderUri = this.getServerDefaults() != null ? this.serverDefaults.getKeyProviderUri() : null;
        return OzoneKMSUtil.getKeyProviderUri(this.ugi, null, keyProviderUri, this.conf);
    }

    @Override
    public String getCanonicalServiceName() {
        return this.dtService != null ? this.dtService.toString() : null;
    }

    @Override
    @VisibleForTesting
    public OzoneManagerProtocol getOzoneManagerClient() {
        return this.ozoneManagerClient;
    }

    @VisibleForTesting
    public Cache<URI, KeyProvider> getKeyProviderCache() {
        return this.keyProviderCache;
    }

    @Override
    public OzoneKey headObject(String volumeName, String bucketName, String keyName) throws IOException {
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyBucketName(bucketName);
        Preconditions.checkNotNull((Object)keyName);
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setLatestVersionLocation(true).setHeadOp(true).setForceUpdateContainerCacheFromSCM(false).build();
        OmKeyInfo keyInfo = this.getKeyInfo(keyArgs);
        return OzoneKey.fromKeyInfo(keyInfo);
    }

    @Override
    public OzoneKey headS3Object(String bucketName, String keyName) throws IOException {
        OmKeyInfo keyInfo = this.getS3KeyInfo(bucketName, keyName, true);
        return OzoneKey.fromKeyInfo(keyInfo);
    }

    @Override
    public void setThreadLocalS3Auth(S3Auth ozoneSharedSecretAuth) {
        this.ozoneManagerClient.setThreadLocalS3Auth(ozoneSharedSecretAuth);
        this.s3gUgi = UserGroupInformation.createRemoteUser((String)this.getThreadLocalS3Auth().getUserPrincipal());
    }

    @Override
    public void setIsS3Request(boolean s3Request) {
        this.isS3GRequest.set(s3Request);
    }

    @Override
    public S3Auth getThreadLocalS3Auth() {
        return this.ozoneManagerClient.getThreadLocalS3Auth();
    }

    @Override
    public void clearThreadLocalS3Auth() {
        this.ozoneManagerClient.clearThreadLocalS3Auth();
    }

    @Override
    public ThreadLocal<S3Auth> getS3CredentialsProvider() {
        return this.ozoneManagerClient.getS3CredentialsProvider();
    }

    @Override
    public boolean setBucketOwner(String volumeName, String bucketName, String owner) throws IOException {
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyBucketName(bucketName);
        Preconditions.checkNotNull((Object)owner);
        OmBucketArgs.Builder builder = OmBucketArgs.newBuilder();
        builder.setVolumeName(volumeName).setBucketName(bucketName).setOwnerName(owner);
        return this.ozoneManagerClient.setBucketOwner(builder.build());
    }

    @Override
    public void setTimes(OzoneObj obj, String keyName, long mtime, long atime) throws IOException {
        OmKeyArgs.Builder builder = new OmKeyArgs.Builder().setVolumeName(obj.getVolumeName()).setBucketName(obj.getBucketName()).setKeyName(keyName);
        this.ozoneManagerClient.setTimes(builder.build(), mtime, atime);
    }

    @Override
    public LeaseKeyInfo recoverLease(String volumeName, String bucketName, String keyName, boolean force) throws IOException {
        if (this.omVersion.compareTo((Enum)OzoneManagerVersion.HBASE_SUPPORT) < 0) {
            throw new UnsupportedOperationException("Lease recovery API requires OM version " + OzoneManagerVersion.HBASE_SUPPORT + " or later. Current OM version " + this.omVersion);
        }
        return this.ozoneManagerClient.recoverLease(volumeName, bucketName, keyName, force);
    }

    @Override
    public void recoverKey(OmKeyArgs args, long clientID) throws IOException {
        if (this.omVersion.compareTo((Enum)OzoneManagerVersion.HBASE_SUPPORT) < 0) {
            throw new UnsupportedOperationException("Lease recovery API requires OM version " + OzoneManagerVersion.HBASE_SUPPORT + " or later. Current OM version " + this.omVersion);
        }
        this.ozoneManagerClient.recoverKey(args, clientID);
    }

    @Override
    public Map<String, String> getObjectTagging(String volumeName, String bucketName, String keyName) throws IOException {
        if (this.omVersion.compareTo((Enum)OzoneManagerVersion.S3_OBJECT_TAGGING_API) < 0) {
            throw new IOException("OzoneManager does not support S3 object tagging API");
        }
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyBucketName(bucketName);
        Preconditions.checkNotNull((Object)keyName);
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).build();
        return this.ozoneManagerClient.getObjectTagging(keyArgs);
    }

    @Override
    public void putObjectTagging(String volumeName, String bucketName, String keyName, Map<String, String> tags) throws IOException {
        if (this.omVersion.compareTo((Enum)OzoneManagerVersion.S3_OBJECT_TAGGING_API) < 0) {
            throw new IOException("OzoneManager does not support S3 object tagging API");
        }
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyBucketName(bucketName);
        Preconditions.checkNotNull((Object)keyName);
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).addAllTags(tags).build();
        this.ozoneManagerClient.putObjectTagging(keyArgs);
    }

    @Override
    public void deleteObjectTagging(String volumeName, String bucketName, String keyName) throws IOException {
        if (this.omVersion.compareTo((Enum)OzoneManagerVersion.S3_OBJECT_TAGGING_API) < 0) {
            throw new IOException("OzoneManager does not support S3 object tagging API");
        }
        RpcClient.verifyVolumeName(volumeName);
        RpcClient.verifyBucketName(bucketName);
        Preconditions.checkNotNull((Object)keyName);
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).build();
        this.ozoneManagerClient.deleteObjectTagging(keyArgs);
    }

    private static ExecutorService createThreadPoolExecutor(int corePoolSize, int maximumPoolSize, String threadNameFormat) {
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat(threadNameFormat).setDaemon(true).build(), new ThreadPoolExecutor.CallerRunsPolicy());
    }
}

