/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.api.AdminOnly;
import org.apache.hadoop.ozone.recon.api.types.ContainerDiscrepancyInfo;
import org.apache.hadoop.ozone.recon.api.types.ContainerKeyPrefix;
import org.apache.hadoop.ozone.recon.api.types.ContainerMetadata;
import org.apache.hadoop.ozone.recon.api.types.ContainersResponse;
import org.apache.hadoop.ozone.recon.api.types.DeletedContainerInfo;
import org.apache.hadoop.ozone.recon.api.types.KeyMetadata;
import org.apache.hadoop.ozone.recon.api.types.KeysResponse;
import org.apache.hadoop.ozone.recon.api.types.MissingContainerMetadata;
import org.apache.hadoop.ozone.recon.api.types.MissingContainersResponse;
import org.apache.hadoop.ozone.recon.api.types.UnhealthyContainerMetadata;
import org.apache.hadoop.ozone.recon.api.types.UnhealthyContainersResponse;
import org.apache.hadoop.ozone.recon.api.types.UnhealthyContainersSummary;
import org.apache.hadoop.ozone.recon.persistence.ContainerHealthSchemaManager;
import org.apache.hadoop.ozone.recon.persistence.ContainerHistory;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.scm.ReconContainerManager;
import org.apache.hadoop.ozone.recon.spi.ReconContainerMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;
import org.apache.hadoop.ozone.util.SeekableIterator;
import org.apache.ozone.recon.schema.ContainerSchemaDefinition;
import org.apache.ozone.recon.schema.generated.tables.pojos.UnhealthyContainers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/containers")
@Produces(value={"application/json"})
@AdminOnly
public class ContainerEndpoint {
    private ReconContainerMetadataManager reconContainerMetadataManager;
    private ReconOMMetadataManager omMetadataManager;
    private final ReconContainerManager containerManager;
    private final PipelineManager pipelineManager;
    private final ContainerHealthSchemaManager containerHealthSchemaManager;
    private final ReconNamespaceSummaryManager reconNamespaceSummaryManager;
    private final OzoneStorageContainerManager reconSCM;
    private static final Logger LOG = LoggerFactory.getLogger(ContainerEndpoint.class);
    private BucketLayout layout = BucketLayout.DEFAULT;

    @Inject
    public ContainerEndpoint(OzoneStorageContainerManager reconSCM, ContainerHealthSchemaManager containerHealthSchemaManager, ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconContainerMetadataManager reconContainerMetadataManager, ReconOMMetadataManager omMetadataManager) {
        this.containerManager = (ReconContainerManager)reconSCM.getContainerManager();
        this.pipelineManager = reconSCM.getPipelineManager();
        this.containerHealthSchemaManager = containerHealthSchemaManager;
        this.reconNamespaceSummaryManager = reconNamespaceSummaryManager;
        this.reconSCM = reconSCM;
        this.reconContainerMetadataManager = reconContainerMetadataManager;
        this.omMetadataManager = omMetadataManager;
    }

    @GET
    public Response getContainers(@DefaultValue(value="1000") @QueryParam(value="limit") int limit, @DefaultValue(value="0") @QueryParam(value="prevKey") long prevKey) {
        if (limit < 0 || prevKey < 0L) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        List<ContainerMetadata> containerMetaDataList = this.containerManager.getContainers(ContainerID.valueOf((long)(prevKey + 1L)), limit).stream().map(container -> {
            ContainerMetadata containerMetadata = new ContainerMetadata(container.getContainerID());
            containerMetadata.setNumberOfKeys(container.getNumberOfKeys());
            return containerMetadata;
        }).collect(Collectors.toList());
        long containersCount = containerMetaDataList.size();
        long lastContainerID = containerMetaDataList.isEmpty() ? prevKey : ((ContainerMetadata)containerMetaDataList.get(containerMetaDataList.size() - 1)).getContainerID();
        ContainersResponse containersResponse = new ContainersResponse(containersCount, containerMetaDataList, lastContainerID);
        return Response.ok((Object)containersResponse).build();
    }

    @GET
    @Path(value="/{id}/keys")
    public Response getKeysForContainer(@PathParam(value="id") Long containerID, @DefaultValue(value="1000") @QueryParam(value="limit") int limit, @DefaultValue(value="") @QueryParam(value="prevKey") String prevKeyPrefix) {
        long totalCount;
        LinkedHashMap<String, KeyMetadata> keyMetadataMap = new LinkedHashMap<String, KeyMetadata>();
        String lastKey = "";
        if (limit == -1) {
            limit = Integer.MAX_VALUE;
        }
        try {
            Map<ContainerKeyPrefix, Integer> containerKeyPrefixMap = this.reconContainerMetadataManager.getKeyPrefixesForContainer(containerID, prevKeyPrefix, limit);
            for (ContainerKeyPrefix containerKeyPrefix : containerKeyPrefixMap.keySet()) {
                String ozoneKey;
                OmKeyInfo omKeyInfo = (OmKeyInfo)this.omMetadataManager.getKeyTable(BucketLayout.LEGACY).getSkipCache((Object)containerKeyPrefix.getKeyPrefix());
                if (omKeyInfo == null) {
                    omKeyInfo = (OmKeyInfo)this.omMetadataManager.getKeyTable(BucketLayout.FILE_SYSTEM_OPTIMIZED).getSkipCache((Object)containerKeyPrefix.getKeyPrefix());
                }
                if (null == omKeyInfo) continue;
                List<OmKeyLocationInfoGroup> matchedKeys = omKeyInfo.getKeyLocationVersions().stream().filter(k -> k.getVersion() == containerKeyPrefix.getKeyVersion()).collect(Collectors.toList());
                List<KeyMetadata.ContainerBlockMetadata> blockIds = this.getBlocks(matchedKeys, containerID);
                lastKey = ozoneKey = containerKeyPrefix.getKeyPrefix();
                if (keyMetadataMap.containsKey(ozoneKey)) {
                    ((KeyMetadata)keyMetadataMap.get(ozoneKey)).getVersions().add(containerKeyPrefix.getKeyVersion());
                    ((KeyMetadata)keyMetadataMap.get(ozoneKey)).getBlockIds().put(containerKeyPrefix.getKeyVersion(), blockIds);
                    continue;
                }
                KeyMetadata keyMetadata = new KeyMetadata();
                keyMetadata.setBucket(omKeyInfo.getBucketName());
                keyMetadata.setVolume(omKeyInfo.getVolumeName());
                keyMetadata.setKey(omKeyInfo.getKeyName());
                keyMetadata.setCompletePath(ReconUtils.constructFullPath(omKeyInfo, this.reconNamespaceSummaryManager));
                keyMetadata.setCreationTime(Instant.ofEpochMilli(omKeyInfo.getCreationTime()));
                keyMetadata.setModificationTime(Instant.ofEpochMilli(omKeyInfo.getModificationTime()));
                keyMetadata.setDataSize(omKeyInfo.getDataSize());
                keyMetadata.getVersions().add(containerKeyPrefix.getKeyVersion());
                keyMetadataMap.put(ozoneKey, keyMetadata);
                keyMetadata.getBlockIds().put(containerKeyPrefix.getKeyVersion(), blockIds);
            }
            totalCount = this.reconContainerMetadataManager.getKeyCountForContainer(containerID);
        }
        catch (IOException ioEx) {
            throw new WebApplicationException((Throwable)ioEx, Response.Status.INTERNAL_SERVER_ERROR);
        }
        KeysResponse keysResponse = new KeysResponse(totalCount, keyMetadataMap.values(), lastKey);
        return Response.ok((Object)keysResponse).build();
    }

    @GET
    @Path(value="/{id}/replicaHistory")
    public Response getReplicaHistoryForContainer(@PathParam(value="id") Long containerID) {
        return Response.ok(this.containerManager.getAllContainerHistory(containerID)).build();
    }

    @GET
    @Path(value="/missing")
    @Deprecated
    public Response getMissingContainers(@DefaultValue(value="1000") @QueryParam(value="limit") int limit) {
        ArrayList<MissingContainerMetadata> missingContainers = new ArrayList<MissingContainerMetadata>();
        this.containerHealthSchemaManager.getUnhealthyContainers(ContainerSchemaDefinition.UnHealthyContainerStates.MISSING, 0L, Optional.empty(), limit).forEach(container -> {
            long containerID = container.getContainerId();
            try {
                ContainerInfo containerInfo = this.containerManager.getContainer(ContainerID.valueOf((long)containerID));
                long keyCount = containerInfo.getNumberOfKeys();
                UUID pipelineID = containerInfo.getPipelineID().getId();
                List<ContainerHistory> datanodes = this.containerManager.getLatestContainerHistory(containerID, containerInfo.getReplicationConfig().getRequiredNodes());
                missingContainers.add(new MissingContainerMetadata(containerID, container.getInStateSince(), keyCount, pipelineID, datanodes));
            }
            catch (IOException ioEx) {
                throw new WebApplicationException((Throwable)ioEx, Response.Status.INTERNAL_SERVER_ERROR);
            }
        });
        MissingContainersResponse response = new MissingContainersResponse(missingContainers.size(), missingContainers);
        return Response.ok((Object)response).build();
    }

    @GET
    @Path(value="/unhealthy/{state}")
    public Response getUnhealthyContainers(@PathParam(value="state") String state, @DefaultValue(value="1000") @QueryParam(value="limit") int limit, @DefaultValue(value="0") @QueryParam(value="maxContainerId") long maxContainerId, @DefaultValue(value="0") @QueryParam(value="minContainerId") long minContainerId) {
        List<UnhealthyContainersSummary> summary;
        Optional<Long> maxContainerIdOpt = maxContainerId > 0L ? Optional.of(maxContainerId) : Optional.empty();
        ArrayList<UnhealthyContainerMetadata> unhealthyMeta = new ArrayList<UnhealthyContainerMetadata>();
        try {
            ContainerSchemaDefinition.UnHealthyContainerStates internalState = null;
            if (state != null) {
                internalState = ContainerSchemaDefinition.UnHealthyContainerStates.valueOf((String)state);
            }
            summary = this.containerHealthSchemaManager.getUnhealthyContainersSummary();
            List<UnhealthyContainers> containers = this.containerHealthSchemaManager.getUnhealthyContainers(internalState, minContainerId, maxContainerIdOpt, limit);
            List filteredContainers = containers.stream().filter(container -> !container.getContainerState().equals(ContainerSchemaDefinition.UnHealthyContainerStates.EMPTY_MISSING.toString()) && !container.getContainerState().equals(ContainerSchemaDefinition.UnHealthyContainerStates.NEGATIVE_SIZE.toString())).collect(Collectors.toList());
            for (UnhealthyContainers c : filteredContainers) {
                long containerID = c.getContainerId();
                ContainerInfo containerInfo = this.containerManager.getContainer(ContainerID.valueOf((long)containerID));
                long keyCount = containerInfo.getNumberOfKeys();
                UUID pipelineID = containerInfo.getPipelineID().getId();
                List<ContainerHistory> datanodes = this.containerManager.getLatestContainerHistory(containerID, containerInfo.getReplicationConfig().getRequiredNodes());
                unhealthyMeta.add(new UnhealthyContainerMetadata(c, datanodes, pipelineID, keyCount));
            }
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        UnhealthyContainersResponse response = new UnhealthyContainersResponse(unhealthyMeta);
        if (!unhealthyMeta.isEmpty()) {
            response.setFirstKey(unhealthyMeta.stream().map(UnhealthyContainerMetadata::getContainerID).min(Long::compareTo).orElse(0L));
            response.setLastKey(unhealthyMeta.stream().map(UnhealthyContainerMetadata::getContainerID).max(Long::compareTo).orElse(0L));
        }
        for (UnhealthyContainersSummary s : summary) {
            response.setSummaryCount(s.getContainerState(), s.getCount());
        }
        return Response.ok((Object)response).build();
    }

    @GET
    @Path(value="/unhealthy")
    public Response getUnhealthyContainers(@DefaultValue(value="1000") @QueryParam(value="limit") int limit, @DefaultValue(value="0") @QueryParam(value="maxContainerId") long maxContainerId, @DefaultValue(value="0") @QueryParam(value="minContainerId") long minContainerId) {
        return this.getUnhealthyContainers(null, limit, maxContainerId, minContainerId);
    }

    @GET
    @Path(value="/deleted")
    public Response getSCMDeletedContainers(@DefaultValue(value="1000") @QueryParam(value="limit") int limit, @DefaultValue(value="0") @QueryParam(value="prevKey") long prevKey) {
        ArrayList deletedContainerInfoList = new ArrayList();
        try {
            List<ContainerInfo> containers = this.containerManager.getContainers(ContainerID.valueOf((long)prevKey), limit, HddsProtos.LifeCycleState.DELETED);
            containers = containers.stream().filter(containerInfo -> containerInfo.getContainerID() != prevKey).collect(Collectors.toList());
            containers.forEach(containerInfo -> {
                DeletedContainerInfo deletedContainerInfo = new DeletedContainerInfo();
                deletedContainerInfo.setContainerID(containerInfo.getContainerID());
                deletedContainerInfo.setPipelineID(containerInfo.getPipelineID());
                deletedContainerInfo.setNumberOfKeys(containerInfo.getNumberOfKeys());
                deletedContainerInfo.setContainerState(containerInfo.getState().name());
                deletedContainerInfo.setStateEnterTime(containerInfo.getStateEnterTime().toEpochMilli());
                deletedContainerInfo.setLastUsed(containerInfo.getLastUsed().toEpochMilli());
                deletedContainerInfo.setUsedBytes(containerInfo.getUsedBytes());
                deletedContainerInfo.setReplicationConfig(containerInfo.getReplicationConfig());
                deletedContainerInfo.setReplicationFactor(containerInfo.getReplicationFactor().name());
                deletedContainerInfoList.add(deletedContainerInfo);
            });
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return Response.ok(deletedContainerInfoList).build();
    }

    private List<KeyMetadata.ContainerBlockMetadata> getBlocks(List<OmKeyLocationInfoGroup> matchedKeys, long containerID) {
        ArrayList<KeyMetadata.ContainerBlockMetadata> blockIds = new ArrayList<KeyMetadata.ContainerBlockMetadata>();
        for (OmKeyLocationInfoGroup omKeyLocationInfoGroup : matchedKeys) {
            List omKeyLocationInfos = omKeyLocationInfoGroup.getLocationList().stream().filter(c -> c.getContainerID() == containerID).collect(Collectors.toList());
            for (OmKeyLocationInfo omKeyLocationInfo : omKeyLocationInfos) {
                blockIds.add(new KeyMetadata.ContainerBlockMetadata(omKeyLocationInfo.getContainerID(), omKeyLocationInfo.getLocalID()));
            }
        }
        return blockIds;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/mismatch")
    public Response getContainerMisMatchInsights(@DefaultValue(value="1000") @QueryParam(value="limit") int limit, @DefaultValue(value="0") @QueryParam(value="prevKey") long prevKey, @DefaultValue(value="SCM") @QueryParam(value="missingIn") String missingIn) {
        if (prevKey < 0L) return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        if (limit < 0) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        containerDiscrepancyInfoList = new ArrayList<E>();
        minContainerID = prevKey + 1L;
        scmNonDeletedContainers = this.containerManager.getContainers().stream().filter((Predicate<ContainerInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getContainerMisMatchInsights$7(java.lang.Long org.apache.hadoop.hdds.scm.container.ContainerInfo ), (Lorg/apache/hadoop/hdds/scm/container/ContainerInfo;)Z)((Long)minContainerID)).filter((Predicate<ContainerInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getContainerMisMatchInsights$8(org.apache.hadoop.hdds.scm.container.ContainerInfo ), (Lorg/apache/hadoop/hdds/scm/container/ContainerInfo;)Z)()).sorted(Comparator.comparingLong((ToLongFunction<ContainerInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)J, getContainerID(), (Lorg/apache/hadoop/hdds/scm/container/ContainerInfo;)J)())).iterator();
        scmContainerInfo = scmNonDeletedContainers.hasNext() != false ? (ContainerInfo)scmNonDeletedContainers.next() : null;
        dataFilter = DataFilter.fromValue(missingIn.toUpperCase());
        try {
            omContainers = this.reconContainerMetadataManager.getContainersIterator();
            try {
                omContainers.seek((Object)minContainerID);
                containerMetadata = omContainers.hasNext() != false ? (ContainerMetadata)omContainers.next() : null;
                switch (dataFilter.ordinal()) {
                    case 0: {
                        notSCMContainers = new ArrayList<ContainerMetadata>();
                        while (containerMetadata != null && notSCMContainers.size() < limit) {
                            omContainerID = containerMetadata.getContainerID();
                            v0 = scmContainerID = scmContainerInfo == null ? null : Long.valueOf(scmContainerInfo.getContainerID());
                            if (omContainerID.equals(scmContainerID)) {
                                containerMetadata = omContainers.hasNext() != false ? (ContainerMetadata)omContainers.next() : null;
                                scmContainerInfo = scmNonDeletedContainers.hasNext() != false ? (ContainerInfo)scmNonDeletedContainers.next() : null;
                                continue;
                            }
                            if (scmContainerID == null || omContainerID.compareTo(scmContainerID) < 0) {
                                notSCMContainers.add(containerMetadata);
                                containerMetadata = omContainers.hasNext() != false ? (ContainerMetadata)omContainers.next() : null;
                                continue;
                            }
                            scmContainerInfo = scmNonDeletedContainers.hasNext() != false ? (ContainerInfo)scmNonDeletedContainers.next() : null;
                        }
                        notSCMContainers.forEach((Consumer<ContainerMetadata>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getContainerMisMatchInsights$9(java.util.List org.apache.hadoop.ozone.recon.api.types.ContainerMetadata ), (Lorg/apache/hadoop/ozone/recon/api/types/ContainerMetadata;)V)(containerDiscrepancyInfoList));
                        ** break;
lbl33:
                        // 1 sources

                        break;
                    }
                    case 1: {
                        nonOMContainers = new ArrayList<ContainerInfo>();
                        while (scmContainerInfo != null && nonOMContainers.size() < limit) {
                            omContainerID = containerMetadata == null ? null : Long.valueOf(containerMetadata.getContainerID());
                            scmContainerID = scmContainerInfo.getContainerID();
                            if (scmContainerID.equals(omContainerID)) {
                                scmContainerInfo = scmNonDeletedContainers.hasNext() != false ? (ContainerInfo)scmNonDeletedContainers.next() : null;
                                containerMetadata = omContainers.hasNext() != false ? (ContainerMetadata)omContainers.next() : null;
                                continue;
                            }
                            if (omContainerID == null || scmContainerID.compareTo(omContainerID) < 0) {
                                nonOMContainers.add(scmContainerInfo);
                                scmContainerInfo = scmNonDeletedContainers.hasNext() != false ? (ContainerInfo)scmNonDeletedContainers.next() : null;
                                continue;
                            }
                            omContainers.seek((Object)scmContainerID);
                            containerMetadata = omContainers.hasNext() != false ? (ContainerMetadata)omContainers.next() : null;
                        }
                        pipelines = new ArrayList<E>();
                        nonOMContainers.forEach((Consumer<ContainerInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getContainerMisMatchInsights$10(java.util.List java.util.List org.apache.hadoop.hdds.scm.container.ContainerInfo ), (Lorg/apache/hadoop/hdds/scm/container/ContainerInfo;)V)((ContainerEndpoint)this, pipelines, containerDiscrepancyInfoList));
                        ** break;
lbl54:
                        // 1 sources

                        break;
                    }
                    default: {
                        var15_21 = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                        return var15_21;
                    }
                }
            }
            finally {
                if (omContainers != null) {
                    omContainers.close();
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
        response = new HashMap<String, Serializable>();
        if (!containerDiscrepancyInfoList.isEmpty()) {
            response.put("lastKey", Long.valueOf(((ContainerDiscrepancyInfo)containerDiscrepancyInfoList.get(containerDiscrepancyInfoList.size() - 1)).getContainerID()));
        } else {
            response.put("lastKey", null);
        }
        response.put("containerDiscrepancyInfo", containerDiscrepancyInfoList);
        return Response.ok(response).build();
    }

    @GET
    @Path(value="/mismatch/deleted")
    public Response getOmContainersDeletedInSCM(@DefaultValue(value="1000") @QueryParam(value="limit") int limit, @DefaultValue(value="0") @QueryParam(value="prevKey") long prevKey) {
        List containerDiscrepancyInfoList;
        if (prevKey < 0L) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        if (limit <= 0) {
            limit = Integer.MAX_VALUE;
        }
        long minContainerID = prevKey + 1L;
        Iterator deletedStateSCMContainers = this.containerManager.getContainers().stream().filter(containerInfo -> containerInfo.getContainerID() >= minContainerID).filter(containerInfo -> containerInfo.getState() == HddsProtos.LifeCycleState.DELETED).sorted(Comparator.comparingLong(ContainerInfo::getContainerID)).iterator();
        try (SeekableIterator<Long, ContainerMetadata> omContainers = this.reconContainerMetadataManager.getContainersIterator();){
            ContainerInfo scmContainerInfo = deletedStateSCMContainers.hasNext() ? (ContainerInfo)deletedStateSCMContainers.next() : null;
            ContainerMetadata containerMetadata = omContainers.hasNext() ? (ContainerMetadata)omContainers.next() : null;
            ArrayList<ContainerMetadata> omContainersDeletedInSCM = new ArrayList<ContainerMetadata>();
            while (containerMetadata != null && scmContainerInfo != null && omContainersDeletedInSCM.size() < limit) {
                Long omContainerID = containerMetadata.getContainerID();
                Long scmContainerID = scmContainerInfo.getContainerID();
                if (scmContainerID.equals(omContainerID)) {
                    omContainersDeletedInSCM.add(containerMetadata);
                    scmContainerInfo = deletedStateSCMContainers.hasNext() ? (ContainerInfo)deletedStateSCMContainers.next() : null;
                    containerMetadata = omContainers.hasNext() ? (ContainerMetadata)omContainers.next() : null;
                    continue;
                }
                if (scmContainerID.compareTo(omContainerID) < 0) {
                    scmContainerInfo = deletedStateSCMContainers.hasNext() ? (ContainerInfo)deletedStateSCMContainers.next() : null;
                    continue;
                }
                omContainers.seek((Object)scmContainerID);
                containerMetadata = omContainers.hasNext() ? (ContainerMetadata)omContainers.next() : null;
            }
            containerDiscrepancyInfoList = omContainersDeletedInSCM.stream().map(containerMetadataEntry -> {
                ContainerDiscrepancyInfo containerDiscrepancyInfo = new ContainerDiscrepancyInfo();
                containerDiscrepancyInfo.setContainerID(containerMetadataEntry.getContainerID());
                containerDiscrepancyInfo.setNumberOfKeys(containerMetadataEntry.getNumberOfKeys());
                containerDiscrepancyInfo.setPipelines(containerMetadataEntry.getPipelines());
                return containerDiscrepancyInfo;
            }).collect(Collectors.toList());
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (!containerDiscrepancyInfoList.isEmpty()) {
            response.put("lastKey", ((ContainerDiscrepancyInfo)containerDiscrepancyInfoList.get(containerDiscrepancyInfoList.size() - 1)).getContainerID());
        } else {
            response.put("lastKey", null);
        }
        response.put("containerDiscrepancyInfo", containerDiscrepancyInfoList);
        return Response.ok(response).build();
    }

    private /* synthetic */ void lambda$getContainerMisMatchInsights$10(List pipelines, List containerDiscrepancyInfoList, ContainerInfo containerInfo) {
        ContainerDiscrepancyInfo containerDiscrepancyInfo = new ContainerDiscrepancyInfo();
        containerDiscrepancyInfo.setContainerID(containerInfo.getContainerID());
        containerDiscrepancyInfo.setNumberOfKeys(0L);
        PipelineID pipelineID = null;
        try {
            pipelineID = containerInfo.getPipelineID();
            if (pipelineID != null) {
                pipelines.add(this.pipelineManager.getPipeline(pipelineID));
            }
        }
        catch (PipelineNotFoundException e) {
            LOG.debug("Pipeline not found for container: {} and pipelineId: {}", new Object[]{containerInfo, pipelineID, e});
        }
        containerDiscrepancyInfo.setPipelines(pipelines);
        containerDiscrepancyInfo.setExistsAt("SCM");
        containerDiscrepancyInfoList.add(containerDiscrepancyInfo);
    }

    private static /* synthetic */ void lambda$getContainerMisMatchInsights$9(List containerDiscrepancyInfoList, ContainerMetadata nonSCMContainer) {
        ContainerDiscrepancyInfo containerDiscrepancyInfo = new ContainerDiscrepancyInfo();
        containerDiscrepancyInfo.setContainerID(nonSCMContainer.getContainerID());
        containerDiscrepancyInfo.setNumberOfKeys(nonSCMContainer.getNumberOfKeys());
        containerDiscrepancyInfo.setPipelines(nonSCMContainer.getPipelines());
        containerDiscrepancyInfo.setExistsAt("OM");
        containerDiscrepancyInfoList.add(containerDiscrepancyInfo);
    }

    private static /* synthetic */ boolean lambda$getContainerMisMatchInsights$8(ContainerInfo containerInfo) {
        return containerInfo.getState() != HddsProtos.LifeCycleState.DELETED;
    }

    private static /* synthetic */ boolean lambda$getContainerMisMatchInsights$7(Long minContainerID, ContainerInfo containerInfo) {
        return containerInfo.getContainerID() >= minContainerID;
    }

    public static enum DataFilter {
        SCM("SCM"),
        OM("OM");

        private final String value;

        private DataFilter(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static DataFilter fromValue(String value) {
            for (DataFilter filter : DataFilter.values()) {
                if (!filter.getValue().equalsIgnoreCase(value)) continue;
                return filter;
            }
            throw new IllegalArgumentException("Invalid DataFilter value: " + value);
        }
    }
}

