/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.WithParentObjectId;
import org.apache.hadoop.ozone.recon.api.types.NSSummary;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;
import org.apache.hadoop.ozone.recon.tasks.NSSummaryTaskDbEventHandler;
import org.apache.hadoop.ozone.recon.tasks.OMDBUpdateEvent;
import org.apache.hadoop.ozone.recon.tasks.OMUpdateEventBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSSummaryTaskWithFSO
extends NSSummaryTaskDbEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NSSummaryTaskWithFSO.class);
    private final long nsSummaryFlushToDBMaxThreshold;

    public NSSummaryTaskWithFSO(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager reconOMMetadataManager, long nsSummaryFlushToDBMaxThreshold) {
        super(reconNamespaceSummaryManager, reconOMMetadataManager);
        this.nsSummaryFlushToDBMaxThreshold = nsSummaryFlushToDBMaxThreshold;
    }

    public Collection<String> getTaskTables() {
        return Arrays.asList("fileTable", "directoryTable", "deletedDirectoryTable");
    }

    public Pair<Integer, Boolean> processWithFSO(OMUpdateEventBatch events, int seekPos) {
        Iterator<OMDBUpdateEvent> eventIterator = events.getIterator();
        for (int itrPos = 0; eventIterator.hasNext() && itrPos < seekPos; ++itrPos) {
            eventIterator.next();
        }
        Collection<String> taskTables = this.getTaskTables();
        HashMap<Long, NSSummary> nsSummaryMap = new HashMap<Long, NSSummary>();
        int eventCounter = 0;
        List<Long> objectIdsToBeDeleted = Collections.synchronizedList(new ArrayList());
        while (eventIterator.hasNext()) {
            OMDBUpdateEvent omdbUpdateEvent = eventIterator.next();
            OMDBUpdateEvent.OMDBUpdateAction action = omdbUpdateEvent.getAction();
            ++eventCounter;
            String table = omdbUpdateEvent.getTable();
            if (!taskTables.contains(table)) continue;
            try {
                if (table.equals("fileTable")) {
                    this.handleUpdateOnFileTable(omdbUpdateEvent, action, nsSummaryMap);
                } else if (table.equals("deletedDirectoryTable")) {
                    this.handleUpdateOnDeletedDirTable(omdbUpdateEvent, action, nsSummaryMap, objectIdsToBeDeleted);
                } else {
                    this.handleUpdateOnDirTable(omdbUpdateEvent, action, nsSummaryMap);
                }
            }
            catch (IOException ioEx) {
                LOG.error("Unable to process Namespace Summary data in Recon DB. ", (Throwable)ioEx);
                nsSummaryMap.clear();
                return new ImmutablePair((Object)seekPos, (Object)false);
            }
            if ((long)nsSummaryMap.size() < this.nsSummaryFlushToDBMaxThreshold) continue;
            if (!this.flushAndCommitUpdatedNSToDB(nsSummaryMap, objectIdsToBeDeleted)) {
                return new ImmutablePair((Object)seekPos, (Object)false);
            }
            seekPos = eventCounter + 1;
        }
        if (!this.flushAndCommitUpdatedNSToDB(nsSummaryMap, objectIdsToBeDeleted)) {
            return new ImmutablePair((Object)seekPos, (Object)false);
        }
        LOG.debug("Completed a process run of NSSummaryTaskWithFSO");
        return new ImmutablePair((Object)seekPos, (Object)true);
    }

    private void handleUpdateOnDirTable(OMDBUpdateEvent<String, ? extends WithParentObjectId> omdbUpdateEvent, OMDBUpdateEvent.OMDBUpdateAction action, Map<Long, NSSummary> nsSummaryMap) throws IOException {
        OMDBUpdateEvent<String, ? extends WithParentObjectId> dirTableUpdateEvent = omdbUpdateEvent;
        OmDirectoryInfo updatedDirectoryInfo = (OmDirectoryInfo)dirTableUpdateEvent.getValue();
        OmDirectoryInfo oldDirectoryInfo = (OmDirectoryInfo)dirTableUpdateEvent.getOldValue();
        switch (action) {
            case PUT: {
                this.handlePutDirEvent(updatedDirectoryInfo, nsSummaryMap);
                break;
            }
            case DELETE: {
                this.handleDeleteDirEvent(updatedDirectoryInfo, nsSummaryMap);
                break;
            }
            case UPDATE: {
                if (oldDirectoryInfo != null) {
                    this.handleDeleteDirEvent(oldDirectoryInfo, nsSummaryMap);
                } else {
                    LOG.warn("Update event does not have the old dirInfo for {}.", (Object)dirTableUpdateEvent.getKey());
                }
                this.handlePutDirEvent(updatedDirectoryInfo, nsSummaryMap);
                break;
            }
            default: {
                LOG.debug("Skipping DB update event : {}", (Object)omdbUpdateEvent.getAction());
            }
        }
    }

    private void handleUpdateOnDeletedDirTable(OMDBUpdateEvent<String, ? extends WithParentObjectId> omdbUpdateEvent, OMDBUpdateEvent.OMDBUpdateAction action, Map<Long, NSSummary> nsSummaryMap, Collection<Long> objectIdsToBeDeleted) {
        OMDBUpdateEvent<String, ? extends WithParentObjectId> deletedDirTableUpdateEvent = omdbUpdateEvent;
        OmKeyInfo deletedKeyInfo = (OmKeyInfo)deletedDirTableUpdateEvent.getValue();
        switch (action) {
            case DELETE: {
                if (deletedKeyInfo == null) break;
                long objectId = deletedKeyInfo.getObjectID();
                nsSummaryMap.remove(objectId);
                LOG.debug("Removed hard deleted directory with objectId {} from nsSummaryMap", (Object)objectId);
                objectIdsToBeDeleted.add(objectId);
                break;
            }
            default: {
                LOG.debug("Skipping DB update event on deletedDirTable: {}", (Object)action);
            }
        }
    }

    private void handleUpdateOnFileTable(OMDBUpdateEvent<String, ? extends WithParentObjectId> omdbUpdateEvent, OMDBUpdateEvent.OMDBUpdateAction action, Map<Long, NSSummary> nsSummaryMap) throws IOException {
        OMDBUpdateEvent<String, ? extends WithParentObjectId> keyTableUpdateEvent = omdbUpdateEvent;
        OmKeyInfo updatedKeyInfo = (OmKeyInfo)keyTableUpdateEvent.getValue();
        OmKeyInfo oldKeyInfo = (OmKeyInfo)keyTableUpdateEvent.getOldValue();
        switch (action) {
            case PUT: {
                this.handlePutKeyEvent(updatedKeyInfo, nsSummaryMap);
                break;
            }
            case DELETE: {
                this.handleDeleteKeyEvent(updatedKeyInfo, nsSummaryMap);
                break;
            }
            case UPDATE: {
                if (oldKeyInfo != null) {
                    this.handleDeleteKeyEvent(oldKeyInfo, nsSummaryMap);
                } else {
                    LOG.warn("Update event does not have the old keyInfo for {}.", (Object)omdbUpdateEvent.getKey());
                }
                this.handlePutKeyEvent(updatedKeyInfo, nsSummaryMap);
                break;
            }
            default: {
                LOG.debug("Skipping DB update event : {}", (Object)omdbUpdateEvent.getAction());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean reprocessWithFSO(OMMetadataManager omMetadataManager) {
        HashMap<Long, NSSummary> nsSummaryMap = new HashMap<Long, NSSummary>();
        try {
            Table dirTable = omMetadataManager.getDirectoryTable();
            try (Table.KeyValueIterator dirTableIter = dirTable.iterator();){
                while (dirTableIter.hasNext()) {
                    Table.KeyValue kv = (Table.KeyValue)dirTableIter.next();
                    OmDirectoryInfo directoryInfo = (OmDirectoryInfo)kv.getValue();
                    this.handlePutDirEvent(directoryInfo, nsSummaryMap);
                    if ((long)nsSummaryMap.size() < this.nsSummaryFlushToDBMaxThreshold || this.flushAndCommitNSToDB(nsSummaryMap)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            Table keyTable = omMetadataManager.getFileTable();
            try (Table.KeyValueIterator keyTableIter = keyTable.iterator();){
                while (keyTableIter.hasNext()) {
                    Table.KeyValue kv = (Table.KeyValue)keyTableIter.next();
                    OmKeyInfo keyInfo = (OmKeyInfo)kv.getValue();
                    this.handlePutKeyEvent(keyInfo, nsSummaryMap);
                    if ((long)nsSummaryMap.size() < this.nsSummaryFlushToDBMaxThreshold || this.flushAndCommitNSToDB(nsSummaryMap)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        catch (IOException ioEx) {
            LOG.error("Unable to reprocess Namespace Summary data in Recon DB. ", (Throwable)ioEx);
            return false;
        }
        if (!this.flushAndCommitNSToDB(nsSummaryMap)) {
            LOG.info("flushAndCommitNSToDB failed during reprocessWithFSO.");
            return false;
        }
        LOG.info("Completed a reprocess run of NSSummaryTaskWithFSO");
        return true;
    }
}

