/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.ozone.om.codec.OMDBDefinition;
import org.apache.hadoop.ozone.recon.tasks.OMDBUpdateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmUpdateEventValidator {
    private static Logger log = LoggerFactory.getLogger(OmUpdateEventValidator.class);
    private OMDBDefinition omdbDefinition;

    public OmUpdateEventValidator(OMDBDefinition omdbDefinition) {
        this.omdbDefinition = omdbDefinition;
    }

    public boolean isValidEvent(String tableName, Object actualValueType, Object keyType, OMDBUpdateEvent.OMDBUpdateAction action) {
        String actualValueTypeString;
        String expectedValueTypeString = this.omdbDefinition.getColumnFamily(tableName).getValueType().getName();
        if (expectedValueTypeString.equals(actualValueTypeString = actualValueType.getClass().getName())) {
            return true;
        }
        this.logWarn(keyType.toString(), tableName, action.toString(), expectedValueTypeString, actualValueTypeString);
        return false;
    }

    private void logWarn(String keyType, String tableName, String action, String expectedValueType, String actualValueType) {
        String warnMessage = String.format("Validation failed for keyType: %s, tableName: %s, action: %s, Expected value type: %s, Actual value type: %s", keyType, tableName, action, expectedValueType, actualValueType);
        log.warn(warnMessage);
    }

    @VisibleForTesting
    public static void setLogger(Logger logger) {
        log = logger;
    }
}

