/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.upgrade;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.hadoop.ozone.recon.upgrade.ReconLayoutFeature;
import org.apache.hadoop.ozone.recon.upgrade.ReconUpgradeAction;
import org.apache.hadoop.ozone.recon.upgrade.UpgradeActionRecon;
import org.apache.ozone.recon.schema.SqlDbUtils;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Name;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UpgradeActionRecon(feature=ReconLayoutFeature.TASK_STATUS_STATISTICS, type=ReconUpgradeAction.UpgradeActionType.FINALIZE)
public class ReconTaskStatusTableUpgradeAction
implements ReconUpgradeAction {
    private static final Logger LOG = LoggerFactory.getLogger(ReconTaskStatusTableUpgradeAction.class);

    private void addColumnToTable(DSLContext dslContext, String columnName) {
        dslContext.alterTable("RECON_TASK_STATUS").addColumn(columnName, SQLDataType.INTEGER.nullable(true)).execute();
    }

    private void setColumnAsNonNullable(DSLContext dslContext, String columnName) {
        dslContext.alterTable("RECON_TASK_STATUS").alterColumn(DSL.name((String)columnName)).setNotNull().execute();
    }

    @Override
    public void execute(DataSource dataSource) throws DataAccessException {
        try (Connection conn = dataSource.getConnection();){
            if (!SqlDbUtils.TABLE_EXISTS_CHECK.test(conn, "RECON_TASK_STATUS")) {
                return;
            }
            DSLContext dslContext = DSL.using((Connection)conn);
            LOG.info("Adding 'last_task_run_status' column to task status table");
            this.addColumnToTable(dslContext, "last_task_run_status");
            LOG.info("Adding 'is_current_task_running' column to task status table");
            this.addColumnToTable(dslContext, "is_current_task_running");
            int updatedRowCount = dslContext.update(DSL.table((String)"RECON_TASK_STATUS")).set(DSL.field((Name)DSL.name((String)"last_task_run_status"), (DataType)SQLDataType.INTEGER), (Object)0).set(DSL.field((Name)DSL.name((String)"is_current_task_running"), (DataType)SQLDataType.INTEGER), (Object)0).execute();
            LOG.info("Updated {} rows with default value for new columns", (Object)updatedRowCount);
            this.setColumnAsNonNullable(dslContext, "last_task_run_status");
            this.setColumnAsNonNullable(dslContext, "is_current_task_running");
        }
        catch (SQLException | DataAccessException ex) {
            LOG.error("Error while upgrading RECON_TASK_STATUS table.", ex);
        }
    }

    @Override
    public ReconUpgradeAction.UpgradeActionType getType() {
        return ReconUpgradeAction.UpgradeActionType.FINALIZE;
    }
}

