/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3;

import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.ozone.client.io.WrappedOutputStream;

@Provider
public class TracingFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    public static final String TRACING_SPAN_CLOSABLE = "TRACING_SPAN_CLOSABLE";
    @Context
    private ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext requestContext) {
        TracingFilter.finishAndCloseActiveSpan();
        TracingUtil.TraceCloseable activatedSpan = TracingUtil.createActivatedSpan((String)(this.resourceInfo.getResourceClass().getSimpleName() + "." + this.resourceInfo.getResourceMethod().getName()));
        requestContext.setProperty(TRACING_SPAN_CLOSABLE, (Object)activatedSpan);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        final TracingUtil.TraceCloseable spanClosable = (TracingUtil.TraceCloseable)requestContext.getProperty(TRACING_SPAN_CLOSABLE);
        OutputStream out = responseContext.getEntityStream();
        if (out != null) {
            responseContext.setEntityStream((OutputStream)new WrappedOutputStream(out){

                public void close() throws IOException {
                    super.close();
                    TracingFilter.finishAndClose(spanClosable);
                }
            });
        } else {
            TracingFilter.finishAndClose(spanClosable);
        }
    }

    private static void finishAndClose(TracingUtil.TraceCloseable spanClosable) {
        try {
            spanClosable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        TracingFilter.finishAndCloseActiveSpan();
    }

    private static void finishAndCloseActiveSpan() {
        TracingUtil.getActiveSpan().end();
    }
}

