/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.net;

import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.net.InnerNode;

public interface Node {
    public String getNetworkLocation();

    public void setNetworkLocation(String var1);

    public String getNetworkName();

    public void setNetworkName(String var1);

    public String getNetworkFullPath();

    public InnerNode getParent();

    public void setParent(InnerNode var1);

    public Node getAncestor(int var1);

    public int getLevel();

    public void setLevel(int var1);

    public int getCost();

    public int getNumOfLeaves();

    public boolean isAncestor(Node var1);

    public boolean isAncestor(String var1);

    public boolean isDescendant(Node var1);

    public boolean isDescendant(String var1);

    default public HddsProtos.NetworkNode toProtobuf(int clientVersion) {
        return null;
    }

    public static Node fromProtobuf(HddsProtos.NetworkNode networkNode) {
        if (networkNode.hasDatanodeDetails()) {
            return DatanodeDetails.getFromProtoBuf(networkNode.getDatanodeDetails());
        }
        if (networkNode.hasInnerNode()) {
            return InnerNode.fromProtobuf(networkNode.getInnerNode());
        }
        return null;
    }
}

