/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.net;

import java.util.List;

public final class NodeSchema {
    private int cost;
    private LayerType type;
    private String defaultName;
    private String prefix;
    private List<NodeSchema> sublayer;

    public NodeSchema(LayerType type, int cost, String prefix, String defaultName) {
        this.type = type;
        this.cost = cost;
        this.prefix = prefix;
        this.defaultName = defaultName;
    }

    public NodeSchema() {
        this.type = LayerType.INNER_NODE;
    }

    public boolean matchPrefix(String name) {
        if (name == null || name.isEmpty() || this.prefix == null || this.prefix.isEmpty()) {
            return false;
        }
        return name.trim().toLowerCase().startsWith(this.prefix.toLowerCase());
    }

    public LayerType getType() {
        return this.type;
    }

    public void setType(LayerType type) {
        this.type = type;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public void setDefaultName(String name) {
        this.defaultName = name;
    }

    public int getCost() {
        return this.cost;
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    public void setSublayer(List<NodeSchema> sublayer) {
        this.sublayer = sublayer;
    }

    public List<NodeSchema> getSublayer() {
        return this.sublayer;
    }

    public static enum LayerType {
        ROOT("Root", 1),
        INNER_NODE("InnerNode", 1),
        LEAF_NODE("Leaf", 0);

        private final String description;
        private final int cost;

        private LayerType(String description, int cost) {
            this.description = description;
            this.cost = cost;
        }

        public String toString() {
            return this.description;
        }

        public int getCost() {
            return this.cost;
        }

        public static LayerType getType(String typeStr) {
            for (LayerType type : LayerType.values()) {
                if (!typeStr.equalsIgnoreCase(type.toString())) continue;
                return type;
            }
            return null;
        }
    }

    public static class Builder {
        private int cost = -1;
        private LayerType type;
        private String defaultName;
        private String prefix;

        public Builder setCost(int nodeCost) {
            this.cost = nodeCost;
            return this;
        }

        public Builder setPrefix(String nodePrefix) {
            this.prefix = nodePrefix;
            return this;
        }

        public Builder setType(LayerType nodeType) {
            this.type = nodeType;
            return this;
        }

        public Builder setDefaultName(String nodeDefaultName) {
            this.defaultName = nodeDefaultName;
            return this;
        }

        public NodeSchema build() {
            if (this.type == null) {
                throw new IllegalArgumentException("Type is mandatory for a network topology node layer definition");
            }
            if (this.cost == -1) {
                this.cost = this.type.getCost();
            }
            return new NodeSchema(this.type, this.cost, this.prefix, this.defaultName);
        }
    }
}

