/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.cert;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.protocol.SCMSecurityProtocol;
import org.apache.hadoop.hdds.scm.cli.cert.ScmCertSubcommand;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateCodec;
import picocli.CommandLine;

@CommandLine.Command(name="info", description={"Show detailed information for a specific certificate"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
class InfoSubcommand
extends ScmCertSubcommand {
    @CommandLine.Parameters(description={"Serial id of the certificate in decimal."})
    private String serialId;

    InfoSubcommand() {
    }

    @Override
    public void execute(SCMSecurityProtocol client) throws IOException {
        String certPemStr = client.getCertificate(this.serialId);
        Preconditions.checkNotNull((Object)certPemStr, (Object)"Certificate can't be found");
        System.out.printf("Certificate id: %s%n", this.serialId);
        try {
            X509Certificate cert = CertificateCodec.getX509Certificate((String)certPemStr);
            System.out.println(cert);
        }
        catch (CertificateException ex) {
            System.err.println("Failed to get certificate id " + this.serialId);
            throw new IOException("Fail to get certificate id " + this.serialId, ex);
        }
    }
}

