/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.repair;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.metadata.SCMDBDefinition;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.hdds.utils.db.DBColumnFamilyDefinition;
import org.apache.hadoop.hdds.utils.db.StringCodec;
import org.apache.hadoop.hdds.utils.db.managed.ManagedConfigOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedDBOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksDB;
import org.apache.hadoop.ozone.debug.RocksDBUtils;
import org.apache.hadoop.ozone.om.codec.OMDBDefinition;
import org.apache.hadoop.ozone.repair.RepairTool;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.DBOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import picocli.CommandLine;

@CommandLine.Command(name="update-transaction", description={"CLI to update the highest index in transaction info table."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class TransactionInfoRepair
extends RepairTool {
    @CommandLine.Option(names={"--db"}, required=true, description={"Database File Path"})
    private String dbPath;
    @CommandLine.Option(names={"--term"}, required=true, description={"Highest term to set. The input should be non-zero long integer."})
    private long highestTransactionTerm;
    @CommandLine.Option(names={"--index"}, required=true, description={"Highest index to set. The input should be non-zero long integer."})
    private long highestTransactionIndex;

    @Override
    public void execute() throws Exception {
        ManagedConfigOptions configOptions = new ManagedConfigOptions();
        ManagedDBOptions dbOptions = new ManagedDBOptions();
        ArrayList<ColumnFamilyHandle> cfHandleList = new ArrayList<ColumnFamilyHandle>();
        ArrayList cfDescList = new ArrayList();
        String columnFamilyName = TransactionInfoRepair.getColumnFamily(this.serviceToBeOffline()).getName();
        try (ManagedRocksDB db = ManagedRocksDB.openWithLatestOptions((ManagedConfigOptions)configOptions, (DBOptions)dbOptions, (String)this.dbPath, cfDescList, cfHandleList);){
            ColumnFamilyHandle transactionInfoCfh = RocksDBUtils.getColumnFamilyHandle(columnFamilyName, cfHandleList);
            if (transactionInfoCfh == null) {
                throw new IllegalArgumentException(columnFamilyName + " is not in a column family in DB for the given path.");
            }
            TransactionInfo originalTransactionInfo = (TransactionInfo)RocksDBUtils.getValue(db, transactionInfoCfh, "#TRANSACTIONINFO", TransactionInfo.getCodec());
            this.info("The original highest transaction Info was %s", originalTransactionInfo.getTermIndex());
            TransactionInfo transactionInfo = TransactionInfo.valueOf((long)this.highestTransactionTerm, (long)this.highestTransactionIndex);
            byte[] transactionInfoBytes = TransactionInfo.getCodec().toPersistedFormat((Object)transactionInfo);
            byte[] key = StringCodec.get().toPersistedFormat("#TRANSACTIONINFO");
            this.info("Updating transaction info to %s", transactionInfo.getTermIndex());
            if (!this.isDryRun()) {
                ((RocksDB)db.get()).put(transactionInfoCfh, key, transactionInfoBytes);
                this.info("The highest transaction info has been updated to: %s", ((TransactionInfo)RocksDBUtils.getValue(db, transactionInfoCfh, "#TRANSACTIONINFO", TransactionInfo.getCodec())).getTermIndex());
            }
        }
        catch (RocksDBException exception) {
            try {
                this.error("Failed to update the RocksDB for the given path: %s", this.dbPath);
                throw new IOException("Failed to update RocksDB.", exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{configOptions});
                IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{dbOptions});
                IOUtils.closeQuietly(cfHandleList);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{configOptions});
        IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{dbOptions});
        IOUtils.closeQuietly(cfHandleList);
    }

    @Override
    @Nonnull
    protected RepairTool.Component serviceToBeOffline() {
        String parent;
        switch (parent = this.spec().parent().name()) {
            case "om": {
                return RepairTool.Component.OM;
            }
            case "scm": {
                return RepairTool.Component.SCM;
            }
        }
        throw new IllegalStateException("Unknown component: " + parent);
    }

    public static DBColumnFamilyDefinition<String, TransactionInfo> getColumnFamily(RepairTool.Component component) {
        switch (component) {
            case OM: {
                return OMDBDefinition.TRANSACTION_INFO_TABLE_DEF;
            }
            case SCM: {
                return SCMDBDefinition.TRANSACTIONINFO;
            }
        }
        throw new IllegalStateException("This tool does not support component: " + (Object)((Object)component));
    }
}

