/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.repair.datanode.schemaupgrade;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutFeature;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.FixedLengthStringCodec;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.impl.ContainerDataYaml;
import org.apache.hadoop.ozone.container.common.utils.DatanodeStoreCache;
import org.apache.hadoop.ozone.container.common.utils.RawDB;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainer;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.helpers.BlockUtils;
import org.apache.hadoop.ozone.container.keyvalue.helpers.KeyValueContainerUtil;
import org.apache.hadoop.ozone.container.metadata.DatanodeSchemaThreeDBDefinition;
import org.apache.hadoop.ozone.container.metadata.DatanodeStore;
import org.apache.hadoop.ozone.container.metadata.DatanodeStoreSchemaThreeImpl;
import org.apache.hadoop.ozone.repair.RepairTool;
import org.apache.hadoop.ozone.repair.datanode.schemaupgrade.ContainerUpgradeResult;
import org.apache.hadoop.ozone.repair.datanode.schemaupgrade.UpgradeUtils;
import org.apache.hadoop.ozone.repair.datanode.schemaupgrade.VolumeUpgradeResult;
import org.apache.hadoop.util.Time;
import picocli.CommandLine;

@CommandLine.Command(name="upgrade-container-schema", description={"Offline upgrade all schema V2 containers to schema V3 for this datanode."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class UpgradeContainerSchema
extends RepairTool {
    @CommandLine.Option(names={"--volume"}, description={"volume path"})
    private String volume;
    private List<VolumeUpgradeResult> lastResults;

    List<VolumeUpgradeResult> run(OzoneConfiguration configuration, List<HddsVolume> volumes) {
        ArrayList<VolumeUpgradeResult> results = new ArrayList<VolumeUpgradeResult>();
        HashMap<HddsVolume, CompletableFuture<VolumeUpgradeResult>> volumeFutures = new HashMap<HddsVolume, CompletableFuture<VolumeUpgradeResult>>();
        long startTime = Time.monotonicNow();
        this.info("Start to upgrade %s volume(s)", volumes.size());
        for (HddsVolume hddsVolume : volumes) {
            UpgradeTask task = new UpgradeTask((ConfigurationSource)configuration, hddsVolume);
            CompletableFuture<VolumeUpgradeResult> future = task.getUpgradeFuture();
            volumeFutures.put(hddsVolume, future);
        }
        for (Map.Entry entry : volumeFutures.entrySet()) {
            HddsVolume hddsVolume = (HddsVolume)entry.getKey();
            CompletableFuture volumeFuture = (CompletableFuture)entry.getValue();
            try {
                VolumeUpgradeResult result = (VolumeUpgradeResult)volumeFuture.get();
                results.add(result);
                this.info("Finish upgrading containers on volume %s, %s", hddsVolume.getVolumeRootDir(), result);
            }
            catch (Exception e) {
                this.error(e, "Failed to upgrade containers on volume %s", hddsVolume.getVolumeRootDir());
            }
        }
        this.info("It took %sms to finish all volume upgrade.", Time.monotonicNow() - startTime);
        return results;
    }

    @Override
    protected RepairTool.Component serviceToBeOffline() {
        return RepairTool.Component.DATANODE;
    }

    @Override
    public void execute() throws Exception {
        OzoneConfiguration configuration = this.getOzoneConf();
        DatanodeDetails dnDetail = UpgradeUtils.getDatanodeDetails(configuration);
        Pair<HDDSLayoutFeature, HDDSLayoutFeature> layoutFeature = UpgradeUtils.getLayoutFeature(dnDetail, configuration);
        HDDSLayoutFeature softwareLayoutFeature = (HDDSLayoutFeature)layoutFeature.getLeft();
        HDDSLayoutFeature metadataLayoutFeature = (HDDSLayoutFeature)layoutFeature.getRight();
        int needLayoutVersion = HDDSLayoutFeature.DATANODE_SCHEMA_V3.layoutVersion();
        if (metadataLayoutFeature.layoutVersion() < needLayoutVersion || softwareLayoutFeature.layoutVersion() < needLayoutVersion) {
            this.fatal("Please upgrade your software version, no less than %s, current metadata layout version is %s, software layout version is %s", HDDSLayoutFeature.DATANODE_SCHEMA_V3.name(), metadataLayoutFeature.name(), softwareLayoutFeature.name());
            return;
        }
        if (!Strings.isNullOrEmpty((String)this.volume)) {
            File volumeDir = new File(this.volume);
            if (!volumeDir.exists() || !volumeDir.isDirectory()) {
                this.fatal("Volume path %s is not a directory or doesn't exist", this.volume);
                return;
            }
            File hddsRootDir = new File(volumeDir, "hdds");
            if (!hddsRootDir.exists() || !hddsRootDir.isDirectory()) {
                this.fatal("Volume path %s is not a valid data volume", this.volume);
                return;
            }
            File versionFile = new File(hddsRootDir, "VERSION");
            if (!versionFile.exists() || !versionFile.isFile()) {
                this.fatal("Version file %s does not exist", versionFile);
                return;
            }
            configuration.set("hdds.datanode.dir", this.volume);
        }
        List<HddsVolume> allVolume = UpgradeUtils.getAllVolume(dnDetail, configuration);
        Iterator<HddsVolume> volumeIterator = allVolume.iterator();
        while (volumeIterator.hasNext()) {
            HddsVolume hddsVolume = volumeIterator.next();
            if (!UpgradeUtils.isAlreadyUpgraded(hddsVolume)) continue;
            this.info("Volume " + hddsVolume.getVolumeRootDir() + " is already upgraded, skip it.", new Object[0]);
            volumeIterator.remove();
        }
        if (allVolume.isEmpty()) {
            this.info("There is no more volume to upgrade. Exit.", new Object[0]);
            return;
        }
        this.lastResults = this.run(configuration, allVolume);
    }

    List<VolumeUpgradeResult> getLastResults() {
        return this.lastResults;
    }

    private class UpgradeTask {
        private final ConfigurationSource config;
        private final HddsVolume hddsVolume;
        private DatanodeStoreSchemaThreeImpl dataStore;

        UpgradeTask(ConfigurationSource config, HddsVolume hddsVolume) {
            this.config = config;
            this.hddsVolume = hddsVolume;
        }

        public CompletableFuture<VolumeUpgradeResult> getUpgradeFuture() {
            File lockFile = UpgradeUtils.getVolumeUpgradeLockFile(this.hddsVolume);
            return CompletableFuture.supplyAsync(() -> {
                File volumeDBPath;
                VolumeUpgradeResult result = new VolumeUpgradeResult(this.hddsVolume);
                ArrayList<ContainerUpgradeResult> resultList = new ArrayList<ContainerUpgradeResult>();
                File hddsVolumeRootDir = this.hddsVolume.getHddsRootDir();
                Preconditions.checkNotNull((Object)hddsVolumeRootDir, (Object)"hddsVolumeRootDircannot be null");
                File clusterIDDir = new File(this.hddsVolume.getStorageDir(), this.hddsVolume.getClusterID());
                if (!clusterIDDir.exists() || !clusterIDDir.isDirectory()) {
                    result.fail(new Exception("Volume " + hddsVolumeRootDir + " is in an inconsistent state. Expected clusterID directory " + clusterIDDir + " is not found or not a directory."));
                    return result;
                }
                File currentDir = new File(clusterIDDir, "current");
                if (!currentDir.exists() || !currentDir.isDirectory()) {
                    result.fail(new Exception("Current dir " + currentDir + " is not found or not a directory, skip upgrade."));
                    return result;
                }
                try {
                    if (!lockFile.createNewFile()) {
                        result.fail(new Exception("Upgrade lock file already exists " + lockFile.getAbsolutePath() + ", skip upgrade."));
                        return result;
                    }
                }
                catch (IOException e) {
                    result.fail(new Exception("Failed to create upgrade lock file " + lockFile.getAbsolutePath() + ", skip upgrade."));
                    return result;
                }
                File completeFile = UpgradeUtils.getVolumeUpgradeCompleteFile(this.hddsVolume);
                if (completeFile.exists()) {
                    result.fail(new Exception("Upgrade complete file already exists " + completeFile.getAbsolutePath() + ", skip upgrade."));
                    if (!lockFile.delete()) {
                        UpgradeContainerSchema.this.error("Failed to delete upgrade lock file %s.", new Object[]{lockFile});
                    }
                    return result;
                }
                try {
                    volumeDBPath = this.getVolumeDBPath();
                    this.dbBackup(volumeDBPath);
                }
                catch (IOException e) {
                    result.fail(new Exception(e.getMessage() + ", skip upgrade."));
                    return result;
                }
                try {
                    this.hddsVolume.loadDbStore(UpgradeContainerSchema.this.isDryRun());
                    RawDB db = DatanodeStoreCache.getInstance().getDB(volumeDBPath.getAbsolutePath(), this.config);
                    this.dataStore = (DatanodeStoreSchemaThreeImpl)db.getStore();
                    result.setStore(this.dataStore);
                }
                catch (IOException e) {
                    result.fail(new Exception("Failed to load db for volume " + this.hddsVolume.getVolumeRootDir() + " for " + e.getMessage() + ", skip upgrade."));
                    return result;
                }
                UpgradeContainerSchema.this.info("Start to upgrade containers on volume %s", new Object[]{this.hddsVolume.getVolumeRootDir()});
                File[] containerTopDirs = currentDir.listFiles();
                if (containerTopDirs != null) {
                    for (File containerTopDir : containerTopDirs) {
                        try {
                            List<ContainerUpgradeResult> results = this.upgradeSubContainerDir(containerTopDir);
                            resultList.addAll(results);
                        }
                        catch (IOException e) {
                            result.fail(e);
                            return result;
                        }
                    }
                }
                result.setResultList(resultList);
                result.success();
                return result;
            }).whenComplete((r, e) -> {
                boolean deleted;
                File file = UpgradeUtils.getVolumeUpgradeCompleteFile(r.getHddsVolume());
                if (e == null && r.isSuccess()) {
                    try {
                        UpgradeUtils.createFile(file);
                    }
                    catch (IOException ioe) {
                        UpgradeContainerSchema.this.error(ioe, "Failed to create upgrade complete file %s.", new Object[]{file});
                    }
                }
                if (lockFile.exists() && !(deleted = lockFile.delete())) {
                    UpgradeContainerSchema.this.error("Failed to delete upgrade lock file %s.", new Object[]{file});
                }
            });
        }

        private List<ContainerUpgradeResult> upgradeSubContainerDir(File containerTopDir) throws IOException {
            File[] containerDirs;
            ArrayList<ContainerUpgradeResult> resultList = new ArrayList<ContainerUpgradeResult>();
            if (containerTopDir.isDirectory() && (containerDirs = containerTopDir.listFiles()) != null) {
                for (File containerDir : containerDirs) {
                    ContainerData containerData = this.parseContainerData(containerDir);
                    if (containerData == null || !((KeyValueContainerData)containerData).hasSchema("2")) continue;
                    ContainerUpgradeResult result = new ContainerUpgradeResult(containerData);
                    this.upgradeContainer(containerData, result);
                    resultList.add(result);
                }
            }
            return resultList;
        }

        private ContainerData parseContainerData(File containerDir) {
            try {
                File containerFile = ContainerUtils.getContainerFile((File)containerDir);
                long containerID = ContainerUtils.getContainerID((File)containerDir);
                if (!containerFile.exists()) {
                    UpgradeContainerSchema.this.error("Missing .container file: %s.", new Object[]{containerDir});
                    return null;
                }
                try {
                    ContainerData containerData = ContainerDataYaml.readContainerFile((File)containerFile);
                    if (containerID != containerData.getContainerID()) {
                        UpgradeContainerSchema.this.error("ContainerID in file %s mismatch with expected %s.", new Object[]{containerFile, containerID});
                        return null;
                    }
                    if (containerData.getContainerType().equals((Object)ContainerProtos.ContainerType.KeyValueContainer) && containerData instanceof KeyValueContainerData) {
                        KeyValueContainerData kvContainerData = (KeyValueContainerData)containerData;
                        containerData.setVolume(this.hddsVolume);
                        KeyValueContainerUtil.parseKVContainerData((KeyValueContainerData)kvContainerData, (ConfigurationSource)this.config);
                        return kvContainerData;
                    }
                    UpgradeContainerSchema.this.error("Container is not KeyValueContainer type: %s.", new Object[]{containerDir});
                    return null;
                }
                catch (IOException ex) {
                    UpgradeContainerSchema.this.error(ex, "Failed to parse ContainerFile: %s.", new Object[]{containerFile});
                    return null;
                }
            }
            catch (Throwable e) {
                UpgradeContainerSchema.this.error(e, "Failed to load container: %s.", new Object[]{containerDir});
                return null;
            }
        }

        private void upgradeContainer(ContainerData containerData, ContainerUpgradeResult result) throws IOException {
            DBStore targetDBStore = this.dataStore.getStore();
            DatanodeStore dbStore = BlockUtils.getUncachedDatanodeStore((KeyValueContainerData)((KeyValueContainerData)containerData), (ConfigurationSource)this.config, (boolean)true);
            DBStore sourceDBStore = dbStore.getStore();
            long total = 0L;
            for (String tableName : UpgradeUtils.COLUMN_FAMILY_NAMES) {
                total += this.transferTableData(targetDBStore, sourceDBStore, tableName, containerData);
            }
            this.rewriteAndBackupContainerDataFile(containerData, result);
            result.success(total);
        }

        private long transferTableData(DBStore targetDBStore, DBStore sourceDBStore, String tableName, ContainerData containerData) throws IOException {
            Table deleteTransactionTable = sourceDBStore.getTable(tableName);
            Table targetDeleteTransactionTable = targetDBStore.getTable(tableName);
            return this.transferTableData((Table<byte[], byte[]>)targetDeleteTransactionTable, (Table<byte[], byte[]>)deleteTransactionTable, containerData);
        }

        private long transferTableData(Table<byte[], byte[]> targetTable, Table<byte[], byte[]> sourceTable, ContainerData containerData) throws IOException {
            long count = 0L;
            try (Table.KeyValueIterator iter = sourceTable.iterator();){
                while (iter.hasNext()) {
                    ++count;
                    Table.KeyValue next = (Table.KeyValue)iter.next();
                    String key = DatanodeSchemaThreeDBDefinition.getContainerKeyPrefix((long)containerData.getContainerID()) + StringUtils.bytes2String((byte[])((byte[])next.getKey()));
                    if (UpgradeContainerSchema.this.isDryRun()) continue;
                    targetTable.put((Object)FixedLengthStringCodec.string2Bytes((String)key), (Object)((byte[])next.getValue()));
                }
            }
            return count;
        }

        private void rewriteAndBackupContainerDataFile(ContainerData containerData, ContainerUpgradeResult result) throws IOException {
            if (containerData instanceof KeyValueContainerData) {
                KeyValueContainerData keyValueContainerData = (KeyValueContainerData)containerData;
                KeyValueContainerData copyContainerData = new KeyValueContainerData(keyValueContainerData);
                copyContainerData.setSchemaVersion("3");
                copyContainerData.setState(keyValueContainerData.getState());
                copyContainerData.setVolume(keyValueContainerData.getVolume());
                File originContainerFile = KeyValueContainer.getContainerFile((String)keyValueContainerData.getMetadataPath(), (long)keyValueContainerData.getContainerID());
                File bakFile = new File(keyValueContainerData.getMetadataPath(), keyValueContainerData.getContainerID() + ".backup");
                if (UpgradeContainerSchema.this.isDryRun()) {
                    FileUtils.copyFile((File)originContainerFile, (File)bakFile);
                } else {
                    NativeIO.renameTo((File)originContainerFile, (File)bakFile);
                    ContainerDataYaml.createContainerFile((ContainerData)copyContainerData, (File)originContainerFile);
                }
                result.setBackupContainerFilePath(bakFile.getAbsolutePath());
                result.setNewContainerData((ContainerData)copyContainerData);
                result.setNewContainerFilePath(originContainerFile.getAbsolutePath());
            }
        }

        private File getVolumeDBPath() throws IOException {
            File clusterIdDir = new File(this.hddsVolume.getStorageDir(), this.hddsVolume.getClusterID());
            File storageIdDir = new File(clusterIdDir, this.hddsVolume.getStorageID());
            File containerDBPath = new File(storageIdDir, "container.db");
            if (containerDBPath.exists() && containerDBPath.isDirectory()) {
                return containerDBPath;
            }
            throw new IOException("DB " + containerDBPath + " doesn't exist or is not a directory");
        }

        private void dbBackup(File dbPath) throws IOException {
            File backup = new File(dbPath.getParentFile(), new SimpleDateFormat("yyyy-MM-dd'T'HH-mm-ss").format(new Date()) + "-" + dbPath.getName() + ".backup");
            if (backup.exists()) {
                throw new IOException("Backup dir " + backup + "already exists");
            }
            FileUtils.copyDirectory((File)dbPath, (File)backup, (boolean)true);
            System.out.println("DB " + dbPath + " is backup to " + backup);
        }
    }
}

