/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.ErrorInfo;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeysDeleteRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeysDeleteResponseWithFSO;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmKeysDeleteRequestWithFSO
extends OMKeysDeleteRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OmKeysDeleteRequestWithFSO.class);

    public OmKeysDeleteRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayout) {
        super(omRequest, bucketLayout);
    }

    @Override
    protected OmKeyInfo getOmKeyInfo(OzoneManager ozoneManager, OMMetadataManager omMetadataManager, String volumeName, String bucketName, String keyName) throws IOException {
        OzoneFileStatus keyStatus = this.getOzoneKeyStatus(ozoneManager, omMetadataManager, volumeName, bucketName, keyName);
        return keyStatus != null ? keyStatus.getKeyInfo() : null;
    }

    @Override
    protected void addKeyToAppropriateList(List<OmKeyInfo> omKeyInfoList, OmKeyInfo omKeyInfo, List<OmKeyInfo> dirList, OzoneFileStatus keyStatus) {
        if (keyStatus.isDirectory()) {
            dirList.add(omKeyInfo);
        } else {
            omKeyInfoList.add(omKeyInfo);
        }
    }

    @Override
    protected OzoneFileStatus getOzoneKeyStatus(OzoneManager ozoneManager, OMMetadataManager omMetadataManager, String volumeName, String bucketName, String keyName) throws IOException {
        return OMFileRequest.getOMKeyInfoIfExists(omMetadataManager, volumeName, bucketName, keyName, 0L, ozoneManager.getDefaultReplicationConfig());
    }

    @Override
    protected Pair<Long, Integer> markKeysAsDeletedInCache(OzoneManager ozoneManager, long trxnLogIndex, List<OmKeyInfo> omKeyInfoList, List<OmKeyInfo> dirList, OMMetadataManager omMetadataManager, Map<String, OmKeyInfo> openKeyInfoMap) throws IOException {
        long bucketId;
        long volumeId;
        long quotaReleased = 0L;
        int emptyKeys = 0;
        for (OmKeyInfo omKeyInfo : omKeyInfoList) {
            String dbOpenKey;
            volumeId = omMetadataManager.getVolumeId(omKeyInfo.getVolumeName());
            bucketId = omMetadataManager.getBucketId(omKeyInfo.getVolumeName(), omKeyInfo.getBucketName());
            long parentId = omKeyInfo.getParentObjectID();
            String fileName = omKeyInfo.getFileName();
            omMetadataManager.getKeyTable(this.getBucketLayout()).addCacheEntry(new CacheKey((Object)omMetadataManager.getOzonePathKey(volumeId, bucketId, parentId, fileName)), CacheValue.get((long)trxnLogIndex));
            emptyKeys += OmKeyInfo.isKeyEmpty((OmKeyInfo)omKeyInfo) ? 1 : 0;
            omKeyInfo.setUpdateID(trxnLogIndex);
            quotaReleased += OmKeysDeleteRequestWithFSO.sumBlockLengths(omKeyInfo);
            String hsyncClientId = (String)omKeyInfo.getMetadata().get("hsyncClientId");
            if (hsyncClientId == null) continue;
            Table openKeyTable = omMetadataManager.getOpenKeyTable(this.getBucketLayout());
            OmKeyInfo openKeyInfo = (OmKeyInfo)openKeyTable.get((Object)(dbOpenKey = omMetadataManager.getOpenFileName(volumeId, bucketId, parentId, fileName, hsyncClientId)));
            if (openKeyInfo != null) {
                openKeyInfo.getMetadata().put("deletedHsyncKey", "true");
                openKeyTable.addCacheEntry((Object)dbOpenKey, (Object)openKeyInfo, trxnLogIndex);
                openKeyInfoMap.put(dbOpenKey, openKeyInfo);
                continue;
            }
            LOG.warn("Potentially inconsistent DB state: open key not found with dbOpenKey '{}'", (Object)dbOpenKey);
        }
        for (OmKeyInfo omKeyInfo : dirList) {
            volumeId = omMetadataManager.getVolumeId(omKeyInfo.getVolumeName());
            bucketId = omMetadataManager.getBucketId(omKeyInfo.getVolumeName(), omKeyInfo.getBucketName());
            omMetadataManager.getDirectoryTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getOzonePathKey(volumeId, bucketId, omKeyInfo.getParentObjectID(), omKeyInfo.getFileName())), CacheValue.get((long)trxnLogIndex));
            omKeyInfo.setUpdateID(trxnLogIndex);
            quotaReleased += OmKeysDeleteRequestWithFSO.sumBlockLengths(omKeyInfo);
        }
        return Pair.of((Object)quotaReleased, (Object)emptyKeys);
    }

    @Override
    @Nonnull
    protected OMClientResponse getOmClientResponse(OzoneManager ozoneManager, List<OmKeyInfo> omKeyInfoList, List<OmKeyInfo> dirList, OzoneManagerProtocolProtos.OMResponse.Builder omResponse, OzoneManagerProtocolProtos.DeleteKeyArgs.Builder unDeletedKeys, Map<String, ErrorInfo> keyToErrors, boolean deleteStatus, OmBucketInfo omBucketInfo, long volumeId, Map<String, OmKeyInfo> openKeyInfoMap) {
        ArrayList<OzoneManagerProtocolProtos.DeleteKeyError> deleteKeyErrors = new ArrayList<OzoneManagerProtocolProtos.DeleteKeyError>();
        for (Map.Entry<String, ErrorInfo> key : keyToErrors.entrySet()) {
            deleteKeyErrors.add(OzoneManagerProtocolProtos.DeleteKeyError.newBuilder().setKey(key.getKey()).setErrorCode(key.getValue().getCode()).setErrorMsg(key.getValue().getMessage()).build());
        }
        OMKeysDeleteResponseWithFSO omClientResponse = new OMKeysDeleteResponseWithFSO(omResponse.setDeleteKeysResponse(OzoneManagerProtocolProtos.DeleteKeysResponse.newBuilder().setStatus(deleteStatus).setUnDeletedKeys(unDeletedKeys).addAllErrors(deleteKeyErrors)).setStatus(deleteStatus ? OzoneManagerProtocolProtos.Status.OK : OzoneManagerProtocolProtos.Status.PARTIAL_DELETE).setSuccess(deleteStatus).build(), omKeyInfoList, dirList, omBucketInfo.copyObject(), volumeId, openKeyInfoMap);
        return omClientResponse;
    }
}

