/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.multipart;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.Map;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.helpers.QuotaUtil;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OMMultipartUploadUtils;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.validation.RequestFeatureValidator;
import org.apache.hadoop.ozone.om.request.validation.ValidationCondition;
import org.apache.hadoop.ozone.om.request.validation.ValidationContext;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.multipart.S3MultipartUploadAbortResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeature;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.request.validation.RequestProcessingPhase;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3MultipartUploadAbortRequest
extends OMKeyRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        S3MultipartUploadAbortRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(S3MultipartUploadAbortRequest.class);
    }

    public S3MultipartUploadAbortRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    public S3MultipartUploadAbortRequest(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayout) {
        super(omRequest, bucketLayout);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.KeyArgs keyArgs = super.preExecute(ozoneManager).getAbortMultiPartUploadRequest().getKeyArgs();
        String keyPath = keyArgs.getKeyName();
        keyPath = S3MultipartUploadAbortRequest.validateAndNormalizeKey(ozoneManager.getEnableFileSystemPaths(), keyPath, this.getBucketLayout());
        OzoneManagerProtocolProtos.KeyArgs newKeyArgs = keyArgs.toBuilder().setModificationTime(Time.now()).setKeyName(keyPath).build();
        OzoneManagerProtocolProtos.KeyArgs resolvedArgs = this.resolveBucketAndCheckKeyAcls(newKeyArgs, ozoneManager, IAccessAuthorizer.ACLType.WRITE);
        return this.getOmRequest().toBuilder().setAbortMultiPartUploadRequest(this.getOmRequest().getAbortMultiPartUploadRequest().toBuilder().setKeyArgs(resolvedArgs)).setUserInfo(this.getUserInfo()).build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        OMClientRequest.Result result;
        OMClientResponse omClientResponse;
        Exception exception;
        String keyName;
        String bucketName;
        String volumeName;
        Map<String, String> auditMap;
        OzoneManagerProtocolProtos.MultipartUploadAbortRequest multipartUploadAbortRequest;
        block19: {
            long trxnLogIndex = context.getIndex();
            multipartUploadAbortRequest = this.getOmRequest().getAbortMultiPartUploadRequest();
            OzoneManagerProtocolProtos.KeyArgs keyArgs = multipartUploadAbortRequest.getKeyArgs();
            auditMap = this.buildKeyArgsAuditMap(keyArgs);
            auditMap.put("uploadID", keyArgs.getMultipartUploadID());
            volumeName = keyArgs.getVolumeName();
            bucketName = keyArgs.getBucketName();
            String requestedVolume = volumeName;
            String requestedBucket = bucketName;
            keyName = keyArgs.getKeyName();
            ozoneManager.getMetrics().incNumAbortMultipartUploads();
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean acquiredLock = false;
            exception = null;
            OmMultipartKeyInfo multipartKeyInfo = null;
            String multipartKey = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            omClientResponse = null;
            result = null;
            OmBucketInfo omBucketInfo = null;
            try {
                try {
                    String multipartOpenKey;
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    acquiredLock = this.getOmLockDetails().isLockAcquired();
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    multipartKey = omMetadataManager.getMultipartKey(volumeName, bucketName, keyName, keyArgs.getMultipartUploadID());
                    try {
                        multipartOpenKey = this.getMultipartOpenKey(keyArgs.getMultipartUploadID(), volumeName, bucketName, keyName, omMetadataManager);
                    }
                    catch (OMException ome) {
                        throw new OMException("Abort Multipart Upload Failed: volume: " + requestedVolume + ", bucket: " + requestedBucket + ", key: " + keyName, (Throwable)ome, OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
                    }
                    OmKeyInfo omKeyInfo = (OmKeyInfo)omMetadataManager.getOpenKeyTable(this.getBucketLayout()).get((Object)multipartOpenKey);
                    omBucketInfo = S3MultipartUploadAbortRequest.getBucketInfo(omMetadataManager, volumeName, bucketName);
                    if (omKeyInfo == null) {
                        throw new OMException("Abort Multipart Upload Failed: volume: " + requestedVolume + "bucket: " + requestedBucket + "key: " + keyName, OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
                    }
                    multipartKeyInfo = (OmMultipartKeyInfo)omMetadataManager.getMultipartInfoTable().get((Object)multipartKey);
                    multipartKeyInfo.setUpdateID(trxnLogIndex);
                    long quotaReleased = 0L;
                    for (OzoneManagerProtocolProtos.PartKeyInfo iterPartKeyInfo : multipartKeyInfo.getPartKeyInfoMap()) {
                        quotaReleased += QuotaUtil.getReplicatedSize((long)iterPartKeyInfo.getPartKeyInfo().getDataSize(), (ReplicationConfig)omKeyInfo.getReplicationConfig());
                    }
                    omBucketInfo.incrUsedBytes(-quotaReleased);
                    omMetadataManager.getOpenKeyTable(this.getBucketLayout()).addCacheEntry(new CacheKey((Object)multipartOpenKey), CacheValue.get((long)trxnLogIndex));
                    omMetadataManager.getMultipartInfoTable().addCacheEntry(new CacheKey((Object)multipartKey), CacheValue.get((long)trxnLogIndex));
                    omClientResponse = this.getOmClientResponse(ozoneManager, multipartKeyInfo, multipartKey, multipartOpenKey, omResponse, omBucketInfo);
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException | InvalidPathException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = this.getOmClientResponse(exception, omResponse);
                    if (acquiredLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (acquiredLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquiredLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        this.markForAudit(ozoneManager.getAuditLogger(), this.buildAuditMessage(OMAction.ABORT_MULTIPART_UPLOAD, auditMap, exception, this.getOmRequest().getUserInfo()));
        switch (result) {
            case SUCCESS: {
                LOG.debug("Abort Multipart request is successfully completed for KeyName {} in VolumeName/Bucket {}/{}", new Object[]{keyName, volumeName, bucketName});
                break;
            }
            case FAILURE: {
                ozoneManager.getMetrics().incNumAbortMultipartUploadFails();
                LOG.error("Abort Multipart request is failed for KeyName {} in VolumeName/Bucket {}/{}", new Object[]{keyName, volumeName, bucketName, exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for S3MultipartUploadAbortRequest: {}", (Object)multipartUploadAbortRequest);
            }
        }
        return omClientResponse;
    }

    protected OMClientResponse getOmClientResponse(Exception exception, OzoneManagerProtocolProtos.OMResponse.Builder omResponse) {
        return new S3MultipartUploadAbortResponse(this.createErrorOMResponse(omResponse, exception), this.getBucketLayout());
    }

    protected OMClientResponse getOmClientResponse(OzoneManager ozoneManager, OmMultipartKeyInfo multipartKeyInfo, String multipartKey, String multipartOpenKey, OzoneManagerProtocolProtos.OMResponse.Builder omResponse, OmBucketInfo omBucketInfo) {
        S3MultipartUploadAbortResponse omClientResponse = new S3MultipartUploadAbortResponse(omResponse.setAbortMultiPartUploadResponse(OzoneManagerProtocolProtos.MultipartUploadAbortResponse.newBuilder()).build(), multipartKey, multipartOpenKey, multipartKeyInfo, omBucketInfo.copyObject(), this.getBucketLayout());
        return omClientResponse;
    }

    protected String getMultipartOpenKey(String multipartUploadID, String volumeName, String bucketName, String keyName, OMMetadataManager omMetadataManager) throws IOException {
        return OMMultipartUploadUtils.getMultipartOpenKey(volumeName, bucketName, keyName, multipartUploadID, omMetadataManager, this.getBucketLayout());
    }

    @RequestFeatureValidator(conditions={ValidationCondition.CLUSTER_NEEDS_FINALIZATION}, processingPhase=RequestProcessingPhase.PRE_PROCESS, requestType=OzoneManagerProtocolProtos.Type.AbortMultiPartUpload)
    public static OzoneManagerProtocolProtos.OMRequest disallowAbortMultiPartUploadWithECReplicationConfig(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) throws OMException {
        if (!ctx.versionManager().isAllowed((LayoutFeature)OMLayoutFeature.ERASURE_CODED_STORAGE_SUPPORT) && req.getAbortMultiPartUploadRequest().getKeyArgs().hasEcReplicationConfig()) {
            throw new OMException("Cluster does not have the Erasure Coded Storage support feature finalized yet, but the request contains an Erasure Coded replication type. Rejecting the request, please finalize the cluster upgrade and then try again.", OMException.ResultCodes.NOT_SUPPORTED_OPERATION_PRIOR_FINALIZATION);
        }
        return req;
    }

    @RequestFeatureValidator(conditions={ValidationCondition.OLDER_CLIENT_REQUESTS}, processingPhase=RequestProcessingPhase.PRE_PROCESS, requestType=OzoneManagerProtocolProtos.Type.AbortMultiPartUpload)
    public static OzoneManagerProtocolProtos.OMRequest blockMPUAbortWithBucketLayoutFromOldClient(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs;
        if (req.getAbortMultiPartUploadRequest().hasKeyArgs() && (keyArgs = req.getAbortMultiPartUploadRequest().getKeyArgs()).hasVolumeName() && keyArgs.hasBucketName()) {
            BucketLayout bucketLayout = ctx.getBucketLayout(keyArgs.getVolumeName(), keyArgs.getBucketName());
            bucketLayout.validateSupportedOperation();
        }
        return req;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("S3MultipartUploadAbortRequest.java", S3MultipartUploadAbortRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.s3.multipart.S3MultipartUploadAbortRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 79);
    }
}

