/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import java.util.List;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.node.NodeManager;

public interface ContainerReplicaCount {
    public ContainerInfo getContainer();

    public List<ContainerReplica> getReplicas();

    public boolean isSufficientlyReplicated();

    public boolean isSufficientlyReplicatedForOffline(DatanodeDetails var1, NodeManager var2);

    public boolean isOverReplicated();

    public int getDecommissionCount();

    public int getMaintenanceCount();

    default public boolean isHealthy() {
        HddsProtos.LifeCycleState containerState = this.getContainer().getState();
        return (containerState == HddsProtos.LifeCycleState.CLOSED || containerState == HddsProtos.LifeCycleState.QUASI_CLOSED) && this.getReplicas().stream().filter(r -> r.getDatanodeDetails().getPersistedOpState() == HddsProtos.NodeOperationalState.IN_SERVICE).allMatch(r -> ReplicationManager.compareState(containerState, r.getState()));
    }

    public boolean isHealthyEnoughForOffline();

    public boolean isUnrecoverable();
}

