/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.checksum;

import java.util.Objects;
import org.apache.hadoop.ozone.container.checksum.DNContainerOperationClient;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.hadoop.ozone.container.replication.AbstractReplicationTask;
import org.apache.hadoop.ozone.protocol.commands.ReconcileContainerCommand;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconcileContainerTask
extends AbstractReplicationTask {
    private final ReconcileContainerCommand command;
    private final DNContainerOperationClient dnClient;
    private final ContainerController controller;
    private static final Logger LOG = LoggerFactory.getLogger(ReconcileContainerTask.class);

    public ReconcileContainerTask(ContainerController controller, DNContainerOperationClient dnClient, ReconcileContainerCommand command) {
        super(command.getContainerID(), command.getDeadline(), command.getTerm());
        this.command = command;
        this.controller = controller;
        this.dnClient = dnClient;
    }

    @Override
    public void runTask() {
        long start = Time.monotonicNow();
        LOG.info("{}", (Object)this);
        try {
            this.controller.reconcileContainer(this.dnClient, this.command.getContainerID(), this.command.getPeerDatanodes());
            this.setStatus(AbstractReplicationTask.Status.DONE);
            long elapsed = Time.monotonicNow() - start;
            LOG.info("{} completed in {} ms", (Object)this, (Object)elapsed);
        }
        catch (Exception e) {
            long elapsed = Time.monotonicNow() - start;
            this.setStatus(AbstractReplicationTask.Status.FAILED);
            LOG.warn("{} failed in {} ms", new Object[]{this, elapsed, e});
        }
    }

    @Override
    protected Object getCommandForDebug() {
        return this.command.toString();
    }

    @Override
    public String getMetricName() {
        return "ContainerReconciliations";
    }

    @Override
    public String getMetricDescriptionSegment() {
        return "Container Reconciliations";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReconcileContainerTask that = (ReconcileContainerTask)o;
        return Objects.equals(this.command, that.command);
    }

    public int hashCode() {
        return Objects.hash(this.getContainerId());
    }
}

