/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import java.io.IOException;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckFactory;
import org.apache.hadoop.ozone.container.common.volume.DbVolume;
import org.apache.hadoop.ozone.container.common.volume.MutableVolumeSet;
import org.apache.hadoop.ozone.container.common.volume.StorageVolume;
import org.apache.hadoop.ozone.container.common.volume.StorageVolumeFactory;

public class DbVolumeFactory
extends StorageVolumeFactory {
    public DbVolumeFactory(ConfigurationSource conf, SpaceUsageCheckFactory usageCheckFactory, MutableVolumeSet volumeSet, String datanodeUuid, String clusterID) {
        super(conf, usageCheckFactory, volumeSet, datanodeUuid, clusterID);
    }

    @Override
    StorageVolume createVolume(String locationString, StorageType storageType) throws IOException {
        DbVolume.Builder volumeBuilder = (DbVolume.Builder)((DbVolume.Builder)((DbVolume.Builder)((DbVolume.Builder)((DbVolume.Builder)((DbVolume.Builder)new DbVolume.Builder(locationString).conf(this.getConf())).datanodeUuid(this.getDatanodeUuid())).clusterID(this.getClusterID())).usageCheckFactory(this.getUsageCheckFactory())).storageType(storageType)).volumeSet(this.getVolumeSet());
        DbVolume volume = volumeBuilder.build();
        this.checkAndSetClusterID(volume.getClusterID());
        return volume;
    }

    @Override
    StorageVolume createFailedVolume(String locationString) throws IOException {
        DbVolume.Builder volumeBuilder = (DbVolume.Builder)new DbVolume.Builder(locationString).failedVolume(true);
        return volumeBuilder.build();
    }
}

