/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.stream;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.hadoop.ozone.container.stream.StreamingException;
import org.apache.hadoop.ozone.container.stream.StreamingSource;

public class DirectoryServerSource
implements StreamingSource {
    private Path root;

    public DirectoryServerSource(Path root) {
        this.root = root;
    }

    @Override
    public Map<String, Path> getFilesToStream(String id) throws InterruptedException {
        HashMap<String, Path> files = new HashMap<String, Path>();
        Path streamingDir = this.root.resolve(id);
        try (Stream<Path> list = Files.walk(streamingDir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));){
            list.forEach(path -> files.put(this.root.relativize((Path)path).toString(), (Path)path));
        }
        catch (IOException e) {
            throw new StreamingException("Couldn't read directory for streaming: " + streamingDir, e);
        }
        return files;
    }
}

