/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.erasurecode.rawcoder;

import java.nio.ByteBuffer;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.ozone.erasurecode.rawcoder.ByteBufferEncodingState;
import org.apache.ozone.erasurecode.rawcoder.CoderUtil;
import org.apache.ozone.erasurecode.rawcoder.EncodingState;
import org.apache.ozone.erasurecode.rawcoder.RawErasureEncoder;

@InterfaceAudience.Private
class ByteArrayEncodingState
extends EncodingState {
    byte[][] inputs;
    byte[][] outputs;
    int[] inputOffsets;
    int[] outputOffsets;

    ByteArrayEncodingState(RawErasureEncoder encoder, byte[][] inputs, byte[][] outputs) {
        this.encoder = encoder;
        byte[] validInput = (byte[])CoderUtil.findFirstValidInput(inputs);
        this.encodeLength = validInput.length;
        this.inputs = inputs;
        this.outputs = outputs;
        this.checkParameters((T[])inputs, (T[])outputs);
        this.checkBuffers(inputs);
        this.checkBuffers(outputs);
        this.inputOffsets = new int[inputs.length];
        this.outputOffsets = new int[outputs.length];
    }

    ByteArrayEncodingState(RawErasureEncoder encoder, int encodeLength, byte[][] inputs, int[] inputOffsets, byte[][] outputs, int[] outputOffsets) {
        this.encoder = encoder;
        this.encodeLength = encodeLength;
        this.inputs = inputs;
        this.outputs = outputs;
        this.inputOffsets = inputOffsets;
        this.outputOffsets = outputOffsets;
    }

    ByteBufferEncodingState convertToByteBufferState() {
        int i;
        ByteBuffer[] newInputs = new ByteBuffer[this.inputs.length];
        ByteBuffer[] newOutputs = new ByteBuffer[this.outputs.length];
        for (i = 0; i < this.inputs.length; ++i) {
            newInputs[i] = CoderUtil.cloneAsDirectByteBuffer(this.inputs[i], this.inputOffsets[i], this.encodeLength);
        }
        for (i = 0; i < this.outputs.length; ++i) {
            newOutputs[i] = ByteBuffer.allocateDirect(this.encodeLength);
        }
        ByteBufferEncodingState bbeState = new ByteBufferEncodingState(this.encoder, this.encodeLength, newInputs, newOutputs);
        return bbeState;
    }

    void checkBuffers(byte[][] buffers) {
        for (byte[] buffer : buffers) {
            if (buffer == null) {
                throw new IllegalArgumentException("Invalid buffer found, not allowing null");
            }
            if (buffer.length == this.encodeLength) continue;
            throw new IllegalArgumentException("Invalid buffer not of length " + this.encodeLength);
        }
    }
}

