/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.tenant;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.om.helpers.TenantUserInfoValue;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.tenant.TenantHandler;
import picocli.CommandLine;

@CommandLine.Command(name="info", description={"Get tenant related information of a user"})
public class GetUserInfoHandler
extends TenantHandler {
    @CommandLine.Parameters(description={"User name (principal)"}, arity="1..1")
    private String userPrincipal;
    @CommandLine.Option(names={"--json", "-j"}, description={"Print result in JSON"})
    private boolean printJson;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        TenantUserInfoValue tenantUserInfo = client.getObjectStore().tenantGetUserInfo(this.userPrincipal);
        List accessIdInfoList = tenantUserInfo.getAccessIdInfoList();
        if (accessIdInfoList.isEmpty()) {
            this.err().println("User '" + this.userPrincipal + "' is not assigned to any tenant.");
            return;
        }
        if (!this.printJson) {
            this.out().println("User '" + this.userPrincipal + "' is assigned to:");
            accessIdInfoList.forEach(accessIdInfo -> {
                String adminInfoString = accessIdInfo.getIsAdmin() ? (accessIdInfo.getIsDelegatedAdmin() ? " delegated admin" : " admin") : "";
                this.out().format("- Tenant '%s'%s with accessId '%s'%n", accessIdInfo.getTenantId(), adminInfoString, accessIdInfo.getAccessId());
            });
        } else {
            ObjectNode resObj = JsonUtils.createObjectNode(null);
            resObj.put("user", this.userPrincipal);
            ArrayNode arr = JsonUtils.createArrayNode();
            accessIdInfoList.forEach(accessIdInfo -> {
                ObjectNode tenantObj = JsonUtils.createObjectNode(null);
                tenantObj.put("accessId", accessIdInfo.getAccessId());
                tenantObj.put("tenantId", accessIdInfo.getTenantId());
                tenantObj.put("isAdmin", accessIdInfo.getIsAdmin());
                tenantObj.put("isDelegatedAdmin", accessIdInfo.getIsDelegatedAdmin());
                arr.add((JsonNode)tenantObj);
            });
            resObj.set("tenants", (JsonNode)arr);
            String prettyJson = JsonUtils.toJsonStringWithDefaultPrettyPrinter((Object)resObj);
            this.out().println(prettyJson);
        }
    }
}

