/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ratis.util.function.CheckedFunction;

public final class CliUtils {
    private CliUtils() {
    }

    public static RaftPeerId getPeerId(InetSocketAddress address) {
        return CliUtils.getPeerId(address.getHostString(), address.getPort());
    }

    public static RaftPeerId getPeerId(String host, int port) {
        return RaftPeerId.getRaftPeerId((String)(host + "_" + port));
    }

    private static <PARAMETER, RETURN, EXCEPTION extends Throwable> RETURN applyFunctionReturnFirstNonNull(Collection<PARAMETER> list, CheckedFunction<PARAMETER, RETURN, EXCEPTION> function, PrintStream out) {
        for (PARAMETER parameter : list) {
            try {
                Object ret = function.apply(parameter);
                if (ret == null) continue;
                return (RETURN)ret;
            }
            catch (Throwable e) {
                e.printStackTrace(out);
            }
        }
        return null;
    }

    public static List<RaftPeer> parseRaftPeers(String peers) {
        String[] peersArray;
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        for (String peer : peersArray = peers.split(",")) {
            addresses.add(CliUtils.parseInetSocketAddress(peer));
        }
        return addresses.stream().map(addr -> RaftPeer.newBuilder().setId(CliUtils.getPeerId(addr)).setAddress(addr).build()).collect(Collectors.toList());
    }

    public static RaftGroupId parseRaftGroupId(String groupId) {
        return groupId != null && groupId.isEmpty() ? RaftGroupId.valueOf((UUID)UUID.fromString(groupId)) : null;
    }

    public static RaftGroupId getGroupId(RaftClient client, List<RaftPeer> peers, RaftGroupId groupId, PrintStream err) throws IOException {
        if (groupId != null) {
            return groupId;
        }
        List groupIds = (List)CliUtils.applyFunctionReturnFirstNonNull(peers, p -> client.getGroupManagementApi(p.getId()).list().getGroupIds(), err);
        if (groupIds == null) {
            String message = "Failed to get group ID from " + peers;
            err.println("Failed to get group ID from " + peers);
            throw new IOException(message);
        }
        if (groupIds.size() == 1) {
            return (RaftGroupId)groupIds.get(0);
        }
        String message = "Unexpected multiple group IDs " + groupIds + ".  In such case, the target group ID must be specified.";
        err.println(message);
        throw new IOException(message);
    }

    public static GroupInfoReply getGroupInfo(RaftClient client, List<RaftPeer> peers, RaftGroupId groupId, PrintStream err) throws IOException {
        GroupInfoReply groupInfoReply = (GroupInfoReply)CliUtils.applyFunctionReturnFirstNonNull(peers, p -> client.getGroupManagementApi(p.getId()).info(groupId), err);
        CliUtils.checkReply((RaftClientReply)groupInfoReply, () -> "Failed to get group info for " + groupId.getUuid() + " from " + peers, err);
        return groupInfoReply;
    }

    public static void checkReply(RaftClientReply reply, Supplier<String> message, PrintStream printStream) throws IOException {
        if (reply == null || !reply.isSuccess()) {
            RaftException e = Optional.ofNullable(reply).map(RaftClientReply::getException).orElseGet(() -> new RaftException("Reply: " + reply));
            printStream.println(message.get());
            throw new IOException(message.get(), (Throwable)e);
        }
    }

    public static InetSocketAddress parseInetSocketAddress(String address) {
        try {
            String[] hostPortPair = address.split(":");
            if (hostPortPair.length < 2) {
                throw new IllegalArgumentException("Unexpected address format <HOST:PORT>.");
            }
            return new InetSocketAddress(hostPortPair[0], Integer.parseInt(hostPortPair[1]));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse the server address parameter \"" + address + "\".", e);
        }
    }
}

