/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server.http;

import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

@InterfaceAudience.Private
public final class HttpServer2Metrics
implements MetricsSource {
    public static final String SOURCE_NAME = HttpServer2Metrics.class.getSimpleName();
    public static final String NAME = HttpServer2Metrics.class.getSimpleName();
    private final QueuedThreadPool threadPool;
    private final String name;

    private HttpServer2Metrics(QueuedThreadPool threadPool, String name) {
        this.threadPool = threadPool;
        this.name = name;
    }

    public static HttpServer2Metrics create(QueuedThreadPool threadPool, String name) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (HttpServer2Metrics)ms.register(NAME, "HttpServer2 Metrics", (Object)new HttpServer2Metrics(threadPool, name));
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder recordBuilder = collector.addRecord(SOURCE_NAME).setContext("HttpServer2").tag((MetricsInfo)HttpServer2MetricsInfo.SERVER_NAME, this.name);
        recordBuilder.addGauge((MetricsInfo)HttpServer2MetricsInfo.HttpServerThreadCount, this.threadPool.getThreads()).addGauge((MetricsInfo)HttpServer2MetricsInfo.HttpServerIdleThreadCount, this.threadPool.getIdleThreads()).addGauge((MetricsInfo)HttpServer2MetricsInfo.HttpServerMaxThreadCount, this.threadPool.getMaxThreads()).addGauge((MetricsInfo)HttpServer2MetricsInfo.HttpServerThreadQueueWaitingTaskCount, this.threadPool.getQueueSize());
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(NAME);
    }

    static enum HttpServer2MetricsInfo implements MetricsInfo
    {
        SERVER_NAME("HttpServer2 Metrics."),
        HttpServerThreadCount("Number of threads in the pool."),
        HttpServerIdleThreadCount("Number of idle threads but not reserved."),
        HttpServerMaxThreadCount("Maximum number of threads in the pool."),
        HttpServerThreadQueueWaitingTaskCount("The number of jobs in the queue waiting for a thread");

        private final String desc;

        private HttpServer2MetricsInfo(String desc) {
            this.desc = desc;
        }

        public String description() {
            return this.desc;
        }
    }
}

