/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;

@Metrics(about="CPU Metrics", context="ozone")
public class CpuMetrics
implements MetricsSource {
    public static final String SOURCE = "JvmMetricsCpu";
    private final OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();

    public static void create() {
        if (DefaultMetricsSystem.instance().getSource(SOURCE) == null) {
            DefaultMetricsSystem.instance().register(SOURCE, "CPU Metrics", (Object)new CpuMetrics());
        }
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder builder = collector.addRecord(SOURCE);
        builder.addGauge(Interns.info((String)"jvmLoad", (String)"JVM CPU Load"), this.operatingSystemMXBean.getProcessCpuLoad()).addGauge(Interns.info((String)"systemLoad", (String)"System CPU Load"), this.operatingSystemMXBean.getSystemCpuLoad()).addGauge(Interns.info((String)"availableProcessors", (String)"Available processors"), this.operatingSystemMXBean.getAvailableProcessors());
    }
}

