/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hdds.utils.db.CodecBuffer;
import org.apache.hadoop.hdds.utils.db.PutToByteBuffer;
import org.apache.hadoop.hdds.utils.db.RDBStoreAbstractIterator;
import org.apache.hadoop.hdds.utils.db.RDBTable;
import org.apache.hadoop.hdds.utils.db.RocksDatabaseException;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksIterator;
import org.apache.ratis.util.Preconditions;
import org.rocksdb.RocksIterator;

class RDBStoreCodecBufferIterator
extends RDBStoreAbstractIterator<CodecBuffer> {
    private final Buffer keyBuffer;
    private final Buffer valueBuffer;
    private final AtomicBoolean closed = new AtomicBoolean();

    RDBStoreCodecBufferIterator(ManagedRocksIterator iterator, RDBTable table, CodecBuffer prefix, Table.KeyValueIterator.Type type) {
        super(iterator, table, prefix, type);
        String name = table != null ? table.getName() : null;
        this.keyBuffer = new Buffer(new CodecBuffer.Capacity((Object)(name + "-iterator-key"), 1024), (PutToByteBuffer<RuntimeException>)(this.getType().readKey() || prefix != null ? buffer -> ((RocksIterator)this.getRocksDBIterator().get()).key(buffer) : null));
        this.valueBuffer = new Buffer(new CodecBuffer.Capacity((Object)(name + "-iterator-value"), 4096), (PutToByteBuffer<RuntimeException>)(this.getType().readValue() ? buffer -> ((RocksIterator)this.getRocksDBIterator().get()).value(buffer) : null));
        this.seekToFirst();
    }

    void assertOpen() {
        Preconditions.assertTrue((!this.closed.get() ? 1 : 0) != 0, (Object)"Already closed");
    }

    @Override
    CodecBuffer key() {
        this.assertOpen();
        return this.keyBuffer.getFromDb();
    }

    @Override
    Table.KeyValue<CodecBuffer, CodecBuffer> getKeyValue() {
        this.assertOpen();
        CodecBuffer key = this.getType().readKey() ? this.key() : null;
        return Table.newKeyValue(key, this.valueBuffer.getFromDb());
    }

    @Override
    void seek0(CodecBuffer key) {
        this.assertOpen();
        ((RocksIterator)this.getRocksDBIterator().get()).seek(key.asReadOnlyByteBuffer());
    }

    @Override
    void delete(CodecBuffer key) throws RocksDatabaseException {
        this.assertOpen();
        this.getRocksDBTable().delete(key.asReadOnlyByteBuffer());
    }

    @Override
    boolean startsWithPrefix(CodecBuffer key) {
        this.assertOpen();
        CodecBuffer prefix = (CodecBuffer)this.getPrefix();
        if (prefix == null) {
            return true;
        }
        if (key == null) {
            return false;
        }
        return key.startsWith(prefix);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            super.close();
            Optional.ofNullable((CodecBuffer)this.getPrefix()).ifPresent(CodecBuffer::release);
            this.keyBuffer.release();
            this.valueBuffer.release();
        }
    }

    static class Buffer {
        private final CodecBuffer.Capacity initialCapacity;
        private final PutToByteBuffer<RuntimeException> source;
        private CodecBuffer buffer;

        Buffer(CodecBuffer.Capacity initialCapacity, PutToByteBuffer<RuntimeException> source) {
            this.initialCapacity = initialCapacity;
            this.source = source;
        }

        void release() {
            if (this.buffer != null) {
                this.buffer.release();
            }
        }

        private void prepare() {
            if (this.buffer == null) {
                this.allocate();
            } else {
                this.buffer.clear();
            }
        }

        private void allocate() {
            if (this.buffer != null) {
                this.buffer.release();
            }
            this.buffer = CodecBuffer.allocateDirect((int)(-this.initialCapacity.get()));
        }

        CodecBuffer getFromDb() {
            if (this.source == null) {
                return null;
            }
            this.prepare();
            Integer required;
            while ((required = this.buffer.putFromSource(this.source)) != null) {
                if (required.intValue() == this.buffer.readableBytes()) {
                    return this.buffer;
                }
                if (this.buffer.setCapacity(required.intValue())) {
                    this.buffer.clear();
                    int retried = this.buffer.putFromSource(this.source);
                    Preconditions.assertSame((int)required, (int)retried, (String)"required");
                    return this.buffer;
                }
                this.initialCapacity.increase(required.intValue());
                this.allocate();
            }
            return null;
        }
    }
}

